/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.web.authentication.SilverpeasSessionOpener;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.mvc.webcomponent.SilverpeasHttpServlet;
import org.silverpeas.core.web.token.SynchronizerTokenService;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;

public class SilverpeasAuthenticatedHttpServlet
extends SilverpeasHttpServlet {
    private static final long serialVersionUID = 3879578969267125005L;
    @Inject
    private SilverpeasSessionOpener silverpeasSessionOpener;
    @Inject
    private SynchronizerTokenService tokenService;

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(false);
        try {
            MainSessionController mainSessionCtrl = null;
            if (session != null) {
                mainSessionCtrl = (MainSessionController)session.getAttribute("SilverSessionController");
            }
            if (mainSessionCtrl == null) {
                this.throwUserSessionExpiration();
            } else {
                this.verifyUserAuthentication(mainSessionCtrl);
                super.service(request, response);
            }
        }
        catch (UserSessionExpirationException e) {
            SilverLogger.getLogger((Object)((Object)this)).debug(e.getMessage(), new Object[]{e});
            if (session != null) {
                SilverLogger.getLogger((Object)((Object)this)).warn("NewSessionId={0}", new Object[]{session.getId()});
                this.silverpeasSessionOpener.closeSession(session);
            }
            this.redirectOrForwardService(request, response, ResourceLocator.getGeneralSettingBundle().getString("sessionTimeout"));
        }
    }

    private void verifyUserAuthentication(MainSessionController mainSessionCtrl) {
        try {
            AuthenticationUserVerifierFactory.getUserCanLoginVerifier((User)mainSessionCtrl.getCurrentUserDetail()).verify();
        }
        catch (AuthenticationException e) {
            SilverLogger.getLogger((Object)((Object)this)).debug(e.getMessage(), new Object[]{e});
            this.throwUserSessionExpiration();
        }
    }

    protected void renewSessionSecurityToken(HttpServletRequest request) {
        SessionInfo sessionInfo = SessionManagementProvider.getSessionManagement().getSessionInfo(this.getMainSessionController(request).getSessionId());
        this.getSynchronizerTokenService().setUpSessionTokens(sessionInfo);
    }

    protected void throwUserSessionExpiration() {
        throw new UserSessionExpirationException();
    }

    protected MainSessionController getMainSessionController(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (MainSessionController)session.getAttribute("SilverSessionController");
        }
        return null;
    }

    protected SynchronizerTokenService getSynchronizerTokenService() {
        return this.tokenService;
    }

    protected SessionInfo getSessionInfo(HttpServletRequest request) {
        return SessionManagementProvider.getSessionManagement().getSessionInfo(this.getMainSessionController(request).getSessionId());
    }

    private static class UserSessionExpirationException
    extends RuntimeException {
        private static final long serialVersionUID = -7476590253287182372L;

        private UserSessionExpirationException() {
        }
    }
}

