/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import org.silverpeas.core.admin.component.constant.ComponentInstanceParameterName;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.clipboard.ClipboardException;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.mvc.controller.ComponentContext;
import org.silverpeas.core.web.mvc.controller.ComponentSessionController;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.selection.Selection;
import org.silverpeas.core.web.session.SessionCloseable;
import org.silverpeas.core.web.subscription.SubscriptionContext;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractComponentSessionController
implements ComponentSessionController,
SessionCloseable {
    private static final long serialVersionUID = -6941005626660183283L;
    private static final String CHARACTER_ENCODING = "UTF-8";
    protected ComponentContext context;
    private final MainSessionController controller;
    private String rootName = null;
    private LocalizationBundle message = null;
    private SettingBundle icon = null;
    private String messageLanguage = null;
    private String messageFile = null;
    private String iconFile = null;
    private SettingBundle settings = null;
    private String settingsFile = null;

    public AbstractComponentSessionController(MainSessionController controller, String spaceId, String componentId) {
        this(controller, controller.createComponentContext(spaceId, componentId));
    }

    public AbstractComponentSessionController(MainSessionController controller, ComponentContext context) {
        this(controller, context, null);
    }

    public AbstractComponentSessionController(MainSessionController controller, ComponentContext context, String localizedMessagesBundleName) {
        this(controller, context, localizedMessagesBundleName, null);
    }

    public AbstractComponentSessionController(MainSessionController controller, ComponentContext context, String localizedMessagesBundleName, String iconFileName) {
        this(controller, context, localizedMessagesBundleName, iconFileName, null);
    }

    public AbstractComponentSessionController(MainSessionController controller, ComponentContext context, String localizedMessagesBundleName, String iconFileName, String settingsFileName) {
        this.controller = controller;
        this.context = context;
        if (StringUtil.isDefined((String)context.getCurrentComponentName())) {
            this.setComponentRootName(context.getCurrentComponentName());
        } else {
            this.setComponentRootName(SilverpeasComponentInstance.getComponentName((String)context.getCurrentComponentId()));
        }
        this.setLocalizationBundle(localizedMessagesBundleName);
        this.setIconFileName(iconFileName);
        this.settingsFile = settingsFileName;
    }

    @Override
    public LocalizationBundle getMultilang() {
        if (this.message != null && !this.message.getLocale().getLanguage().equals(this.controller.getFavoriteLanguage())) {
            this.setLocalizationBundle(this.messageFile);
        }
        return this.message;
    }

    @Override
    public SettingBundle getIcon() {
        if (this.icon != null) {
            this.setIconFileName(this.iconFile);
        }
        return this.icon;
    }

    @Override
    public SettingBundle getSettings() {
        if (this.settings == null && this.settingsFile != null) {
            this.settings = ResourceLocator.getSettingBundle((String)this.settingsFile);
        }
        return this.settings;
    }

    public String getString(String resName) {
        String theLanguage = this.getLanguage();
        if (!(theLanguage == null && this.message != null || this.message != null && this.messageLanguage != null && this.messageLanguage.equals(theLanguage))) {
            this.setLocalizationBundle(this.messageFile);
        }
        if (this.message == null) {
            return resName;
        }
        return this.message.getString(resName);
    }

    @Override
    public OrganizationController getOrganisationController() {
        return OrganizationControllerProvider.getOrganisationController();
    }

    @Override
    public String getLanguage() {
        return this.controller.getFavoriteLanguage();
    }

    @Override
    public ZoneId getZoneId() {
        return this.controller.getFavoriteZoneId();
    }

    public String getLook() {
        return this.controller.getFavoriteLook();
    }

    @Override
    public UserDetail getUserDetail() {
        return this.controller.getCurrentUserDetail();
    }

    public UserDetail getUserDetail(String userId) {
        return UserDetail.getById((String)userId);
    }

    @Override
    public String getUserId() {
        return this.getUserDetail().getId();
    }

    @Override
    public String getSpaceLabel() {
        return this.context.getCurrentSpaceName();
    }

    @Override
    public String getSpaceId() {
        return this.context.getCurrentSpaceId();
    }

    @Override
    public String getComponentName() {
        return this.context.getCurrentComponentName();
    }

    @Override
    public final String getComponentLabel() {
        return OrganizationController.get().getComponentInstance(this.getComponentId()).map(i -> i.getLabel(this.getLanguage())).orElse("");
    }

    @Override
    public final String getComponentId() {
        return this.context.getCurrentComponentId();
    }

    @Override
    public final String getComponentUrl() {
        return URLUtil.getURL((String)this.rootName, (String)this.getSpaceId(), (String)this.getComponentId());
    }

    public final String getComponentRootName() {
        return this.rootName;
    }

    protected final void setComponentRootName(String newRootName) {
        this.rootName = newRootName;
    }

    @Override
    public String getComponentParameterValue(String parameterName) {
        return this.controller.getComponentParameterValue(this.getComponentId(), parameterName);
    }

    @Override
    public String getComponentParameterValue(ComponentInstanceParameterName parameterName) {
        return this.getComponentParameterValue(parameterName.name());
    }

    @Override
    public String[] getUserAvailComponentIds() {
        return this.controller.getUserAvailComponentIds();
    }

    @Override
    public String[] getUserRoles() {
        return this.context.getCurrentProfile();
    }

    @Override
    public Collection<SilverpeasRole> getSilverpeasUserRoles() {
        String currentKey = this.getComponentId() + "_user_roles";
        Collection roles = (Collection)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)currentKey);
        if (roles == null) {
            roles = SilverpeasRole.fromStrings((String[])this.context.getCurrentProfile());
            roles.remove(SilverpeasRole.MANAGER);
            CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)currentKey, (Object)roles);
        }
        return roles;
    }

    @Override
    public SilverpeasRole getHighestSilverpeasUserRole() {
        SilverpeasRole highestUserRole = SilverpeasRole.getHighestFrom(this.getSilverpeasUserRoles());
        if (highestUserRole == null) {
            highestUserRole = SilverpeasRole.READER;
        }
        return highestUserRole;
    }

    @Override
    public synchronized UserPreferences getPersonalization() {
        return this.controller.getPersonalization();
    }

    public UserAccessLevel getUserAccessLevel() {
        return this.controller.getUserAccessLevel();
    }

    public Selection getSelection() {
        return this.controller.getSelection();
    }

    @Override
    public boolean isAppInMaintenance() {
        return MainSessionController.isAppInMaintenance();
    }

    @Override
    public void setAppModeMaintenance(boolean mode) {
        MainSessionController.setAppModeMaintenance(mode);
    }

    @Override
    public boolean isSpaceInMaintenance(String spaceId) {
        return this.controller.isSpaceInMaintenance(spaceId);
    }

    @Override
    public void setSpaceModeMaintenance(String spaceId, boolean mode) {
        this.controller.setSpaceModeMaintenance(spaceId, mode);
    }

    @Override
    public void close() {
    }

    public boolean isPasswordChangeAllowed() {
        return this.controller.isAllowPasswordChange();
    }

    public String getRSSUrl() {
        return "/rss" + this.getComponentRootName() + "/" + this.getComponentId() + "?userId=" + this.getUserId() + "&login=" + this.getUrlEncodedParameter(this.getUserDetail().getLogin()) + "&password=" + this.getUrlEncodedParameter(UserFull.getById((String)this.getUserId()).getPassword());
    }

    @Override
    public Collection<ClipboardSelection> getClipboardSelectedObjects() throws ClipboardException {
        return this.controller.getSelectedObjects();
    }

    @Override
    public String getClipboardErrorMessage() throws ClipboardException {
        return this.controller.getMessageError();
    }

    @Override
    public Exception getClipboardExceptionError() throws ClipboardException {
        return this.controller.getExceptionError();
    }

    @Override
    public Collection<ClipboardSelection> getClipboardObjects() throws ClipboardException {
        return this.controller.getObjects();
    }

    @Override
    public void addClipboardSelection(ClipboardSelection selection) throws ClipboardException {
        this.controller.add(selection);
    }

    @Override
    public void clipboardPasteDone() throws ClipboardException {
        this.controller.pasteDone();
    }

    @Override
    public void setClipboardSelectedElement(int index, boolean selected) throws ClipboardException {
        this.controller.setSelected(index, selected);
    }

    @Override
    public int getClipboardSize() throws ClipboardException {
        return this.controller.size();
    }

    @Override
    public void removeClipboardElement(int index) throws ClipboardException {
        this.controller.removeObject(index);
    }

    protected String[] getUserManageableSpaceIds() {
        return this.controller.getUserManageableSpaceIds();
    }

    protected List<String> getUserManageableGroupIds() {
        return this.controller.getUserManageableGroupIds();
    }

    protected boolean isGroupManager() {
        return !this.getUserManageableGroupIds().isEmpty();
    }

    protected SubscriptionContext getSubscriptionContext() {
        return this.controller.getSubscriptionContext();
    }

    protected String getUrlEncodedParameter(String param) {
        try {
            return URLEncoder.encode(param, CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            return param;
        }
    }

    protected ComponentAccessControl getComponentAccessController() {
        return ComponentAccessControl.get();
    }

    private void setLocalizationBundle(String bundleName) {
        this.messageFile = bundleName;
        if (this.messageFile != null) {
            try {
                this.messageLanguage = this.getLanguage();
                this.message = ResourceLocator.getLocalizationBundle((String)this.messageFile, (String)this.messageLanguage);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Localization bundle '" + this.messageFile + "' not found for language " + this.messageLanguage, (Throwable)e);
                this.message = ResourceLocator.getLocalizationBundle((String)this.messageFile);
                this.messageLanguage = this.getLanguage();
            }
        } else {
            this.message = null;
        }
    }

    private void setIconFileName(String iconFileName) {
        this.iconFile = iconFileName;
        this.icon = this.iconFile != null ? ResourceLocator.getSettingBundle((String)this.iconFile) : null;
    }
}

