/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.jstl.constant.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class ClassConstantsMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private String className;

    public ClassConstantsMap(String className) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        this.className = className;
        this.init();
    }

    protected final void init() throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Class<?> declaringClass = Class.forName(this.className);
        for (Field field : fields = declaringClass.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            this.put(field.getName(), field.get(null));
        }
    }

    @Override
    public Object get(Object key) {
        if (super.get(key) == null) {
            throw new IllegalArgumentException("Key " + String.valueOf(key) + " could not be found in class constant map for " + this.className);
        }
        return super.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not permitted");
        }
        if (value == null) {
            throw new IllegalArgumentException("null values are not permitted");
        }
        return super.put(key, value);
    }
}

