/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.encryption.cipher.CryptMD5;
import org.silverpeas.core.web.authentication.credentials.ChangeQuestionAnswerFunctionHandler;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class ValidationAnswerHandler
extends ChangeQuestionAnswerFunctionHandler {
    @Override
    public String getFunction() {
        return "ValidateAnswer";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        String login = request.getParameter("Login");
        String domainId = request.getParameter("DomainId");
        String answer = request.getParameter("answer");
        boolean encryptedAnswer = this.getAuthenticationSettings().getBoolean("loginAnswerEncrypted", false);
        try {
            String userId = this.getAdminService().getUserIdByLoginAndDomain(login, domainId);
            UserDetail userDetail = this.getAdminService().getUserDetail(userId);
            request.setAttribute("userDetail", (Object)userDetail);
            request.setAttribute("userLanguage", (Object)userDetail.getUserPreferences().getLanguage());
            if (encryptedAnswer) {
                answer = CryptMD5.encrypt((String)answer);
            }
            if (answer.equals(userDetail.getLoginAnswer())) {
                return this.getGeneral().getString("userResetPasswordPage");
            }
            return this.performQuestionAnswerError(request, this.getGeneral().getString("userLoginQuestionPage"), userDetail);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("validation answer error with login {0}", (Object[])new String[]{login}, (Throwable)e);
            return "/Login?ErrorCode=2";
        }
    }
}

