/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.driver.admin;

import com.sun.portal.portletcontainer.driver.admin.DirectoryChangedListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;

public class DirectoryWatcherTask
extends TimerTask {
    private String directoryToWatch;
    private FileFilter filter;
    private DirectoryChangedListener listener;

    public DirectoryWatcherTask(String directoryToWatch, DirectoryChangedListener listener) {
        this(directoryToWatch, null, listener);
    }

    public DirectoryWatcherTask(String dirToWatch, FileFilter fileFilter, DirectoryChangedListener dirChangeListener) {
        this.directoryToWatch = dirToWatch;
        this.listener = dirChangeListener;
        this.filter = fileFilter == null ? new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        } : fileFilter;
    }

    @Override
    public void run() {
        File[] fileArray = new File(this.directoryToWatch).listFiles(this.filter);
        if (fileArray != null) {
            List<File> currentFileList = Arrays.asList(fileArray);
            for (File currentFile : currentFileList) {
                this.listener.fileAdded(currentFile);
            }
        }
    }
}

