/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletRegistryObject;
import com.sun.portal.portletcontainer.admin.PortletRegistryWriter;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowPreference;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowPreferenceRegistryContext;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowPreferenceRegistryReader;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowPreferenceRegistryWriter;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortletWindowPreferenceRegistryContextImpl
implements PortletWindowPreferenceRegistryContext {
    PortletRegistryObject portletWindowPreferenceRegistry;
    PortletRegistryObject defaultPortletWindowPreferenceRegistry;
    String context;

    public PortletWindowPreferenceRegistryContextImpl() throws PortletRegistryException {
        this.init(null);
    }

    public PortletWindowPreferenceRegistryContextImpl(String context) throws PortletRegistryException {
        this.init(context);
    }

    private void init(String context) throws PortletRegistryException {
        this.context = context;
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        PortletWindowPreferenceRegistryReader portletWindowPreferenceRegistryReader = new PortletWindowPreferenceRegistryReader(registryLocation, context);
        this.portletWindowPreferenceRegistry = portletWindowPreferenceRegistryReader.readDocument();
        portletWindowPreferenceRegistryReader = new PortletWindowPreferenceRegistryReader(registryLocation, null);
        this.defaultPortletWindowPreferenceRegistry = portletWindowPreferenceRegistryReader.readDocument();
    }

    @Override
    public Map<String, Object> getPreferencesReadOnly(String portletWindowName, String userName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getDefaultRegistryElement(portletWindowName + this.getDefaultUserName());
        Map<String, Object> map = portletRegistryElement.getCollectionProperty("prefReadOnly");
        return map;
    }

    @Override
    public Map<String, Object> getPreferences(String portletWindowName, String userName) throws PortletRegistryException {
        PortletRegistryElement predefinedPortletRegistryElement = null;
        Map<String, Object> predefinedPrefMap = null;
        if (predefinedPortletRegistryElement != null) {
            predefinedPrefMap = predefinedPortletRegistryElement.getCollectionProperty("prefProperties");
        }
        PortletRegistryElement userPortletRegistryElement = this.portletWindowPreferenceRegistry.getRegistryElement(portletWindowName + userName);
        Map<String, Object> tempUserPrefMap = null;
        if (userPortletRegistryElement != null) {
            tempUserPrefMap = userPortletRegistryElement.getCollectionProperty("prefProperties");
        }
        HashMap<String, Object> userPrefMap = predefinedPrefMap != null ? new HashMap<String, Object>(predefinedPrefMap) : new HashMap();
        if (tempUserPrefMap != null) {
            userPrefMap.putAll(tempUserPrefMap);
        }
        return userPrefMap;
    }

    @Override
    public void savePreferences(String portletName, String portletWindowName, String userName, Map<String, Object> prefMap) throws PortletRegistryException {
        this.savePreferences(portletName, portletWindowName, userName, prefMap, false);
    }

    @Override
    public void savePreferences(String portletName, String portletWindowName, String userName, Map<String, Object> prefMap, boolean readOnly) throws PortletRegistryException {
        Map<String, Object> readOnlyMap = null;
        if (readOnly) {
            readOnlyMap = this.getPreferencesReadOnly(portletName, userName);
        }
        PortletRegistryElement userPortletRegistryElement = this.portletWindowPreferenceRegistry.getRegistryElement(portletWindowName + userName);
        Map<String, Object> userPrefMap = null;
        if (userPortletRegistryElement == null) {
            userPortletRegistryElement = new PortletWindowPreference();
            userPortletRegistryElement.setName(portletWindowName);
            userPortletRegistryElement.setPortletName(portletName);
            userPortletRegistryElement.setUserName(userName);
        } else {
            userPrefMap = userPortletRegistryElement.getCollectionProperty("prefProperties");
        }
        if (userPrefMap == null) {
            userPrefMap = new HashMap<String, Object>();
        }
        userPrefMap.putAll(prefMap);
        userPortletRegistryElement.setCollectionProperty("prefProperties", userPrefMap);
        if (readOnlyMap != null) {
            userPortletRegistryElement.setCollectionProperty("prefReadOnly", readOnlyMap);
        }
        this.appendDocument(userPortletRegistryElement);
    }

    @Override
    public void removeWindowPreference(String portletWindowName) throws PortletRegistryException {
        List<PortletRegistryElement> portletWindowPreferences = this.portletWindowPreferenceRegistry.getRegistryElements();
        ArrayList<PortletRegistryElement> removeablePortletWindowPreferences = new ArrayList<PortletRegistryElement>();
        boolean remove = false;
        for (PortletRegistryElement portletWindowPreference : portletWindowPreferences) {
            if (!portletWindowPreference.getName().equals(portletWindowName)) continue;
            remove = true;
            removeablePortletWindowPreferences.add(portletWindowPreference);
        }
        for (PortletRegistryElement portletWindowPreference : removeablePortletWindowPreferences) {
            this.portletWindowPreferenceRegistry.removeRegistryElement(portletWindowPreference);
        }
        if (remove) {
            this.writeDocument(this.portletWindowPreferenceRegistry);
        }
    }

    @Override
    public void removePreferences(String portletName) throws PortletRegistryException {
        List<PortletRegistryElement> portletWindowPreferences = this.portletWindowPreferenceRegistry.getRegistryElements();
        ArrayList<PortletRegistryElement> removeablePortletWindowPreferences = new ArrayList<PortletRegistryElement>();
        boolean remove = false;
        for (PortletRegistryElement portletWindowPreference : portletWindowPreferences) {
            if (!portletWindowPreference.getPortletName().equals(portletName)) continue;
            remove = true;
            removeablePortletWindowPreferences.add(portletWindowPreference);
        }
        for (PortletRegistryElement portletWindowPreference : removeablePortletWindowPreferences) {
            this.portletWindowPreferenceRegistry.removeRegistryElement(portletWindowPreference);
        }
        if (remove) {
            this.writeDocument(this.portletWindowPreferenceRegistry);
        }
    }

    private PortletRegistryElement getRegistryElement(String name) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.portletWindowPreferenceRegistry.getRegistryElement(name);
        if (portletRegistryElement == null) {
            throw new PortletRegistryException(name + " does not exist");
        }
        return portletRegistryElement;
    }

    private PortletRegistryElement getDefaultRegistryElement(String name) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.defaultPortletWindowPreferenceRegistry.getRegistryElement(name);
        if (portletRegistryElement == null) {
            throw new PortletRegistryException(name + " does not exist");
        }
        return portletRegistryElement;
    }

    private String getDefaultUserName() {
        return "default";
    }

    private PortletRegistryWriter getPortletRegistryWriter() throws PortletRegistryException {
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        return new PortletWindowPreferenceRegistryWriter(registryLocation, this.context);
    }

    private void appendDocument(PortletRegistryElement portletRegistryElement) throws PortletRegistryException {
        ArrayList<PortletRegistryElement> portletWindowPreferenceElementList = new ArrayList<PortletRegistryElement>();
        portletWindowPreferenceElementList.add(portletRegistryElement);
        PortletRegistryWriter portletWindowPreferenceRegistryWriter = this.getPortletRegistryWriter();
        try {
            portletWindowPreferenceRegistryWriter.appendDocument(portletWindowPreferenceElementList);
        }
        catch (Exception e) {
            throw new PortletRegistryException(e);
        }
    }

    private void writeDocument(PortletRegistryObject portletWindowPreferenceRegistry) throws PortletRegistryException {
        PortletRegistryWriter portletWindowPreferenceRegistryWriter = this.getPortletRegistryWriter();
        List<PortletRegistryElement> portletWindowPreferenceElementList = portletWindowPreferenceRegistry.getRegistryElements();
        try {
            portletWindowPreferenceRegistryWriter.writeDocument(portletWindowPreferenceElementList);
        }
        catch (Exception e) {
            throw new PortletRegistryException(e);
        }
    }
}

