/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.warupdater;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class PortletWarUpdaterException
extends Exception {
    public static final String RESOURCE_BASE = "PortletWarUpdater";
    static Locale locale = Locale.getDefault();
    protected Throwable origEx = null;
    protected String key = null;
    protected Object[] tokens = null;

    public PortletWarUpdaterException(String key) {
        super(key);
        this.key = key;
    }

    public PortletWarUpdaterException(String key, Object[] tokens) {
        super(key);
        this.key = key;
        this.tokens = tokens;
    }

    public PortletWarUpdaterException(String key, Throwable t) {
        super(key);
        this.origEx = t;
        this.key = key;
    }

    public PortletWarUpdaterException(String key, Throwable t, Object[] tokens) {
        super(key);
        this.origEx = t;
        this.key = key;
        this.tokens = tokens;
    }

    public PortletWarUpdaterException(Throwable t) {
        super(t);
        this.key = "";
        this.origEx = t;
    }

    public static void setLocale(Locale loc) {
        locale = loc;
    }

    public String getMessage() {
        ResourceBundle rb = PropertyResourceBundle.getBundle(RESOURCE_BASE, Locale.getDefault());
        return this.getMessageFromRB(rb, this.key, this.tokens);
    }

    public Throwable getWrapped() {
        return this.origEx;
    }

    public String getWrappedMessage() {
        String msg = null;
        msg = this.origEx != null ? this.origEx.getMessage() : null;
        return msg;
    }

    public String getLocalizedMessage() {
        ResourceBundle rb = PropertyResourceBundle.getBundle(RESOURCE_BASE, locale);
        String msg = null;
        try {
            msg = this.getMessageFromRB(rb, this.key, this.tokens);
        }
        catch (MissingResourceException mrex) {
            msg = this.key;
        }
        return msg;
    }

    private String getMessageFromRB(ResourceBundle rb, String key, Object[] tokens) throws MissingResourceException {
        String msg = rb.getString(key);
        if (tokens != null && tokens.length > 0) {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(rb.getLocale());
            mf.applyPattern(msg);
            return mf.format(tokens);
        }
        return msg;
    }

    public void printStackTrace() {
        if (this.origEx != null) {
            this.origEx.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.origEx != null) {
            this.origEx.printStackTrace(pw);
        } else {
            super.printStackTrace(pw);
        }
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getTokens() {
        return this.tokens;
    }
}

