/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.taglib;

import com.sun.portal.portletcontainer.common.URLHelper;
import com.sun.portal.portletcontainer.taglib.BaseURLTag;
import java.io.IOException;
import java.util.Locale;
import javax.portlet.BaseURL;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;

public class ResourceURLTag
extends BaseURLTag {
    private String id;
    private String cacheability;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        ResourceURL resourceURL = this.createURL(portletResponse);
        if (resourceURL == null) {
            throw new JspException("Response must be ResourceResponse");
        }
        try {
            if (this.cacheability != null) {
                resourceURL.setCacheability(this.cacheability);
            }
            if (this.id != null) {
                resourceURL.setResourceID(this.id);
            }
            if (this.getSecure() != null) {
                String secure = this.getSecure().toLowerCase(Locale.ENGLISH);
                if (secure.equals("true")) {
                    resourceURL.setSecure(true);
                } else if (secure.equals("false")) {
                    resourceURL.setSecure(false);
                } else {
                    throw new JspException("invalid value for attribute secure");
                }
            }
            this.setBaseURL((BaseURL)resourceURL);
        }
        catch (PortletSecurityException e) {
            throw new JspException("invalid value for attribute secure", (Throwable)e);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        String urlString = this.getBaseURL().toString();
        if (this.isEscapeXml(portletRequest)) {
            urlString = URLHelper.escapeURL(urlString);
        }
        if (this.getVar() == null) {
            try {
                this.pageContext.getOut().print(urlString);
            }
            catch (IOException e) {
                throw new JspTagException("Error: IOException while writing");
            }
        } else {
            this.pageContext.setAttribute(this.getVar(), (Object)urlString);
        }
        return 6;
    }

    public void setParent(Tag t) {
        super.setParent(t);
        this.id = null;
        this.cacheability = null;
    }

    public ResourceURL createURL(PortletResponse portletResponse) {
        if (portletResponse instanceof RenderResponse) {
            return ((RenderResponse)portletResponse).createResourceURL();
        }
        if (portletResponse instanceof ResourceResponse) {
            return ((ResourceResponse)portletResponse).createResourceURL();
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCacheability(String cacheability) {
        this.cacheability = cacheability;
    }

    public void setAdditionalParameters(BaseURL baseURL) {
    }
}

