/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletRequestImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ClientDataRequestImpl
extends PortletRequestImpl
implements ClientDataRequest {
    private boolean gotReader;
    private boolean gotInputStream;
    private static String ILLEGAL_OPERATION_ERROR = "Cannot perform this function for portlet: ";
    private static String UNSUPPORTED_ENCODING_ERROR = "The specified character encoding is not supported.";

    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerRequest pcRequest, PortletContainerResponse pcResponse, PortletContext portletContext, PortalContext portalContext, PortletDescriptor pDescriptor, Map attributes) {
        super.init(request, response, pcRequest, pcResponse, portletContext, portalContext, pDescriptor, attributes);
        this.gotReader = false;
        this.gotInputStream = false;
    }

    protected void clear() {
        super.clear();
        this.gotReader = false;
        this.gotInputStream = false;
    }

    public InputStream getPortletInputStream() throws IOException {
        if (this.gotReader) {
            throw new IllegalStateException(ILLEGAL_OPERATION_ERROR + this.getPortletContainerRequest().getPortletName());
        }
        if (this.getContentType() != null && this.getContentType().equals("application/x-www-form-urlencoded")) {
            throw new IllegalStateException(ILLEGAL_OPERATION_ERROR + this.getPortletContainerRequest().getPortletName());
        }
        this.gotInputStream = true;
        return this.getHttpServletRequest().getInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this.gotInputStream) {
            throw new IllegalStateException(ILLEGAL_OPERATION_ERROR + this.getPortletContainerRequest().getPortletName());
        }
        if (this.getContentType() != null && this.getContentType().equals("application/x-www-form-urlencoded")) {
            throw new IllegalStateException(ILLEGAL_OPERATION_ERROR + this.getPortletContainerRequest().getPortletName());
        }
        this.gotReader = true;
        return this.getHttpServletRequest().getReader();
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.gotReader || this.gotInputStream) {
            throw new IllegalStateException("Illegal setting character encoding after getReader() or getPortletInputStream() is called");
        }
        if (!enc.equals(this.getCharacterEncoding())) {
            throw new UnsupportedEncodingException(UNSUPPORTED_ENCODING_ERROR);
        }
        this.getHttpServletRequest().setCharacterEncoding(enc);
    }

    public String getContentType() {
        return this.getHttpServletRequest().getContentType();
    }

    public int getContentLength() {
        int retVal = -1;
        if (this.getContentType() != null && !this.getContentType().equals("application/x-www-form-urlencoded")) {
            retVal = this.getHttpServletRequest().getContentLength();
        }
        return retVal;
    }

    public String getMethod() {
        return this.getHttpServletRequest().getMethod();
    }
}

