/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class InitParamDescriptor {
    private String paramName;
    private String paramValue;
    private List<String> descriptions = new ArrayList<String>();
    private Map descriptionMap = new HashMap();

    public void load(Element element, String namespaceURI) {
        this.paramName = PortletXMLDocumentHelper.getChildTextTrim(element, "name");
        this.paramValue = PortletXMLDocumentHelper.getChildTextTrim(element, "value");
        List<Element> descriptionElements = PortletXMLDocumentHelper.getChildElements(element, "description");
        int numDescription = descriptionElements.size();
        for (int i = 0; i < numDescription; ++i) {
            Element descriptionElement = descriptionElements.get(i);
            String description = PortletXMLDocumentHelper.getTextTrim(descriptionElement);
            this.descriptions.add(description);
            Map<String, String> descAttributes = PortletXMLDocumentHelper.getAttributeTable(descriptionElement);
            for (Map.Entry<String, String> entry : descAttributes.entrySet()) {
                String lang = entry.getKey();
                if (!lang.equals("xml:lang")) continue;
                this.descriptionMap.put(entry.getValue(), description);
            }
        }
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public String getDescription() {
        String description = null;
        if (!this.descriptions.isEmpty()) {
            description = this.descriptions.get(0);
        }
        return description;
    }

    public Map getDescriptionMap() {
        return this.descriptionMap;
    }

    public List getDescriptions() {
        return this.descriptions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("InitParamDescriptor [");
        sb.append("param name [").append(this.paramName).append("] ");
        sb.append("param value [").append(this.paramValue).append("] ");
        sb.append("descriptions [");
        Iterator<String> iterator0 = this.descriptions.iterator();
        while (iterator0.hasNext()) {
            sb.append(iterator0.next());
        }
        sb.append(" ]");
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }
}

