/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.VendorPortletXML;
import com.sun.portal.portletcontainer.common.PortletContainerUtil;
import com.sun.portal.portletcontainer.common.PortletDeployConfigReader;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletSchema;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentDescriptorReader {
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    public static final String PORTLET_NAMESPACE = "http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd";
    private static Logger logger = ContainerLogger.getLogger(DeploymentDescriptorReader.class, (String)"PCCLogMessages");
    private Properties deployConfigProperties;
    private String version;

    public DeploymentDescriptorReader(ServletContext context) {
        this.deployConfigProperties = new Properties();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            String parameter = (String)e.nextElement();
            this.deployConfigProperties.put(parameter, context.getInitParameter(parameter));
        }
    }

    public DeploymentDescriptorReader(String deployConfigFileLocation) {
        this.deployConfigProperties = PortletDeployConfigReader.getPortletDeployConfigProperties(deployConfigFileLocation);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_PCCCSPPCCD0001", deployConfigFileLocation);
        }
    }

    public DeploymentDescriptorReader(Properties deployConfigProperties) {
        this.deployConfigProperties = deployConfigProperties;
    }

    private Element readDeploymentDescriptor(String portletAppName, InputStream portletStream, boolean validate) throws DeploymentDescriptorException {
        Element element = null;
        byte[] portletXMLStreamBytes = null;
        ByteArrayOutputStream portletXMLByteOuputStream = null;
        InputStream portletXMLStreamParse = null;
        InputStream portletXMLStreamValidate = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(Boolean.TRUE);
        try {
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            Document document = null;
            if (validate) {
                portletXMLByteOuputStream = new ByteArrayOutputStream(4096);
                int data = -1;
                while ((data = portletStream.read()) != -1) {
                    portletXMLByteOuputStream.write(data);
                }
                portletXMLStreamBytes = portletXMLByteOuputStream.toByteArray();
                portletXMLStreamParse = new ByteArrayInputStream(portletXMLStreamBytes);
                document = docBuilder.parse(portletXMLStreamParse);
            } else {
                document = docBuilder.parse(portletStream);
            }
            element = document.getDocumentElement();
            if (element != null && element.hasAttribute("version")) {
                this.version = element.getAttribute("version");
            }
            if (validate) {
                if (this.version != null) {
                    Schema schema = PortletSchema.getSchema(this.version);
                    if (schema != null) {
                        Validator validator = schema.newValidator();
                        portletXMLStreamValidate = new ByteArrayInputStream(portletXMLStreamBytes);
                        validator.validate(new StreamSource(portletXMLStreamValidate));
                    }
                } else {
                    logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0021");
                }
            }
        }
        catch (ParserConfigurationException pce) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0003", new String[]{portletAppName, pce.toString()});
            }
            throw new DeploymentDescriptorException("document builder cannot be created", pce);
        }
        catch (SAXException saxe) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0029", new String[]{portletAppName, saxe.toString()});
            }
            throw new DeploymentDescriptorException("error parsing portlet stream", saxe);
        }
        catch (IOException ioe) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0030", new String[]{portletAppName, ioe.toString()});
            }
            throw new DeploymentDescriptorException("error reading portlet stream", ioe);
        }
        finally {
            portletXMLStreamBytes = null;
            if (portletXMLByteOuputStream != null) {
                try {
                    portletXMLByteOuputStream.close();
                }
                catch (IOException ignored) {}
            }
            if (portletXMLStreamParse != null) {
                try {
                    portletXMLStreamParse.close();
                }
                catch (IOException ignored) {}
            }
            if (portletXMLStreamValidate != null) {
                try {
                    portletXMLStreamValidate.close();
                }
                catch (IOException ignored) {}
            }
        }
        return element;
    }

    public PortletAppDescriptor loadPortletAppDescriptor(String portletAppName, InputStream portletStream) throws DeploymentDescriptorException {
        Element root;
        PortletAppDescriptor appDescriptor = null;
        if (portletStream != null && (root = this.readDeploymentDescriptor(portletAppName, portletStream, this.isValidatePortletXML())) != null) {
            logger.log(Level.FINE, "PSPL_PCCCSPPCCD0004", portletAppName);
            appDescriptor = new PortletAppDescriptor(portletAppName);
            appDescriptor.load(root, PORTLET_NAMESPACE);
        }
        return appDescriptor;
    }

    public void readWebAppDescriptor(PortletAppDescriptor portletAppDescriptor, InputStream webXmlStream) throws DeploymentDescriptorException {
        ArrayList<String> servletURLPatterns = new ArrayList<String>();
        if (webXmlStream != null) {
            try {
                DocumentBuilder docBuilder = PortletContainerUtil.getDocumentBuilder();
                Document document = docBuilder.parse(webXmlStream);
                Element element = document.getDocumentElement();
                if (element != null) {
                    NodeList servletMappingElements = element.getElementsByTagName("servlet-mapping");
                    for (int i = 0; i < servletMappingElements.getLength(); ++i) {
                        Element servletMappingElement = (Element)servletMappingElements.item(i);
                        String urlPattern = PortletXMLDocumentHelper.getChildTextTrim(servletMappingElement, "url-pattern");
                        servletURLPatterns.add(urlPattern);
                    }
                }
            }
            catch (ParserConfigurationException pce) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0033", new String[]{portletAppDescriptor.getName(), pce.toString()});
                }
                throw new DeploymentDescriptorException("document builder cannot be created", pce);
            }
            catch (SAXException saxe) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0034", new String[]{portletAppDescriptor.getName(), saxe.toString()});
                }
                throw new DeploymentDescriptorException("error parsing web xml stream", saxe);
            }
            catch (IOException ioe) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0035", new String[]{portletAppDescriptor.getName(), ioe.toString()});
                }
                throw new DeploymentDescriptorException("error reading web xml stream", ioe);
            }
        }
        portletAppDescriptor.setURLPatterns(servletURLPatterns);
    }

    public PortletAppDescriptor getPortletAppDescriptor(String portletAppName, InputStream portletStream, boolean validate) throws DeploymentDescriptorException {
        Element root;
        PortletAppDescriptor appDescriptor = null;
        if (portletStream != null && (root = this.readDeploymentDescriptor(portletAppName, portletStream, validate)) != null) {
            logger.log(Level.FINE, "PSPL_PCCCSPPCCD0004", portletAppName);
            appDescriptor = new PortletAppDescriptor(portletAppName);
            appDescriptor.load(root, PORTLET_NAMESPACE);
        }
        return appDescriptor;
    }

    public Map<String, Object> getPortletExtensionDescriptors(ServletContext context) throws DeploymentDescriptorException {
        HashMap<String, Object> deploymentExtensionDescriptors = new HashMap<String, Object>();
        List<String> vendorNames = this.getVendorNames();
        for (String vendorName : vendorNames) {
            String name = this.deployConfigProperties.getProperty(this.getVendorPortletXMLNameProperty(vendorName));
            String implName = this.deployConfigProperties.getProperty(this.getVendorPortletXMLImplProperty(vendorName));
            if (name == null) continue;
            deploymentExtensionDescriptors.put(name, this.loadVendorPortletXMLImpl(context, name, implName));
        }
        return deploymentExtensionDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> processDeployPortletExtensionDescriptor(File warFile, String schemaLocation) throws Exception {
        List<String> vendorNames = this.getVendorNames();
        HashMap<String, Object> extensionDescriptors = new HashMap<String, Object>();
        for (String vendorName : vendorNames) {
            String name = this.deployConfigProperties.getProperty(this.getVendorPortletXMLNameProperty(vendorName));
            String implName = this.deployConfigProperties.getProperty(this.getVendorPortletXMLImplProperty(vendorName));
            String validate = this.deployConfigProperties.getProperty(this.getVendorPortletXMLValidateProperty(vendorName));
            InputStream vendorPortletXmlStream = null;
            try {
                vendorPortletXmlStream = this.getVendorPortletXmlStream(warFile, name);
                Object extensionDescriptor = this.processDeployVendorPortletXML(warFile, vendorPortletXmlStream, name, implName, schemaLocation, validate);
                extensionDescriptors.put(name, extensionDescriptor);
            }
            finally {
                if (vendorPortletXmlStream == null) continue;
                try {
                    vendorPortletXmlStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        return extensionDescriptors;
    }

    public Object processDeployPortletExtensionDescriptor(String vendorPortletXMLName, InputStream vendorPortletXmlStream, String schemaLocation) throws Exception {
        Object extensionDescriptor = null;
        String vendorName = this.getVendorName(vendorPortletXMLName);
        if (vendorName != null) {
            String name = this.deployConfigProperties.getProperty(this.getVendorPortletXMLNameProperty(vendorName));
            String implName = this.deployConfigProperties.getProperty(this.getVendorPortletXMLImplProperty(vendorName));
            String validate = this.deployConfigProperties.getProperty(this.getVendorPortletXMLValidateProperty(vendorName));
            extensionDescriptor = this.processDeployVendorPortletXML(null, vendorPortletXmlStream, name, implName, schemaLocation, validate);
        } else {
            logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0026", vendorPortletXMLName);
        }
        return extensionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUndeployPortletExtensionDescriptor(File warFile, String schemaLocation) throws Exception {
        List<String> vendorNames = this.getVendorNames();
        for (String vendorName : vendorNames) {
            String name = this.deployConfigProperties.getProperty(this.getVendorPortletXMLNameProperty(vendorName));
            String implName = this.deployConfigProperties.getProperty(this.getVendorPortletXMLImplProperty(vendorName));
            String validate = this.deployConfigProperties.getProperty(this.getVendorPortletXMLValidateProperty(vendorName));
            InputStream vendorPortletXmlStream = null;
            try {
                vendorPortletXmlStream = this.getVendorPortletXmlStream(warFile, name);
                this.processUnDeployVendorPortletXML(vendorPortletXmlStream, name, implName);
            }
            finally {
                if (vendorPortletXmlStream == null) continue;
                try {
                    vendorPortletXmlStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public void processUndeployPortletExtensionDescriptor(String vendorPortletXMLName, InputStream vendorPortletXmlStream, String schemaLocation) throws Exception {
        String vendorName = this.getVendorName(vendorPortletXMLName);
        if (vendorName != null) {
            String name = this.deployConfigProperties.getProperty(this.getVendorPortletXMLNameProperty(vendorName));
            String implName = this.deployConfigProperties.getProperty(this.getVendorPortletXMLImplProperty(vendorName));
            String validate = this.deployConfigProperties.getProperty(this.getVendorPortletXMLValidateProperty(vendorName));
            this.processUnDeployVendorPortletXML(vendorPortletXmlStream, name, implName);
        } else {
            logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0026", vendorPortletXMLName);
        }
    }

    public String getVersion() {
        return this.version;
    }

    private boolean isValidatePortletXML() {
        boolean validate = true;
        if (this.deployConfigProperties != null) {
            String validateString = this.deployConfigProperties.getProperty("portletXML.validate");
            logger.log(Level.INFO, "PSPL_PCCCSPPCCD0002", validateString);
            if ("false".equals(validateString)) {
                validate = false;
            }
        }
        return validate;
    }

    private List<String> getVendorNames() {
        ArrayList<String> vendorNames = new ArrayList<String>();
        if (this.deployConfigProperties != null) {
            Enumeration<?> e = this.deployConfigProperties.propertyNames();
            while (e.hasMoreElements()) {
                StringTokenizer tokens;
                int count;
                String property = (String)e.nextElement();
                if (!property.startsWith("vendorPortletXML") || (count = (tokens = new StringTokenizer(property, ".")).countTokens()) != 3) continue;
                tokens.nextToken();
                String vendorName = tokens.nextToken();
                if (vendorNames.contains(vendorName)) continue;
                vendorNames.add(vendorName);
            }
        }
        return vendorNames;
    }

    private String getVendorName(String vendorPortletXMLName) {
        String vendorName = null;
        if (this.deployConfigProperties != null) {
            Enumeration<?> e = this.deployConfigProperties.propertyNames();
            while (e.hasMoreElements()) {
                StringTokenizer tokens;
                int count;
                String property = (String)e.nextElement();
                if (!property.startsWith("vendorPortletXML") || !property.endsWith("name") || !vendorPortletXMLName.equals(this.deployConfigProperties.get(property)) || (count = (tokens = new StringTokenizer(property, ".")).countTokens()) != 3) continue;
                tokens.nextToken();
                vendorName = tokens.nextToken();
                break;
            }
        }
        return vendorName;
    }

    private String getVendorPortletXMLNameProperty(String vendorName) {
        StringBuffer property = new StringBuffer();
        property.append("vendorPortletXML");
        property.append(".");
        property.append(vendorName);
        property.append(".");
        property.append("name");
        return property.toString();
    }

    private String getVendorPortletXMLImplProperty(String vendorName) {
        StringBuffer property = new StringBuffer();
        property.append("vendorPortletXML");
        property.append(".");
        property.append(vendorName);
        property.append(".");
        property.append("impl");
        return property.toString();
    }

    private String getVendorPortletXMLValidateProperty(String vendorName) {
        StringBuffer property = new StringBuffer();
        property.append("vendorPortletXML");
        property.append(".");
        property.append(vendorName);
        property.append(".");
        property.append("validate");
        return property.toString();
    }

    private VendorPortletXML getVendorPortletXMLImpl(String implName) throws Exception {
        Class<?> portletClass = Thread.currentThread().getContextClassLoader().loadClass(implName);
        return (VendorPortletXML)portletClass.newInstance();
    }

    private Object processDeployVendorPortletXML(File warFile, InputStream vendorPortletXmlStream, String name, String implName, String schemaLocation, String validate) throws Exception {
        Object extensionDescriptor = null;
        if (vendorPortletXmlStream != null) {
            try {
                VendorPortletXML vendorPortletXML = this.getVendorPortletXMLImpl(implName);
                extensionDescriptor = vendorPortletXML.processDeploy(warFile, vendorPortletXmlStream, schemaLocation, Boolean.parseBoolean(validate));
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    LogRecord record = new LogRecord(Level.WARNING, "PSPL_PCCCSPPCCD0020");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new String[]{name, implName});
                    record.setThrown(e);
                    logger.log(record);
                }
                throw e;
            }
        }
        return extensionDescriptor;
    }

    private void processUnDeployVendorPortletXML(InputStream vendorPortletXmlStream, String name, String implName) throws Exception {
        if (vendorPortletXmlStream != null) {
            try {
                VendorPortletXML vendorPortletXML = this.getVendorPortletXMLImpl(implName);
                vendorPortletXML.processUndeploy(vendorPortletXmlStream);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    LogRecord record = new LogRecord(Level.WARNING, "PSPL_PCCCSPPCCD0020");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new String[]{name, implName});
                    record.setThrown(e);
                    logger.log(record);
                }
                throw e;
            }
        }
    }

    private Object loadVendorPortletXMLImpl(ServletContext context, String name, String implName) throws DeploymentDescriptorException {
        InputStream vendorPortletXmlStream = null;
        Object deploymentExtensionDescriptor = null;
        try {
            vendorPortletXmlStream = this.getVendorPortletXmlStream(context, name);
            if (vendorPortletXmlStream != null) {
                Class<?> portletClass = Thread.currentThread().getContextClassLoader().loadClass(implName);
                VendorPortletXML vendorPortletXML = (VendorPortletXML)portletClass.newInstance();
                deploymentExtensionDescriptor = vendorPortletXML.loadPortletExtensionDescriptor(vendorPortletXmlStream);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSPL_PCCCSPPCCD0025");
                record.setLoggerName(logger.getName());
                record.setParameters(new String[]{name, implName});
                record.setThrown(e);
                logger.log(record);
            }
            throw new DeploymentDescriptorException("error loading VendorPortletXML", e);
        }
        finally {
            if (vendorPortletXmlStream != null) {
                try {
                    vendorPortletXmlStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        return deploymentExtensionDescriptor;
    }

    private InputStream getVendorPortletXmlStream(ServletContext context, String name) throws Exception {
        InputStream vendorPortletStream = context.getResourceAsStream("/WEB-INF/" + name);
        return vendorPortletStream;
    }

    private InputStream getVendorPortletXmlStream(File warFile, String name) throws Exception {
        InputStream vendorPortletStream = null;
        if (warFile.isDirectory()) {
            File vendorPortletXmlFile = new File(warFile + File.separator + "WEB-INF" + File.separator + name);
            vendorPortletStream = new FileInputStream(vendorPortletXmlFile);
        } else {
            JarFile jar = new JarFile(warFile);
            ZipEntry vendorPortletXMLEntry = jar.getEntry(WEB_INF_PREFIX + name);
            if (vendorPortletXMLEntry != null) {
                vendorPortletStream = jar.getInputStream(vendorPortletXMLEntry);
            }
        }
        return vendorPortletStream;
    }

    public static void main(String[] args) {
        try {
            String portletXML = "<?xml version='1.0' encoding='UTF-8' ?><portlet-app xmlns='http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd' version='2.0'><portlet><description>HelloLiferayPortlet</description><portlet-name>HelloLiferayPortlet</portlet-name><display-name>HelloLiferayPortlet</display-name><portlet-class>com.test.HelloLiferayPortlet</portlet-class><expiration-cache>0</expiration-cache><supports>\t<mime-type>text/html</mime-type><portlet-mode>VIEW</portlet-mode></supports><resource-bundle>com.test.messages</resource-bundle><portlet-info>\t<title>HelloLiferayPortlet</title>\t<short-title>HelloLiferayPortlet</short-title></portlet-info>\t</portlet></portlet-app>";
            Properties prop = new Properties();
            prop.put("portletXML.validate", "false");
            ByteArrayInputStream ioStream = new ByteArrayInputStream(portletXML.getBytes());
            DeploymentDescriptorReader descriptorReader = new DeploymentDescriptorReader(prop);
            long startTime = System.currentTimeMillis();
            PortletAppDescriptor appDesc = descriptorReader.loadPortletAppDescriptor("portletwebapp", ioStream);
            long endTime = System.currentTimeMillis();
            System.out.println("Done in (millisec) : " + (endTime - startTime));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

