/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletID;
import com.sun.portal.container.service.EventHolder;
import com.sun.portal.container.service.PortletDescriptorHolder;
import com.sun.portal.container.service.PublicDescriptorHolderException;
import com.sun.portal.container.service.PublicRenderParameterHolder;
import com.sun.portal.container.service.ServiceManager;
import com.sun.portal.container.service.coordination.ContainerEventService;
import com.sun.portal.portletcontainer.common.descriptor.EventDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PublicRenderParameterDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletDescriptorHolderImpl
implements PortletDescriptorHolder {
    static List<String> containerEvents = new ArrayList<String>();
    private static Logger logger;
    private Map<QName, List<PortletID>> eventProcessingPortlets = new ConcurrentHashMap<QName, List<PortletID>>();
    private Map<PortletID, List<EventHolder>> portletSupportingProcessingEvents = new ConcurrentHashMap<PortletID, List<EventHolder>>();
    private Map<QName, List<PortletID>> eventPublishingPortlets = new ConcurrentHashMap<QName, List<PortletID>>();
    private Map<PortletID, List<EventHolder>> portletSupportingPublishingEvents = new ConcurrentHashMap<PortletID, List<EventHolder>>();
    private Map<PublicRenderParameterHolder, List<PortletID>> publicRenderParameterSupportingPortlets = new ConcurrentHashMap<PublicRenderParameterHolder, List<PortletID>>();
    private Map<PortletID, List<PublicRenderParameterHolder>> portletSupportingPublicRenderParameters = new ConcurrentHashMap<PortletID, List<PublicRenderParameterHolder>>();
    private Map<String, List<PublicRenderParameterHolder>> appPublicRenderParameterHolders = new ConcurrentHashMap<String, List<PublicRenderParameterHolder>>();
    private Map<String, List<EventHolder>> appEventHolders = new ConcurrentHashMap<String, List<EventHolder>>();

    public void load(Object descriptor) {
        PortletAppDescriptor portletAppDescriptor = (PortletAppDescriptor)descriptor;
        String portletAppName = portletAppDescriptor.getName();
        logger.log(Level.FINEST, "PSPL_PAECSPPA0018", portletAppName);
        if (!portletAppDescriptor.getEventDescriptors().isEmpty()) {
            for (EventDescriptor eventDescriptor : portletAppDescriptor.getEventDescriptors()) {
                List<EventHolder> eventHolders = this.appEventHolders.get(portletAppName);
                if (eventHolders == null) {
                    eventHolders = new CopyOnWriteArrayList<EventHolder>();
                }
                eventHolders.add(eventDescriptor.getEventHolder());
                this.appEventHolders.put(portletAppName, eventHolders);
            }
        }
        if (!portletAppDescriptor.getPublicRenderParameterDescriptors().isEmpty()) {
            for (PublicRenderParameterDescriptor publicRenderParameterDescriptor : portletAppDescriptor.getPublicRenderParameterDescriptors()) {
                List<PublicRenderParameterHolder> publicRenderParameterHolders = this.appPublicRenderParameterHolders.get(portletAppName);
                if (publicRenderParameterHolders == null) {
                    publicRenderParameterHolders = new CopyOnWriteArrayList<PublicRenderParameterHolder>();
                }
                publicRenderParameterHolders.add(publicRenderParameterDescriptor.getPublicRenderParameterHolder());
                this.appPublicRenderParameterHolders.put(portletAppName, publicRenderParameterHolders);
            }
        }
        this.createEventProcessingPortlets(portletAppDescriptor.getProcessingEvents());
        this.createSupportedEventProcessingPortlets(portletAppDescriptor.getSupportedProcessingEvents());
        this.createEventPublishingPortlets(portletAppDescriptor.getPublishingEvents());
        this.createPublicRenderParameterPortlets(portletAppDescriptor.getPublicRenderParameters());
        this.printInformation();
    }

    public void remove(Object descriptor) {
        PortletAppDescriptor portletAppDescriptor = (PortletAppDescriptor)descriptor;
        String portletAppName = portletAppDescriptor.getName();
        logger.log(Level.FINEST, "PSPL_PAECSPPA0019", portletAppName);
        List<PortletID> portletIDs = portletAppDescriptor.getPortletsDescriptor().getPortletIDs();
        this.removeEventProcessingPortlets(portletAppDescriptor.getProcessingEvents(), portletIDs);
        this.removeEventPublishingPortlets(portletAppDescriptor.getPublishingEvents(), portletIDs);
        this.removeSupportedEventProcessingPortlets(portletAppDescriptor.getSupportedProcessingEvents(), portletIDs);
        this.removePortletSupportingProcessingEvents(portletIDs);
        this.removePortletSupportingPublishingEvents(portletIDs);
        this.removeEventHolders(portletAppName);
        List<PublicRenderParameterDescriptor> publicRenderParameterDescriptors = portletAppDescriptor.getPublicRenderParameterDescriptors();
        this.removePublicRenderParameterSupportingPortlets(publicRenderParameterDescriptors, portletIDs);
        this.removePortletSupportingPublicRenderParameters(portletIDs);
        this.removePublicRenderParameterHolders(portletAppName);
        this.printInformation();
    }

    public EventHolder verifySupportedPublishingEvent(EntityID portletEntityId, EventHolder supportedEventHolder) {
        PortletID portletID;
        if (this.getContainerEventService() != null && this.getContainerEventService().getSupportedEvents().contains(supportedEventHolder.getQName())) {
            return null;
        }
        List<PortletID> portlets = this.getEventPublishingProcessingPortlets(this.eventPublishingPortlets, supportedEventHolder.getQName());
        if (portlets.contains(portletID = portletEntityId.getPortletID())) {
            return supportedEventHolder;
        }
        return null;
    }

    public List<EventHolder> getSupportedPublishingEventHolders(EntityID portletEntityId) {
        PortletID portletID = portletEntityId.getPortletID();
        List<EventHolder> eventHolders = null;
        if (portletID != null) {
            eventHolders = this.portletSupportingPublishingEvents.get(portletID);
        }
        if (eventHolders == null) {
            return Collections.emptyList();
        }
        return eventHolders;
    }

    public List<PortletID> getEventPublishingPortlets(QName eventQname) {
        List<PortletID> portletIDs = null;
        if (eventQname != null) {
            portletIDs = this.eventPublishingPortlets.get(eventQname);
        }
        if (portletIDs == null) {
            return Collections.emptyList();
        }
        return portletIDs;
    }

    public Map<QName, List<PortletID>> getAllEventPublishingPortlets() {
        return Collections.unmodifiableMap(this.eventPublishingPortlets);
    }

    public EventHolder verifySupportedProcessingEvent(EntityID portletEntityId, EventHolder supportedEventHolder) {
        PortletID portletID;
        List<PortletID> portlets = this.getEventPublishingProcessingPortlets(this.eventProcessingPortlets, supportedEventHolder.getQName());
        if (portlets.contains(portletID = portletEntityId.getPortletID())) {
            return supportedEventHolder;
        }
        for (List<EventHolder> allEventHolders : this.appEventHolders.values()) {
            for (EventHolder eventHolder : allEventHolders) {
                if (!eventHolder.getAliases().contains(supportedEventHolder.getQName()) && !eventHolder.getQName().equals(supportedEventHolder.getQName()) && !supportedEventHolder.getAliases().contains(eventHolder.getQName()) && !this.checkAliases(eventHolder, supportedEventHolder) || (portlets = this.getEventPublishingProcessingPortlets(this.eventProcessingPortlets, eventHolder.getQName())) == null || !portlets.contains(portletID)) continue;
                return eventHolder;
            }
        }
        return null;
    }

    public List<EventHolder> getSupportedProcessingEventHolders(EntityID portletEntityId) {
        PortletID portletID = portletEntityId.getPortletID();
        List<EventHolder> eventHolders = null;
        if (portletID != null) {
            eventHolders = this.portletSupportingProcessingEvents.get(portletID);
        }
        if (eventHolders == null) {
            return Collections.emptyList();
        }
        return eventHolders;
    }

    public List<PortletID> getEventProcessingPortlets(QName eventQname) {
        List<PortletID> portletIDs = null;
        if (eventQname != null) {
            portletIDs = this.eventProcessingPortlets.get(eventQname);
        }
        if (portletIDs == null) {
            return Collections.emptyList();
        }
        return portletIDs;
    }

    public Map<QName, List<PortletID>> getAllEventProcessingPortlets() {
        return Collections.unmodifiableMap(this.eventProcessingPortlets);
    }

    public Map<String, String> verifySupportedPublicRenderParameters(EntityID portletEntityId, List<PublicRenderParameterHolder> supportedPublicRenderParameterHolders) {
        HashMap<String, String> supportedPublicRenderParametersMap = null;
        if (supportedPublicRenderParameterHolders != null) {
            supportedPublicRenderParametersMap = new HashMap<String, String>(supportedPublicRenderParameterHolders.size());
            for (PublicRenderParameterHolder supportedPublicRenderParameterHolder : supportedPublicRenderParameterHolders) {
                List<PortletID> portlets = this.publicRenderParameterSupportingPortlets.get(supportedPublicRenderParameterHolder);
                if (portlets == null) continue;
                PortletID portletID = portletEntityId.getPortletID();
                if (portlets.contains(portletID)) {
                    supportedPublicRenderParametersMap.put(supportedPublicRenderParameterHolder.getIdentifier(), supportedPublicRenderParameterHolder.getIdentifier());
                    continue;
                }
                for (List<PublicRenderParameterHolder> allPublicRenderParameterHolders : this.appPublicRenderParameterHolders.values()) {
                    for (PublicRenderParameterHolder publicRenderParameterHolder : allPublicRenderParameterHolders) {
                        List aliases = publicRenderParameterHolder.getAliases();
                        if (!aliases.contains(supportedPublicRenderParameterHolder.getQName()) && !publicRenderParameterHolder.getQName().equals(supportedPublicRenderParameterHolder.getQName()) && !supportedPublicRenderParameterHolder.getAliases().contains(publicRenderParameterHolder.getQName()) || (portlets = this.publicRenderParameterSupportingPortlets.get(publicRenderParameterHolder)) == null || !portlets.contains(portletID)) continue;
                        supportedPublicRenderParametersMap.put(supportedPublicRenderParameterHolder.getIdentifier(), publicRenderParameterHolder.getIdentifier());
                    }
                }
            }
        }
        if (supportedPublicRenderParametersMap == null) {
            return Collections.emptyMap();
        }
        return supportedPublicRenderParametersMap;
    }

    public List<PublicRenderParameterHolder> getSupportedPublicRenderParameterHolders(EntityID portletEntityId, Map<String, String[]> renderParameters) {
        PortletID portletID = portletEntityId.getPortletID();
        ArrayList<PublicRenderParameterHolder> publicRenderParameterHolders = new ArrayList<PublicRenderParameterHolder>();
        if (portletID != null) {
            List<PublicRenderParameterHolder> supportingPublicRenderParameterHolders = this.portletSupportingPublicRenderParameters.get(portletID);
            Set<Map.Entry<String, List<PublicRenderParameterHolder>>> entries = this.appPublicRenderParameterHolders.entrySet();
            for (Map.Entry<String, List<PublicRenderParameterHolder>> mapEntry : entries) {
                if (supportingPublicRenderParameterHolders == null) continue;
                if (renderParameters == null) {
                    for (PublicRenderParameterHolder publicRenderParameterHolder : mapEntry.getValue()) {
                        if (!supportingPublicRenderParameterHolders.contains(publicRenderParameterHolder)) continue;
                        publicRenderParameterHolders.add(publicRenderParameterHolder);
                    }
                    continue;
                }
                for (PublicRenderParameterHolder publicRenderParameterHolder : mapEntry.getValue()) {
                    if (!renderParameters.containsKey(publicRenderParameterHolder.getIdentifier()) || !supportingPublicRenderParameterHolders.contains(publicRenderParameterHolder)) continue;
                    publicRenderParameterHolders.add(publicRenderParameterHolder);
                }
            }
        }
        return publicRenderParameterHolders;
    }

    public void setEventHolder(String portletAppName, EventHolder eventHolder) throws PublicDescriptorHolderException {
        if (this.appEventHolders != null) {
            List<EventHolder> eventHolders = this.appEventHolders.get(portletAppName);
            if (eventHolders == null) {
                eventHolders = new CopyOnWriteArrayList<EventHolder>();
            }
            if (!eventHolders.contains(eventHolder)) {
                eventHolders.add(eventHolder);
                this.appEventHolders.put(portletAppName, eventHolders);
            } else {
                throw new PublicDescriptorHolderException("The Event:" + eventHolder.getQName() + " is already present");
            }
        }
        this.printInformation();
    }

    public void setSupportedPublishingEvent(EntityID portletEntityId, EventHolder eventHolder) throws PublicDescriptorHolderException {
        List<Object> eventHolders;
        if (this.portletSupportingPublishingEvents != null && (eventHolders = this.portletSupportingPublishingEvents.get(portletEntityId.getPortletID())) != null && eventHolders.contains(eventHolder)) {
            throw new PublicDescriptorHolderException("The SupportingPublishingEvent:" + eventHolder.getQName() + " is already present");
        }
        eventHolders = new ArrayList<EventHolder>();
        eventHolders.add(eventHolder);
        HashMap<PortletID, List<EventHolder>> publishingEvents = new HashMap<PortletID, List<EventHolder>>();
        publishingEvents.put(portletEntityId.getPortletID(), eventHolders);
        this.createEventPublishingPortlets(publishingEvents);
        this.printInformation();
    }

    public void setSupportedProcessingEvent(EntityID portletEntityId, EventHolder eventHolder) throws PublicDescriptorHolderException {
        List<Object> eventHolders;
        if (this.portletSupportingProcessingEvents != null && (eventHolders = this.portletSupportingPublishingEvents.get(portletEntityId.getPortletID())) != null && eventHolders.contains(eventHolder)) {
            throw new PublicDescriptorHolderException("The SupportingProcessingEvent:" + eventHolder.getQName() + " is already present");
        }
        eventHolders = new ArrayList<EventHolder>();
        eventHolders.add(eventHolder);
        HashMap<PortletID, List<EventHolder>> processingEvents = new HashMap<PortletID, List<EventHolder>>();
        processingEvents.put(portletEntityId.getPortletID(), eventHolders);
        this.createEventProcessingPortlets(processingEvents);
        this.printInformation();
    }

    public void setPublicRenderParameterHolder(String portletAppName, PublicRenderParameterHolder publicRenderParameterHolder) throws PublicDescriptorHolderException {
        if (this.appPublicRenderParameterHolders != null) {
            List<PublicRenderParameterHolder> publicRenderParameterHolders = this.appPublicRenderParameterHolders.get(portletAppName);
            if (publicRenderParameterHolders == null) {
                publicRenderParameterHolders = new CopyOnWriteArrayList<PublicRenderParameterHolder>();
            }
            if (!publicRenderParameterHolders.contains(publicRenderParameterHolder)) {
                publicRenderParameterHolders.add(publicRenderParameterHolder);
                this.appPublicRenderParameterHolders.put(portletAppName, publicRenderParameterHolders);
            } else {
                throw new PublicDescriptorHolderException("The PublicRenderParameter:" + publicRenderParameterHolder.getQName() + " is already present");
            }
        }
        this.printInformation();
    }

    public void setSupportedPublicRenderParameter(EntityID portletEntityId, PublicRenderParameterHolder publicRenderParameterHolder) throws PublicDescriptorHolderException {
        List<Object> publicRenderParameterHolders;
        if (this.portletSupportingPublicRenderParameters != null && (publicRenderParameterHolders = this.portletSupportingPublicRenderParameters.get(portletEntityId.getPortletID())) != null && publicRenderParameterHolders.contains(publicRenderParameterHolder)) {
            throw new PublicDescriptorHolderException("The SupportedPublicRenderParameter:" + publicRenderParameterHolder.getQName() + " is already present");
        }
        publicRenderParameterHolders = new ArrayList<PublicRenderParameterHolder>();
        publicRenderParameterHolders.add(publicRenderParameterHolder);
        HashMap<PortletID, List<PublicRenderParameterHolder>> publicRenderParameters = new HashMap<PortletID, List<PublicRenderParameterHolder>>();
        publicRenderParameters.put(portletEntityId.getPortletID(), publicRenderParameterHolders);
        this.createPublicRenderParameterPortlets(publicRenderParameters);
        this.printInformation();
    }

    private boolean checkAliases(EventHolder eventHolder, EventHolder supportedEventHolder) {
        boolean containsAlias = false;
        for (QName qname : eventHolder.getAliases()) {
            if (!supportedEventHolder.getAliases().contains(qname)) continue;
            containsAlias = true;
            break;
        }
        return containsAlias;
    }

    private List<PortletID> getEventPublishingProcessingPortlets(Map<QName, List<PortletID>> eventPublishingProcessingPortlets, QName eventQName) {
        ArrayList<PortletID> portlets = new ArrayList<PortletID>();
        if (eventQName != null) {
            Set<Map.Entry<QName, List<PortletID>>> entries = eventPublishingProcessingPortlets.entrySet();
            for (Map.Entry<QName, List<PortletID>> mapEntry : entries) {
                QName descriptorEventQName = mapEntry.getKey();
                if (!descriptorEventQName.equals(eventQName)) continue;
                portlets.addAll((Collection<PortletID>)mapEntry.getValue());
            }
        }
        return portlets;
    }

    private void setEventPortlets(Map<PortletID, List<EventHolder>> portletProcessingPublishingEventsFromDescriptor, Map<QName, List<PortletID>> eventProcessingPublishingPortlets, Map<PortletID, List<EventHolder>> portletSupportingProcessingPublishingEvents) {
        Set<Map.Entry<PortletID, List<EventHolder>>> entries = portletProcessingPublishingEventsFromDescriptor.entrySet();
        for (Map.Entry<PortletID, List<EventHolder>> mapEntry : entries) {
            for (EventHolder eventHolder : mapEntry.getValue()) {
                List<EventHolder> supportingEventHolders = portletSupportingProcessingPublishingEvents.get(mapEntry.getKey());
                if (supportingEventHolders == null) {
                    supportingEventHolders = new ArrayList<EventHolder>();
                }
                if (!supportingEventHolders.contains(eventHolder)) {
                    supportingEventHolders.add(eventHolder);
                }
                portletSupportingProcessingPublishingEvents.put(mapEntry.getKey(), supportingEventHolders);
                List<PortletID> portletIDs = eventProcessingPublishingPortlets.get(eventHolder.getQName());
                if (portletIDs == null) {
                    portletIDs = new ArrayList<PortletID>();
                }
                if (!portletIDs.contains(mapEntry.getKey())) {
                    portletIDs.add(mapEntry.getKey());
                }
                eventProcessingPublishingPortlets.put(eventHolder.getQName(), portletIDs);
            }
        }
    }

    private void setPublicRenderParameterPortlets(Map<PortletID, List<PublicRenderParameterHolder>> portletPublicRenderParametersFromDescriptor, Map<PublicRenderParameterHolder, List<PortletID>> publicRenderParameterSupportingPortlets) {
        Set<Map.Entry<PortletID, List<PublicRenderParameterHolder>>> entries = portletPublicRenderParametersFromDescriptor.entrySet();
        for (Map.Entry<PortletID, List<PublicRenderParameterHolder>> mapEntry : entries) {
            for (PublicRenderParameterHolder publicRenderParameterHolder : mapEntry.getValue()) {
                List<PublicRenderParameterHolder> supportingPublicRenderParameterHolders = this.portletSupportingPublicRenderParameters.get(mapEntry.getKey());
                if (supportingPublicRenderParameterHolders == null) {
                    supportingPublicRenderParameterHolders = new ArrayList<PublicRenderParameterHolder>();
                }
                if (!supportingPublicRenderParameterHolders.contains(publicRenderParameterHolder)) {
                    supportingPublicRenderParameterHolders.add(publicRenderParameterHolder);
                }
                this.portletSupportingPublicRenderParameters.put(mapEntry.getKey(), supportingPublicRenderParameterHolders);
                List<PortletID> portletIDs = publicRenderParameterSupportingPortlets.get(publicRenderParameterHolder);
                if (portletIDs == null) {
                    portletIDs = new ArrayList<PortletID>();
                }
                if (!portletIDs.contains(mapEntry.getKey())) {
                    portletIDs.add(mapEntry.getKey());
                }
                publicRenderParameterSupportingPortlets.put(publicRenderParameterHolder, portletIDs);
            }
        }
    }

    private void createSupportedEventProcessingPortlets(Map<PortletID, List<QName>> portletProcessingEvents) {
        Set<Map.Entry<PortletID, List<QName>>> entries = portletProcessingEvents.entrySet();
        for (Map.Entry<PortletID, List<QName>> mapEntry : entries) {
            for (QName qname : mapEntry.getValue()) {
                if (qname.getLocalPart().endsWith(".") || !containerEvents.contains(qname.getNamespaceURI())) continue;
                List<PortletID> portletIDs = this.eventProcessingPortlets.get(qname);
                if (portletIDs == null) {
                    portletIDs = new ArrayList<PortletID>();
                }
                if (portletIDs.contains(mapEntry.getKey())) continue;
                portletIDs.add(mapEntry.getKey());
                this.eventProcessingPortlets.put(qname, portletIDs);
            }
        }
    }

    private void createEventProcessingPortlets(Map<PortletID, List<EventHolder>> portletProcessingEventsFromDescriptor) {
        this.setEventPortlets(portletProcessingEventsFromDescriptor, this.eventProcessingPortlets, this.portletSupportingProcessingEvents);
    }

    private void createEventPublishingPortlets(Map<PortletID, List<EventHolder>> portletPublishingEventsFromDescriptor) {
        this.setEventPortlets(portletPublishingEventsFromDescriptor, this.eventPublishingPortlets, this.portletSupportingPublishingEvents);
    }

    private void createPublicRenderParameterPortlets(Map<PortletID, List<PublicRenderParameterHolder>> portletPublicRenderParametersFromDescriptor) {
        this.setPublicRenderParameterPortlets(portletPublicRenderParametersFromDescriptor, this.publicRenderParameterSupportingPortlets);
    }

    private void removeEventProcessingPortlets(Map<PortletID, List<EventHolder>> portletProcessingEvents, List<PortletID> portletIDs) {
        Set<Map.Entry<PortletID, List<EventHolder>>> entries = portletProcessingEvents.entrySet();
        for (Map.Entry<PortletID, List<EventHolder>> mapEntry : entries) {
            for (EventHolder eventHolder : mapEntry.getValue()) {
                List<PortletID> tempPortletIDs = this.eventProcessingPortlets.get(eventHolder.getQName());
                if (tempPortletIDs == null) continue;
                for (PortletID portletID : portletIDs) {
                    tempPortletIDs.remove(portletID);
                }
                if (!tempPortletIDs.isEmpty()) continue;
                this.eventProcessingPortlets.remove(eventHolder.getQName());
            }
        }
    }

    private void removeSupportedEventProcessingPortlets(Map<PortletID, List<QName>> supportedProcessingEvents, List<PortletID> portletIDs) {
        Set<Map.Entry<PortletID, List<QName>>> entries = supportedProcessingEvents.entrySet();
        for (Map.Entry<PortletID, List<QName>> mapEntry : entries) {
            for (QName qname : mapEntry.getValue()) {
                List<PortletID> tempPortletIDs = this.eventProcessingPortlets.get(qname);
                if (tempPortletIDs == null) continue;
                for (PortletID portletID : portletIDs) {
                    tempPortletIDs.remove(portletID);
                }
                if (!tempPortletIDs.isEmpty()) continue;
                this.eventProcessingPortlets.remove(qname);
            }
        }
    }

    private void removeEventPublishingPortlets(Map<PortletID, List<EventHolder>> portletPublishingEvents, List<PortletID> portletIDs) {
        Set<Map.Entry<PortletID, List<EventHolder>>> entries = portletPublishingEvents.entrySet();
        for (Map.Entry<PortletID, List<EventHolder>> mapEntry : entries) {
            for (EventHolder eventHolder : mapEntry.getValue()) {
                List<PortletID> tempPortletIDs = this.eventPublishingPortlets.get(eventHolder.getQName());
                if (tempPortletIDs == null) continue;
                for (PortletID portletID : portletIDs) {
                    tempPortletIDs.remove(portletID);
                }
                if (!tempPortletIDs.isEmpty()) continue;
                this.eventPublishingPortlets.remove(eventHolder.getQName());
            }
        }
    }

    private void removePortletSupportingProcessingEvents(List<PortletID> portletIDs) {
        if (portletIDs != null) {
            for (PortletID portletID : portletIDs) {
                this.portletSupportingProcessingEvents.remove(portletID);
            }
        }
    }

    private void removePortletSupportingPublishingEvents(List<PortletID> portletIDs) {
        if (portletIDs != null) {
            for (PortletID portletID : portletIDs) {
                this.portletSupportingPublishingEvents.remove(portletID);
            }
        }
    }

    private void removePublicRenderParameterSupportingPortlets(List<PublicRenderParameterDescriptor> publicRenderParameterDescriptors, List<PortletID> portletIDs) {
        for (PublicRenderParameterDescriptor publicRenderParameterDescriptor : publicRenderParameterDescriptors) {
            if (publicRenderParameterDescriptor.getPublicRenderParameterHolder() == null) continue;
            List<PortletID> tempPortletIDs = this.publicRenderParameterSupportingPortlets.get(publicRenderParameterDescriptor.getPublicRenderParameterHolder());
            for (PortletID portletID : portletIDs) {
                tempPortletIDs.remove(portletID);
            }
            if (!tempPortletIDs.isEmpty()) continue;
            this.publicRenderParameterSupportingPortlets.remove(publicRenderParameterDescriptor.getPublicRenderParameterHolder());
        }
    }

    private void removePortletSupportingPublicRenderParameters(List<PortletID> portletIDs) {
        if (portletIDs != null) {
            for (PortletID portletID : portletIDs) {
                this.portletSupportingPublicRenderParameters.remove(portletID);
            }
        }
    }

    private void removePublicRenderParameterHolders(String portletAppName) {
        this.appPublicRenderParameterHolders.remove(portletAppName);
    }

    private void removeEventHolders(String portletAppName) {
        this.appEventHolders.remove(portletAppName);
    }

    private ContainerEventService getContainerEventService() {
        return (ContainerEventService)ServiceManager.getServiceManager().getService("com.sun.portal.container.service.ContainerEventService");
    }

    private void printInformation() {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "PSPL_PAECSPPA0020", this.eventProcessingPortlets);
            logger.log(Level.FINER, "PSPL_PAECSPPA0021", this.eventPublishingPortlets);
            logger.log(Level.FINER, "PSPL_PAECSPPA0034", this.portletSupportingProcessingEvents);
            logger.log(Level.FINER, "PSPL_PAECSPPA0035", this.portletSupportingPublishingEvents);
            logger.log(Level.FINER, "PSPL_PAECSPPA0027", this.publicRenderParameterSupportingPortlets);
            logger.log(Level.FINER, "PSPL_PAECSPPA0028", this.portletSupportingPublicRenderParameters);
            logger.log(Level.FINER, "PSPL_PAECSPPA0029", this.appPublicRenderParameterHolders);
            logger.log(Level.FINER, "PSPL_PAECSPPA0033", this.appEventHolders);
        }
    }

    static {
        containerEvents.add("urn:oasis:names:tc:wsrp:v2:types");
        logger = ContainerLogger.getLogger(PortletDescriptorHolderImpl.class, (String)"PAELogMessages");
    }
}

