/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.container.ChannelURLType;
import com.sun.portal.container.ContainerLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;

public class PortletAppEngineUtils {
    private static int MAJOR_VERSION = 3;
    private static int MINOR_VERSION = 5;
    private static final String SERVLET_MAPPING = "/servlet/PortletAppEngineServlet";
    private static Logger logger = ContainerLogger.getLogger(PortletAppEngineUtils.class, (String)"PAELogMessages");
    static Map<WindowState, ChannelState> windowStateChannelStateMap = new HashMap<WindowState, ChannelState>();
    static Map<ChannelState, WindowState> channelStateWindowStateMap;
    static Map<PortletMode, ChannelMode> portletModeChannelModeMap;
    static Map<ChannelMode, PortletMode> channelModePortletModeMap;
    static Map<String, ChannelURLType> urlTypeMap;

    public static ChannelURLType getURLType(String action) {
        return urlTypeMap.get(action);
    }

    public static PortletMode getPortletMode(ChannelMode channelMode) {
        PortletMode portletMode = channelModePortletModeMap.get(channelMode);
        if (portletMode == null && channelMode != null) {
            portletMode = new PortletMode(channelMode.toString());
        }
        return portletMode;
    }

    public static ChannelMode getChannelMode(PortletMode portletMode) {
        ChannelMode channelMode = portletModeChannelModeMap.get(portletMode);
        if (channelMode == null && portletMode != null) {
            channelMode = new ChannelMode(portletMode.toString());
        }
        return channelMode;
    }

    public static WindowState getWindowState(ChannelState channelState) {
        WindowState windowState = channelStateWindowStateMap.get(channelState);
        if (windowState == null && channelState != null) {
            windowState = new WindowState(channelState.toString());
        }
        return windowState;
    }

    public static ChannelState getChannelState(WindowState windowState) {
        ChannelState channelState = windowStateChannelStateMap.get(windowState);
        if (channelState == null && windowState != null) {
            channelState = new ChannelState(windowState.toString());
        }
        return channelState;
    }

    public static String getPortletAppName(ServletContext context) {
        String contextPath = null;
        if (context.getMinorVersion() >= MINOR_VERSION || context.getMajorVersion() >= MAJOR_VERSION) {
            contextPath = context.getContextPath();
        } else {
            String servletContextName = context.getServletContextName();
            if (servletContextName == null || servletContextName.trim().length() == 0) {
                String realPath = context.getRealPath(SERVLET_MAPPING).replace('\\', '/');
                if (realPath != null) {
                    int index = realPath.indexOf(SERVLET_MAPPING);
                    int lastIndex = realPath.lastIndexOf("/", index - 1);
                    contextPath = realPath.substring(lastIndex, index);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "PSPL_PAECSPPA0032", new String[]{realPath, String.valueOf(index), String.valueOf(lastIndex)});
                    }
                }
            } else {
                contextPath = servletContextName;
            }
        }
        int index = contextPath.indexOf("/");
        String portletAppName = index != -1 ? contextPath.substring(index + 1) : contextPath;
        return portletAppName;
    }

    static {
        windowStateChannelStateMap.put(WindowState.MINIMIZED, ChannelState.MINIMIZED);
        windowStateChannelStateMap.put(WindowState.MAXIMIZED, ChannelState.MAXIMIZED);
        windowStateChannelStateMap.put(WindowState.NORMAL, ChannelState.NORMAL);
        channelStateWindowStateMap = new HashMap<ChannelState, WindowState>();
        channelStateWindowStateMap.put(ChannelState.MINIMIZED, WindowState.MINIMIZED);
        channelStateWindowStateMap.put(ChannelState.MAXIMIZED, WindowState.MAXIMIZED);
        channelStateWindowStateMap.put(ChannelState.NORMAL, WindowState.NORMAL);
        portletModeChannelModeMap = new HashMap<PortletMode, ChannelMode>();
        portletModeChannelModeMap.put(PortletMode.VIEW, ChannelMode.VIEW);
        portletModeChannelModeMap.put(PortletMode.EDIT, ChannelMode.EDIT);
        portletModeChannelModeMap.put(PortletMode.HELP, ChannelMode.HELP);
        channelModePortletModeMap = new HashMap<ChannelMode, PortletMode>();
        channelModePortletModeMap.put(ChannelMode.VIEW, PortletMode.VIEW);
        channelModePortletModeMap.put(ChannelMode.EDIT, PortletMode.EDIT);
        channelModePortletModeMap.put(ChannelMode.HELP, PortletMode.HELP);
        urlTypeMap = new HashMap<String, ChannelURLType>();
        urlTypeMap.put("ACTION", ChannelURLType.ACTION);
        urlTypeMap.put("RENDER", ChannelURLType.RENDER);
        urlTypeMap.put("RESOURCE", ChannelURLType.RESOURCE);
    }
}

