/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.jackrabbit.guava.common.hash.Hashing;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentResponse;
import org.apache.jackrabbit.oak.segment.standby.server.FileStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseDecoder
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(ResponseDecoder.class);
    private final File spoolFolder;
    private int blobChunkSize;

    public ResponseDecoder(File spoolFolder) {
        this.spoolFolder = spoolFolder;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int length = in.readInt();
        switch (in.readByte()) {
            case 0: {
                log.debug("Decoding 'get head' response");
                ResponseDecoder.decodeGetHeadResponse(length, in, out);
                break;
            }
            case 1: {
                log.debug("Decoding 'get segment' response");
                ResponseDecoder.decodeGetSegmentResponse(length, in, out);
                break;
            }
            case 2: {
                log.debug("Decoding 'get blob' response");
                this.decodeGetBlobResponse(length, in, out);
                break;
            }
            case 3: {
                log.debug("Decoding 'get references' response");
                ResponseDecoder.decodeGetReferencesResponse(length, in, out);
                break;
            }
            default: {
                log.debug("Invalid type, dropping message");
            }
        }
    }

    private static void decodeGetHeadResponse(int length, ByteBuf in, List<Object> out) {
        byte[] data = new byte[length - 1];
        in.readBytes(data);
        String recordId = new String(data, StandardCharsets.UTF_8);
        out.add(new GetHeadResponse(null, recordId));
    }

    private static void decodeGetSegmentResponse(int length, ByteBuf in, List<Object> out) {
        long msb = in.readLong();
        long lsb = in.readLong();
        String segmentId = new UUID(msb, lsb).toString();
        long hash = in.readLong();
        byte[] data = new byte[length - 25];
        in.readBytes(data);
        if (ResponseDecoder.hash(data) != hash) {
            log.debug("Invalid checksum, discarding segment {}", (Object)segmentId);
            return;
        }
        out.add(new GetSegmentResponse(null, segmentId, data));
    }

    private void decodeGetBlobResponse(int length, ByteBuf in, List<Object> out) throws IOException {
        byte mask = in.readByte();
        long blobLength = in.readLong();
        int blobIdLength = in.readInt();
        byte[] blobIdBytes = new byte[blobIdLength];
        in.readBytes(blobIdBytes);
        String blobId = new String(blobIdBytes, StandardCharsets.UTF_8);
        File tempFile = new File(this.spoolFolder, blobId + ".tmp");
        if ((mask & 1) != 0) {
            this.blobChunkSize = in.readableBytes() - 8;
            if (Files.deleteIfExists(tempFile.toPath())) {
                log.debug("Deleted temporary file for previous incomplete transfer of {}", (Object)blobId);
            }
        }
        long hash = in.readLong();
        log.debug("Received chunk {}/{} of size {} from blob {}", new Object[]{FileStoreUtil.roundDiv(tempFile.length() + (long)in.readableBytes(), this.blobChunkSize), FileStoreUtil.roundDiv(blobLength, this.blobChunkSize), in.readableBytes(), blobId});
        byte[] chunkData = new byte[in.readableBytes()];
        in.readBytes(chunkData);
        if (ResponseDecoder.hash(mask, blobLength, chunkData) != hash) {
            log.debug("Invalid checksum, discarding current chunk from {}", (Object)blobId);
            return;
        }
        log.debug("All checks OK. Appending chunk to disk to {} ", (Object)tempFile.getAbsolutePath());
        try (FileOutputStream outStream = new FileOutputStream(tempFile, true);){
            ((OutputStream)outStream).write(chunkData);
        }
        if ((mask & 2) != 0) {
            log.debug("Received entire blob {}", (Object)blobId);
            if (blobLength == tempFile.length()) {
                out.add(new GetBlobResponse(null, blobId, new DeleteOnCloseFileInputStream(tempFile), blobLength));
            } else {
                log.debug("Blob {} discarded due to size mismatch. Expected size: {}, actual size: {} ", new Object[]{blobId, blobLength, tempFile.length()});
            }
        }
    }

    private static void decodeGetReferencesResponse(int length, ByteBuf in, List<Object> out) {
        byte[] data = new byte[length - 1];
        in.readBytes(data);
        String body = new String(data, StandardCharsets.UTF_8);
        int colon = body.indexOf(":");
        if (colon < 0) {
            return;
        }
        String segmentId = body.substring(0, colon);
        String referencesList = body.substring(colon + 1);
        List<Object> references = referencesList.isEmpty() ? Collections.emptyList() : Arrays.asList(referencesList.split(","));
        out.add(new GetReferencesResponse(null, segmentId, references));
    }

    private static long hash(byte[] data) {
        return Hashing.murmur3_32().newHasher().putBytes(data).hash().padToLong();
    }

    private static long hash(byte mask, long blobLength, byte[] data) {
        return Hashing.murmur3_32().newHasher().putByte(mask).putLong(blobLength).putBytes(data).hash().padToLong();
    }

    private static class DeleteOnCloseFileInputStream
    extends FileInputStream {
        private static final Logger log = LoggerFactory.getLogger(DeleteOnCloseFileInputStream.class);
        private final File file;

        DeleteOnCloseFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (Files.deleteIfExists(this.file.toPath())) {
                log.debug("File {} was deleted", (Object)this.file.getAbsolutePath());
            } else {
                log.debug("Could not delete {}, not found", (Object)this.file.getAbsoluteFile());
            }
        }
    }
}

