/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.survey;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerPK;
import org.silverpeas.core.questioncontainer.container.service.QuestionContainerService;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;

@Provider
@Named(value="surveyStatistics")
public class SurveyStatistics
implements ComponentStatisticsProvider {
    @Inject
    private QuestionContainerService questionContainerService;

    public Collection<UserIdCountVolumeCouple> getVolume(String spaceId, String componentId) {
        ArrayList<UserIdCountVolumeCouple> myArrayList = new ArrayList<UserIdCountVolumeCouple>();
        Collection<QuestionContainerHeader> c = this.getOpenedSurveys(spaceId, componentId);
        this.addSurveys(c, myArrayList);
        c = this.getClosedSurveys(spaceId, componentId);
        this.addSurveys(c, myArrayList);
        c = this.getInWaitSurveys(spaceId, componentId);
        this.addSurveys(c, myArrayList);
        return myArrayList;
    }

    private void addSurveys(Collection<QuestionContainerHeader> c, List<UserIdCountVolumeCouple> al) {
        for (QuestionContainerHeader surveyHeader : c) {
            UserIdCountVolumeCouple myCouple = new UserIdCountVolumeCouple();
            myCouple.setUserId(surveyHeader.getCreatorId());
            myCouple.setCountVolume(1L);
            al.add(myCouple);
        }
    }

    private QuestionContainerService getQuestionContainerService() {
        return this.questionContainerService;
    }

    private Collection<QuestionContainerHeader> getOpenedSurveys(String spaceId, String componentId) {
        return this.getQuestionContainerService().getOpenedQuestionContainers(new QuestionContainerPK(null, spaceId, componentId));
    }

    private Collection<QuestionContainerHeader> getClosedSurveys(String spaceId, String componentId) {
        return this.getQuestionContainerService().getClosedQuestionContainers(new QuestionContainerPK(null, spaceId, componentId));
    }

    private Collection<QuestionContainerHeader> getInWaitSurveys(String spaceId, String componentId) {
        return this.getQuestionContainerService().getInWaitQuestionContainers(new QuestionContainerPK(null, spaceId, componentId));
    }
}

