/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Objects;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;

public final class Revision
implements CacheValue {
    static final int REV_STRING_APPROX_SIZE = Revision.newRevision(0).toString().length() + 2;
    static final int SHALLOW_MEMORY_USAGE = 32;
    private static volatile long lastTimestamp;
    private static volatile long lastRevisionTimestamp;
    private static volatile int lastRevisionCount;
    private final long timestamp;
    private final int counter;
    private final int clusterId;
    private final boolean branch;
    private static Clock clock;

    static void setClock(Clock c) {
        Objects.requireNonNull(c);
        clock = c;
        lastTimestamp = clock.getTime();
        lastRevisionTimestamp = clock.getTime();
    }

    static void resetClockToDefault() {
        Revision.setClock(Clock.SIMPLE);
    }

    public Revision(long timestamp, int counter, int clusterId) {
        this(timestamp, counter, clusterId, false);
    }

    public Revision(long timestamp, int counter, int clusterId, boolean branch) {
        this.timestamp = timestamp;
        this.counter = counter;
        this.clusterId = clusterId;
        this.branch = branch;
    }

    int compareRevisionTime(Revision other) {
        int comp;
        if (this.clusterId != other.clusterId) {
            throw new IllegalArgumentException("Trying to compare revisions of different cluster ids: " + this + " and " + other);
        }
        int n = this.timestamp < other.timestamp ? -1 : (comp = this.timestamp > other.timestamp ? 1 : 0);
        if (comp == 0) {
            comp = this.counter < other.counter ? -1 : (this.counter > other.counter ? 1 : 0);
        }
        return comp;
    }

    int compareRevisionTimeThenClusterId(Revision other) {
        int comp;
        int n = this.timestamp < other.timestamp ? -1 : (comp = this.timestamp > other.timestamp ? 1 : 0);
        if (comp == 0) {
            int n2 = this.counter < other.counter ? -1 : (comp = this.counter > other.counter ? 1 : 0);
        }
        if (comp == 0) {
            comp = this.compareClusterId(other);
        }
        return comp;
    }

    int compareTo(Revision other) {
        int comp = this.compareRevisionTimeThenClusterId(other);
        if (comp == 0 && this.branch != other.branch) {
            return this.branch ? -1 : 1;
        }
        return comp;
    }

    int compareClusterId(Revision other) {
        return this.clusterId < other.clusterId ? -1 : (this.clusterId > other.clusterId ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Revision newRevision(int clusterId) {
        long timestamp = Revision.getCurrentTimestamp();
        Class<Revision> clazz = Revision.class;
        synchronized (Revision.class) {
            int c;
            if (timestamp < lastRevisionTimestamp) {
                timestamp = lastRevisionTimestamp;
            }
            if (timestamp == lastRevisionTimestamp) {
                c = ++lastRevisionCount;
            } else {
                lastRevisionTimestamp = timestamp;
                c = 0;
                lastRevisionCount = 0;
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return new Revision(timestamp, c, clusterId);
        }
    }

    public static long getCurrentTimestamp() {
        long timestamp = System.currentTimeMillis();
        if (clock != null) {
            timestamp = clock.getTime();
        }
        if (timestamp < lastTimestamp) {
            timestamp = lastTimestamp;
        } else if (timestamp > lastTimestamp) {
            lastTimestamp = timestamp;
        }
        return timestamp;
    }

    public static long getTimestampDifference(Revision r1, Revision r2) {
        return r1.getTimestamp() - r2.getTimestamp();
    }

    public static Revision fromString(String rev) {
        char c;
        char c2;
        int idx;
        boolean isBranch = rev.charAt(0) == 'b';
        int n = idx = isBranch ? 2 : 1;
        if (rev.charAt(idx - 1) != 'r') {
            throw new IllegalArgumentException(rev);
        }
        int len = rev.length();
        long timestamp = 0L;
        while (idx < len && (c2 = rev.charAt(idx)) != '-') {
            int digit = c2 >= 'a' ? c2 - 97 + 10 : c2 - 48;
            timestamp = (timestamp << 4) + (long)digit;
            ++idx;
        }
        int counter = 0;
        ++idx;
        while (idx < len && (c = rev.charAt(idx)) != '-') {
            int digit = c >= 'a' ? c - 97 + 10 : c - 48;
            counter = (counter << 4) + digit;
            ++idx;
        }
        int clusterId = 0;
        ++idx;
        while (idx < len) {
            char c3 = rev.charAt(idx);
            int digit = c3 >= 'a' ? c3 - 97 + 10 : c3 - 48;
            clusterId = (clusterId << 4) + digit;
            ++idx;
        }
        return new Revision(timestamp, counter, clusterId, isBranch);
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder(REV_STRING_APPROX_SIZE)).toString();
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        if (this.branch) {
            sb.append('b');
        }
        sb.append('r');
        Revision.toHexString(sb, this.timestamp);
        sb.append('-');
        Revision.toHexString(sb, this.counter);
        sb.append('-');
        Revision.toHexString(sb, this.clusterId);
        return sb;
    }

    public String toReadableString() {
        StringBuilder buff = new StringBuilder();
        buff.append("revision: \"").append(this.toString()).append("\"");
        buff.append(", clusterId: ").append(this.clusterId);
        buff.append(", time: \"").append(Utils.timestampToString(this.timestamp)).append("\"");
        if (this.counter > 0) {
            buff.append(", counter: ").append(this.counter);
        }
        if (this.branch) {
            buff.append(", branch: true");
        }
        return buff.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean isBranch() {
        return this.branch;
    }

    public Revision asBranchRevision() {
        if (this.isBranch()) {
            return this;
        }
        return new Revision(this.timestamp, this.counter, this.clusterId, true);
    }

    public Revision asTrunkRevision() {
        if (!this.isBranch()) {
            return this;
        }
        return new Revision(this.timestamp, this.counter, this.clusterId);
    }

    public int hashCode() {
        return (int)(this.timestamp >>> 32) ^ (int)this.timestamp ^ this.counter ^ this.clusterId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Revision r = (Revision)other;
        return r.timestamp == this.timestamp && r.counter == this.counter && r.clusterId == this.clusterId && r.branch == this.branch;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public int getMemory() {
        return 32;
    }

    private static void toHexString(StringBuilder sb, long x) {
        int bitCount = 64 - Long.numberOfLeadingZeros(x);
        for (int i = bitCount = Math.max(0, (bitCount + 3) / 4 * 4 - 4); i >= 0; i -= 4) {
            int t = (int)(x >> i) & 0xF;
            t = t > 9 ? t - 10 + 97 : (t += 48);
            sb.append((char)t);
        }
    }
}

