/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.plugins.document.FullGCStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.GaugeStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;

class FullGCStatsCollectorImpl
implements FullGCStatsCollector {
    static final String OAK_RUN_METRICS_PREFIX = "oak_FullGC";
    static final String FULL_GC = "FullGC";
    static final String READ_DOC = "READ_DOC";
    static final String DELETED_ORPHAN_NODE = "DELETED_ORPHAN_NODE";
    static final String DELETED_PROPERTY = "DELETED_PROPERTY";
    static final String DELETED_INTERNAL_PROPERTY = "DELETED_INTERNAL_PROPERTY";
    static final String DELETED_UNMERGED_BC = "DELETED_UNMERGED_BC";
    static final String DELETED_REVISION = "DELETED_REVISION";
    static final String UPDATED_DOC = "UPDATED_DOC";
    static final String SKIPPED_DOC = "SKIPPED_DOC";
    static final String FULL_GC_ACTIVE_TIMER = "FULL_GC_ACTIVE_TIMER";
    static final String FULL_GC_TIMER = "FULL_GC_TIMER";
    static final String COLLECT_FULL_GC_TIMER = "COLLECT_FULL_GC_TIMER";
    static final String COLLECT_ORPHAN_NODES_TIMER = "COLLECT_ORPHAN_NODES_TIMER";
    static final String COLLECT_DELETED_PROPS_TIMER = "COLLECT_DELETED_PROPS_TIMER";
    static final String COLLECT_DELETED_OLD_REVS_TIMER = "COLLECT_DELETED_OLD_REVS_TIMER";
    static final String COLLECT_UNMERGED_BC_TIMER = "COLLECT_UNMERGED_BC_TIMER";
    static final String DELETE_FULL_GC_DOCS_TIMER = "DELETE_FULL_GC_DOCS_TIMER";
    static final String COUNTER = "COUNTER";
    static final String FAILURE_COUNTER = "FAILURE";
    static final String ENABLED = "ENABLED";
    static final String MODE = "MODE";
    static final String DELAY_FACTOR = "DELAY_FACTOR";
    static final String BATCH_SIZE = "BATCH_SIZE";
    static final String PROGRESS_SIZE = "PROGRESS_SIZE";
    static final String EMBEDDED_VERIFICATION_ENABLED = "EMBEDDED_VERIFICATION_ENABLED";
    static final String MAX_AGE = "MAX_AGE";
    static final String FULL_GC_GENERATION = "FULL_GC_GENERATION";
    private final StatisticsProvider provider;
    private final MeterStats readDoc;
    private final MeterStats deletedOrphanNode;
    private final MeterStats deletedProperty;
    private final MeterStats deletedUnmergedBC;
    private final MeterStats updatedDoc;
    private final MeterStats skippedDoc;
    private final Map<VersionGarbageCollector.GCPhase, MeterStats> candidateRevisions;
    private final Map<VersionGarbageCollector.GCPhase, MeterStats> candidateInternalRevisions;
    private final Map<VersionGarbageCollector.GCPhase, MeterStats> candidateProperties;
    private final Map<VersionGarbageCollector.GCPhase, MeterStats> candidateDocuments;
    private final TimerStats fullGCActiveTimer;
    private final TimerStats fullGCTimer;
    private final TimerStats collectFullGCTimer;
    private final TimerStats collectOrphanNodesTimer;
    private final TimerStats collectDeletedPropsTimer;
    private final TimerStats collectDeletedOldRevsTimer;
    private final TimerStats collectUnmergedBCTimer;
    private final TimerStats deleteFullGCDocsTimer;
    private final CounterStats counter;
    private final CounterStats failureCounter;
    private static String METRICS_QUALIFIED_NAME_PREFIX;
    private GaugeStats<Boolean> enabled;
    private GaugeStats<Integer> mode;
    private GaugeStats<Double> delayFactor;
    private GaugeStats<Integer> batchSize;
    private GaugeStats<Integer> progressSize;
    private GaugeStats<Boolean> embeddedVerificationEnabled;
    private GaugeStats<Long> maxAge;
    private GaugeStats<Long> fullGCGeneration;

    FullGCStatsCollectorImpl(StatisticsProvider provider) {
        this(provider, false);
    }

    FullGCStatsCollectorImpl(StatisticsProvider provider, boolean isOakRunJob) {
        this.provider = provider;
        METRICS_QUALIFIED_NAME_PREFIX = isOakRunJob ? OAK_RUN_METRICS_PREFIX : FULL_GC;
        this.readDoc = FullGCStatsCollectorImpl.meter(provider, READ_DOC);
        this.deletedOrphanNode = FullGCStatsCollectorImpl.meter(provider, DELETED_ORPHAN_NODE);
        this.deletedProperty = FullGCStatsCollectorImpl.meter(provider, DELETED_PROPERTY);
        this.deletedUnmergedBC = FullGCStatsCollectorImpl.meter(provider, DELETED_UNMERGED_BC);
        this.updatedDoc = FullGCStatsCollectorImpl.meter(provider, UPDATED_DOC);
        this.skippedDoc = FullGCStatsCollectorImpl.meter(provider, SKIPPED_DOC);
        this.candidateRevisions = new EnumMap<VersionGarbageCollector.GCPhase, MeterStats>(VersionGarbageCollector.GCPhase.class);
        this.candidateInternalRevisions = new EnumMap<VersionGarbageCollector.GCPhase, MeterStats>(VersionGarbageCollector.GCPhase.class);
        this.candidateProperties = new EnumMap<VersionGarbageCollector.GCPhase, MeterStats>(VersionGarbageCollector.GCPhase.class);
        this.candidateDocuments = new EnumMap<VersionGarbageCollector.GCPhase, MeterStats>(VersionGarbageCollector.GCPhase.class);
        this.fullGCActiveTimer = FullGCStatsCollectorImpl.timer(provider, FULL_GC_ACTIVE_TIMER);
        this.fullGCTimer = FullGCStatsCollectorImpl.timer(provider, FULL_GC_TIMER);
        this.collectFullGCTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_FULL_GC_TIMER);
        this.collectOrphanNodesTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_ORPHAN_NODES_TIMER);
        this.collectDeletedPropsTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_DELETED_PROPS_TIMER);
        this.collectDeletedOldRevsTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_DELETED_OLD_REVS_TIMER);
        this.collectUnmergedBCTimer = FullGCStatsCollectorImpl.timer(provider, COLLECT_UNMERGED_BC_TIMER);
        this.deleteFullGCDocsTimer = FullGCStatsCollectorImpl.timer(provider, DELETE_FULL_GC_DOCS_TIMER);
        this.counter = FullGCStatsCollectorImpl.counter(provider, COUNTER);
        this.failureCounter = FullGCStatsCollectorImpl.counter(provider, FAILURE_COUNTER);
    }

    @Override
    public void documentRead() {
        this.readDoc.mark();
    }

    @Override
    public void candidateProperties(VersionGarbageCollector.GCPhase phase, long numProps) {
        this.getMeter(this.candidateProperties, phase, DELETED_PROPERTY).mark(numProps);
    }

    @Override
    public void candidateDocuments(VersionGarbageCollector.GCPhase phase, long numDocs) {
        this.getMeter(this.candidateDocuments, phase, DELETED_UNMERGED_BC).mark(numDocs);
    }

    @Override
    public void candidateRevisions(VersionGarbageCollector.GCPhase phase, long numRevs) {
        this.getMeter(this.candidateRevisions, phase, DELETED_REVISION).mark(numRevs);
    }

    @Override
    public void candidateInternalRevisions(VersionGarbageCollector.GCPhase phase, long numRevs) {
        this.getMeter(this.candidateInternalRevisions, phase, DELETED_INTERNAL_PROPERTY).mark(numRevs);
    }

    @Override
    public void orphanNodesDeleted(long numNodes) {
        this.deletedOrphanNode.mark(numNodes);
    }

    @Override
    public void propertiesDeleted(long numProps) {
        this.deletedProperty.mark(numProps);
    }

    @Override
    public void unmergedBranchCommitsDeleted(long numCommits) {
        this.deletedUnmergedBC.mark(numCommits);
    }

    @Override
    public void documentsUpdated(long numDocs) {
        this.updatedDoc.mark(numDocs);
    }

    @Override
    public void documentsUpdateSkipped(long numDocs) {
        this.skippedDoc.mark(numDocs);
    }

    @Override
    public void started() {
        this.counter.inc();
    }

    @Override
    public void finished(VersionGarbageCollector.VersionGCStats stats) {
        this.fullGCActiveTimer.update(stats.fullGCActiveElapsed, TimeUnit.MICROSECONDS);
        this.fullGCTimer.update(stats.fullGCDocsElapsed, TimeUnit.MICROSECONDS);
        this.collectFullGCTimer.update(stats.collectFullGCElapsed, TimeUnit.MICROSECONDS);
        this.collectOrphanNodesTimer.update(stats.collectOrphanNodesElapsed, TimeUnit.MICROSECONDS);
        this.collectDeletedPropsTimer.update(stats.collectDeletedPropsElapsed, TimeUnit.MICROSECONDS);
        this.collectDeletedOldRevsTimer.update(stats.collectDeletedOldRevsElapsed, TimeUnit.MICROSECONDS);
        this.collectUnmergedBCTimer.update(stats.collectUnmergedBCElapsed, TimeUnit.MICROSECONDS);
        this.deleteFullGCDocsTimer.update(stats.deleteFullGCDocsElapsed, TimeUnit.MICROSECONDS);
        if (!stats.success) {
            this.failureCounter.inc();
        }
    }

    @Override
    public void enabled(boolean enabled) {
        this.enabled = FullGCStatsCollectorImpl.gauge(this.provider, ENABLED, () -> enabled);
    }

    @Override
    public void mode(int mode) {
        this.mode = FullGCStatsCollectorImpl.gauge(this.provider, MODE, () -> mode);
    }

    @Override
    public void verificationEnabled(boolean verificationEnabled) {
        this.embeddedVerificationEnabled = FullGCStatsCollectorImpl.gauge(this.provider, EMBEDDED_VERIFICATION_ENABLED, () -> verificationEnabled);
    }

    @Override
    public void delayFactor(double delayFactor) {
        this.delayFactor = FullGCStatsCollectorImpl.gauge(this.provider, DELAY_FACTOR, () -> delayFactor);
    }

    @Override
    public void batchSize(int batchSize) {
        this.batchSize = FullGCStatsCollectorImpl.gauge(this.provider, BATCH_SIZE, () -> batchSize);
    }

    @Override
    public void progressSize(int progressSize) {
        this.progressSize = FullGCStatsCollectorImpl.gauge(this.provider, PROGRESS_SIZE, () -> progressSize);
    }

    @Override
    public void maxAge(long maxAge) {
        this.maxAge = FullGCStatsCollectorImpl.gauge(this.provider, MAX_AGE, () -> maxAge);
    }

    @Override
    public void fullGCGeneration(long generation) {
        this.fullGCGeneration = FullGCStatsCollectorImpl.gauge(this.provider, FULL_GC_GENERATION, () -> generation);
    }

    public String toString() {
        return "FullGCStatsCollectorImpl{enabled=" + this.getValue(this.enabled, "false") + ", mode=" + this.getValue(this.mode, "0") + ", delayFactor=" + this.getValue(this.delayFactor, "0.0") + ", batchSize=" + this.getValue(this.batchSize, "0") + ", progressSize=" + this.getValue(this.progressSize, "0") + ", embeddedVerificationEnabled=" + this.getValue(this.embeddedVerificationEnabled, "false") + ", maxAge=" + this.getValue(this.maxAge, "0") + ", fullGCGeneration=" + this.getValue(this.fullGCGeneration, "0") + ", readDoc=" + this.readDoc.getCount() + ", candidateRevisions=" + this.mapToString(this.candidateRevisions) + ", candidateInternalRevisions=" + this.mapToString(this.candidateInternalRevisions) + ", candidateProperties=" + this.mapToString(this.candidateProperties) + ", candidateDocuments=" + this.mapToString(this.candidateDocuments) + ", deletedOrphanNode=" + this.deletedOrphanNode.getCount() + ", deletedProperty=" + this.deletedProperty.getCount() + ", deletedUnmergedBC=" + this.deletedUnmergedBC.getCount() + ", updatedDoc=" + this.updatedDoc.getCount() + ", skippedDoc=" + this.skippedDoc.getCount() + "}";
    }

    private String mapToString(Map<VersionGarbageCollector.GCPhase, MeterStats> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean isFirst = true;
        for (Map.Entry<VersionGarbageCollector.GCPhase, MeterStats> entry : map.entrySet()) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append((Object)entry.getKey()).append("=").append(entry.getValue().getCount());
            isFirst = false;
        }
        sb.append("}");
        return sb.toString();
    }

    private static MeterStats meter(StatisticsProvider provider, String name) {
        return provider.getMeter(FullGCStatsCollectorImpl.qualifiedName(name), StatsOptions.DEFAULT);
    }

    private static TimerStats timer(StatisticsProvider provider, String name) {
        return provider.getTimer(FullGCStatsCollectorImpl.qualifiedName(name), StatsOptions.METRICS_ONLY);
    }

    private static CounterStats counter(StatisticsProvider provider, String name) {
        return provider.getCounterStats(FullGCStatsCollectorImpl.qualifiedName(name), StatsOptions.METRICS_ONLY);
    }

    private static <T> GaugeStats<T> gauge(StatisticsProvider provider, String name, Supplier<T> value) {
        return provider.getGauge(FullGCStatsCollectorImpl.qualifiedName(name), value);
    }

    private static String qualifiedName(String metricName) {
        return METRICS_QUALIFIED_NAME_PREFIX + "." + metricName;
    }

    private MeterStats getMeter(Map<VersionGarbageCollector.GCPhase, MeterStats> map, VersionGarbageCollector.GCPhase phase, String name) {
        return map.computeIfAbsent(phase, p -> FullGCStatsCollectorImpl.meter(this.provider, name + "." + p.name()));
    }

    private String getValue(GaugeStats<?> gaugeStats, String defaultValue) {
        return gaugeStats != null ? String.valueOf(gaugeStats.getValue()) : defaultValue;
    }
}

