/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.answer.service;

import java.sql.Connection;
import java.util.Collection;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.answer.dao.AnswerDAO;
import org.silverpeas.core.questioncontainer.answer.model.Answer;
import org.silverpeas.core.questioncontainer.answer.model.AnswerPK;
import org.silverpeas.core.questioncontainer.answer.model.AnswerRuntimeException;
import org.silverpeas.core.questioncontainer.answer.service.AnswerService;

@Service
@Singleton
@Transactional(value=Transactional.TxType.REQUIRED)
public class DefaultAnswerService
implements AnswerService {
    protected DefaultAnswerService() {
    }

    @Override
    @Transactional(value=Transactional.TxType.SUPPORTS)
    public Collection<Answer> getAnswersByQuestionPK(ResourceReference questionPK) {
        Connection con = this.getConnection();
        try {
            Collection<Answer> collection = AnswerDAO.getAnswersByQuestionPK(con, questionPK);
            return collection;
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void recordThisAnswerAsVote(ResourceReference questionPK, AnswerPK answerPK) {
        Connection con = this.getConnection();
        try {
            AnswerDAO.recordThisAnswerAsVote(con, questionPK, answerPK);
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void addAnswersToAQuestion(Collection<Answer> answers, ResourceReference questionPK) {
        Connection con = this.getConnection();
        try {
            AnswerDAO.addAnswersToAQuestion(con, answers, questionPK);
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void addAnswerToAQuestion(Answer answer, ResourceReference questionPK) {
        Connection con = this.getConnection();
        try {
            AnswerDAO.addAnswerToAQuestion(con, answer, questionPK);
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void deleteAnswersToAQuestion(ResourceReference questionPK) {
        Connection con = this.getConnection();
        try {
            AnswerDAO.deleteAnswersToAQuestion(con, questionPK);
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void deleteAnswerToAQuestion(ResourceReference questionPK, String answerId) {
        Connection con = this.getConnection();
        try {
            AnswerDAO.deleteAnswerToAQuestion(con, questionPK, answerId);
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void updateAnswerToAQuestion(ResourceReference questionPK, Answer answer) {
        Connection con = this.getConnection();
        try {
            AnswerDAO.updateAnswerToAQuestion(con, questionPK, answer);
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
    }
}

