/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.util;

import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.Pair;

public class ServiceLoader {
    private static final Map<String, Factory<?>> loaded = new ConcurrentHashMap();

    private ServiceLoader() {
    }

    public static <T> T load(Class<T> service) {
        java.util.ServiceLoader implementations = java.util.ServiceLoader.load(service);
        return (T)implementations.stream().filter(p -> p.type().isAnnotationPresent(Priority.class)).map(p -> Pair.of(p, p.type().getAnnotation(Priority.class).value())).max(Comparator.comparingInt(Pair::getSecond)).map(Pair::getFirst).map(ServiceLoader.Provider::get).orElseGet(() -> implementations.findFirst().orElseThrow(() -> new SilverpeasRuntimeException("No " + service.getSimpleName() + " found! At least one should be available!")));
    }

    public static <T> T get(Class<T> service) {
        Factory factory = loaded.computeIfAbsent(service.getSimpleName() + "#instance", k -> new Factory(service));
        return factory.getInstance();
    }

    private static class Factory<T> {
        private final T instance;

        private Factory(Class<T> service) {
            this.instance = ServiceLoader.load(service);
        }

        public T getInstance() {
            return this.instance;
        }
    }
}

