/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.logging;

import org.silverpeas.kernel.logging.Logger;
import org.silverpeas.kernel.logging.LoggerConfigurationManager;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.logging.SilverLoggerFactory;

public class SilverLoggerProvider {
    public static final String ROOT_NAMESPACE = "silverpeas";
    private static SilverLoggerProvider instance;
    private final LoggerConfigurationManager configurationManager;
    private final SilverLoggerFactory loggerFactory = SilverLoggerFactory.getInstance();

    public static synchronized SilverLoggerProvider getInstance() {
        if (instance == null) {
            instance = new SilverLoggerProvider();
        }
        return instance;
    }

    private SilverLoggerProvider() {
        this.configurationManager = new LoggerConfigurationManager();
        this.configurationManager.loadAllConfigurationFiles();
    }

    public SilverLogger getLogger(String module) {
        LoggerConfigurationManager.LoggerConfiguration configuration = this.configurationManager.getLoggerConfiguration(module);
        return this.loggerFactory.getLogger(configuration.getNamespace(), configuration);
    }

    public SilverLogger getLogger(Object object) {
        Class<?> type = object instanceof Class ? (Class<?>)object : object.getClass();
        Package pkg = type.getPackage();
        Logger logger = pkg.isAnnotationPresent(Logger.class) ? pkg.getAnnotation(Logger.class) : type.getAnnotation(Logger.class);
        String fqn = logger != null ? logger.value() : pkg.getName();
        String namespace = fqn.startsWith("org.silverpeas") ? fqn.substring(fqn.indexOf(46) + 1) : fqn;
        return this.getLogger(namespace);
    }

    public LoggerConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }
}

