/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatisticsManager;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

class SilverStatisticsVolumeAlimentation {
    static void makeVolumeAlimentationForAllComponents() {
        Date now = new Date();
        List<String> listAllSpacesId = SilverStatisticsVolumeAlimentation.getAllSpacesAndAllSubSpacesId();
        if (!listAllSpacesId.isEmpty()) {
            for (String currentSpaceId : listAllSpacesId) {
                List<ComponentInst> listAllComponentsInst = SilverStatisticsVolumeAlimentation.getAllComponentsInst(currentSpaceId);
                for (ComponentInst ci : listAllComponentsInst) {
                    String currentComponentsId = ci.getId();
                    SilverStatisticsVolumeAlimentation.getCollectionUserIdCountVolume(currentSpaceId, ci).forEach(v -> SilverStatisticsManager.getInstance().addStatVolume(v.getUserId(), v.getCountVolume(), now, ci.getName(), currentSpaceId, currentComponentsId));
                }
            }
        }
    }

    private static List<String> getAllSpacesAndAllSubSpacesId() {
        ArrayList<String> resultList = new ArrayList<String>();
        String[] spaceIds = SilverStatisticsVolumeAlimentation.getAdminController().getAllSpaceIds();
        if (spaceIds != null) {
            resultList.addAll(Arrays.asList(spaceIds));
        }
        return resultList;
    }

    private static List<ComponentInst> getAllComponentsInst(String spaceId) {
        SpaceInst mySpaceInst = SilverStatisticsVolumeAlimentation.getAdminController().getSpaceInstById(spaceId);
        return mySpaceInst.getAllComponentsInst();
    }

    private static Collection<UserIdCountVolumeCouple> getCollectionUserIdCountVolume(String spaceId, ComponentInst ci) {
        Collection<UserIdCountVolumeCouple> result = Collections.emptyList();
        try {
            Optional<ComponentStatisticsProvider> statistics = ComponentStatisticsProvider.getByComponentName(ci.getName());
            if (statistics.isPresent()) {
                Collection<UserIdCountVolumeCouple> v = statistics.get().getVolume(spaceId, ci.getId());
                result = SilverStatisticsVolumeAlimentation.aggregateUser(v);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger(SilverStatisticsVolumeAlimentation.class).warn(e.getMessage(), new Object[]{e});
        }
        return result;
    }

    private static Collection<UserIdCountVolumeCouple> aggregateUser(Collection<UserIdCountVolumeCouple> in) {
        if (CollectionUtil.isEmpty(in)) {
            return Collections.emptyList();
        }
        ArrayList<UserIdCountVolumeCouple> myArrayList = new ArrayList<UserIdCountVolumeCouple>(in.size());
        for (UserIdCountVolumeCouple eltIn : in) {
            UserIdCountVolumeCouple eltOut = SilverStatisticsVolumeAlimentation.getCouple(myArrayList, eltIn);
            if (eltOut == null) {
                myArrayList.add(eltIn);
                continue;
            }
            eltOut.setCountVolume(eltIn.getCountVolume() + eltOut.getCountVolume());
        }
        return myArrayList;
    }

    private static UserIdCountVolumeCouple getCouple(Collection<UserIdCountVolumeCouple> in, UserIdCountVolumeCouple eltIn) {
        for (UserIdCountVolumeCouple elt : in) {
            if (!elt.getUserId().equals(eltIn.getUserId())) continue;
            return elt;
        }
        return null;
    }

    private static AdminController getAdminController() {
        return (AdminController)ServiceProvider.getService(AdminController.class, (Annotation[])new Annotation[0]);
    }

    private SilverStatisticsVolumeAlimentation() {
    }
}

