/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.access.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;

public class HistoryCriteria {
    private final int actionType;
    private String resourceType;
    private List<String> resourceIds = Collections.emptyList();
    private List<String> componentInstanceIds = Collections.emptyList();
    private List<String> userIds = Collections.emptyList();
    private List<String> excludedUserIds = Collections.emptyList();
    private PaginationPage pagination;
    private List<QUERY_ORDER_BY> orderByList = Collections.singletonList(QUERY_ORDER_BY.ACCESS_DATE_DESC);

    public HistoryCriteria(int actionType) {
        this.actionType = actionType;
    }

    public HistoryCriteria onResource(ResourceReference resourceReference) {
        this.resourceIds = Collections.singletonList(resourceReference.getLocalId());
        this.componentInstanceIds = Collections.singletonList(resourceReference.getComponentInstanceId());
        return this;
    }

    public HistoryCriteria ofType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public HistoryCriteria aboutUsers(String ... userIds) {
        return this.aboutUsers(Arrays.stream(userIds));
    }

    public HistoryCriteria aboutUsers(Collection<String> userIds) {
        return this.aboutUsers(userIds.stream());
    }

    public HistoryCriteria aboutUsers(Stream<String> userIds) {
        this.userIds = userIds.filter(Objects::nonNull).collect(Collectors.toList());
        return this;
    }

    public HistoryCriteria byExcludingUsers(String ... excludedUserIds) {
        return this.byExcludingUsers(Arrays.stream(excludedUserIds));
    }

    public HistoryCriteria byExcludingUsers(Collection<String> excludedUserIds) {
        return this.byExcludingUsers(excludedUserIds.stream());
    }

    public HistoryCriteria byExcludingUsers(Stream<String> excludedUserIds) {
        this.excludedUserIds = excludedUserIds.filter(Objects::nonNull).collect(Collectors.toList());
        return this;
    }

    public HistoryCriteria paginatedBy(PaginationPage pagination) {
        this.pagination = pagination;
        return this;
    }

    public HistoryCriteria orderedBy(QUERY_ORDER_BY ... orderBies) {
        this.orderByList = Arrays.stream(orderBies).filter(Objects::nonNull).collect(Collectors.toList());
        return this;
    }

    public int getActionType() {
        return this.actionType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public List<String> getComponentInstanceIds() {
        return this.componentInstanceIds;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public List<String> getExcludedUserIds() {
        return this.excludedUserIds;
    }

    public PaginationCriterion getPagination() {
        return this.pagination != null ? this.pagination.asCriterion() : null;
    }

    public List<QUERY_ORDER_BY> getOrderByList() {
        return this.orderByList;
    }

    public static enum QUERY_ORDER_BY {
        ACCESS_DATE_ASC("datestat, heurestat"),
        ACCESS_DATE_DESC("datestat desc, heurestat desc");

        private final String clause;

        private QUERY_ORDER_BY(String clause) {
            this.clause = clause;
        }

        public String getClause() {
            return this.clause;
        }
    }
}

