/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.access.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.silverstatistics.access.model.HistoryByUser;
import org.silverpeas.core.silverstatistics.access.model.HistoryCriteria;
import org.silverpeas.core.silverstatistics.access.model.HistoryObjectDetail;
import org.silverpeas.core.silverstatistics.access.model.StatisticRuntimeException;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

public class HistoryObjectDAO {
    private static final String HISTORY_TABLE_NAME = "SB_Statistic_History";
    private static final String USER_ID = "userId";
    private static final String QUERY_STATISTIC_INSERT = "INSERT INTO SB_Statistic_History (dateStat, heureStat, userId, resourceId, componentId, actionType, resourceType) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String QUERY_STATISTIC_DELETE_BY_RESOURCE = "DELETE FROM SB_Statistic_History WHERE resourceId = ? AND componentId = ? AND resourceType = ?";
    private static final String QUERY_STATISTIC_DELETE_BY_COMPONENT = "DELETE FROM SB_Statistic_History WHERE componentId = ?";
    private static final String QUERY_STATISTIC_COUNT = "SELECT COUNT(resourceId) FROM SB_Statistic_History WHERE resourceId=? AND ComponentId =? AND resourceType = ?";
    private static final String QUERY_STATISTIC_COUNT_BY_PERIOD = "SELECT COUNT(resourceId) FROM SB_Statistic_History WHERE resourceId=? AND ComponentId =? AND resourceType = ? AND datestat >= ? AND datestat <= ?";
    private static final String RESOURCE_ID = "resourceId";

    private HistoryObjectDAO() {
    }

    private static HistoryByUser getHistoryByUser(ResultSet rs) throws SQLException {
        Date date;
        String userId = rs.getString(1);
        try {
            String[] dateTime = rs.getString(2).split("T");
            date = DateUtil.parse((String)dateTime[0]);
            date = DateUtil.getDate((Date)date, (String)dateTime[1]);
        }
        catch (ParseException e) {
            throw new StatisticRuntimeException(e);
        }
        int nbAccess = rs.getInt(3);
        return new HistoryByUser(userId, date, nbAccess);
    }

    private static HistoryObjectDetail getHistoryDetail(ResultSet rs) throws SQLException {
        Date date;
        try {
            date = DateUtil.parse((String)rs.getString(1));
            date = DateUtil.getDate((Date)date, (String)rs.getString(2));
        }
        catch (ParseException e) {
            throw new StatisticRuntimeException(e);
        }
        String userId = rs.getString(3);
        String foreignId = rs.getString(4);
        String componentId = rs.getString(5);
        ResourceReference resourceReference = new ResourceReference(foreignId, componentId);
        return new HistoryObjectDetail(date, userId, resourceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Connection con, String userId, ResourceReference resourceReference, int actionType, String objectType) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            Date now = new Date();
            prepStmt = con.prepareStatement(QUERY_STATISTIC_INSERT);
            prepStmt.setString(1, DateUtil.date2SQLDate((Date)now));
            prepStmt.setString(2, DateUtil.formatTime((Date)now));
            prepStmt.setString(3, userId);
            prepStmt.setString(4, resourceReference.getId());
            prepStmt.setString(5, resourceReference.getInstanceId());
            prepStmt.setInt(6, actionType);
            prepStmt.setString(7, objectType);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static SilverpeasList<HistoryByUser> findByUserByCriteria(Connection con, HistoryCriteria criteria) throws SQLException {
        JdbcSqlQuery sqlQuery = JdbcSqlQuery.select((String)"userId, max(concat(dateStat, concat('T', heureStat))) as lastAccess, count(userId) as nbAccess");
        HistoryObjectDAO.applySqlCriteria(sqlQuery, criteria);
        return sqlQuery.groupBy(new String[]{USER_ID}).orderBy(new String[]{"lastAccess desc, nbAccess desc"}).withPagination(criteria.getPagination()).executeWith(con, HistoryObjectDAO::getHistoryByUser);
    }

    public static SilverpeasList<HistoryObjectDetail> findByCriteria(Connection con, HistoryCriteria criteria) throws SQLException {
        JdbcSqlQuery sqlQuery = JdbcSqlQuery.select((String)"dateStat, heureStat, userId, resourceId, componentId");
        HistoryObjectDAO.applySqlCriteria(sqlQuery, criteria);
        if (!criteria.getOrderByList().isEmpty()) {
            sqlQuery.orderBy(new String[]{criteria.getOrderByList().stream().map(HistoryCriteria.QUERY_ORDER_BY::getClause).collect(Collectors.joining(", "))});
        }
        return sqlQuery.withPagination(criteria.getPagination()).executeWith(con, HistoryObjectDAO::getHistoryDetail);
    }

    private static void applySqlCriteria(JdbcSqlQuery sqlQuery, HistoryCriteria criteria) {
        sqlQuery.from(new String[]{HISTORY_TABLE_NAME}).where("actionType = ?", new Object[]{criteria.getActionType()});
        if (!criteria.getComponentInstanceIds().isEmpty()) {
            sqlQuery.and("componentId", new Object[0]).in(criteria.getComponentInstanceIds());
        }
        if (!criteria.getResourceIds().isEmpty()) {
            sqlQuery.and(RESOURCE_ID, new Object[0]).in(criteria.getResourceIds());
        }
        if (StringUtil.isDefined((String)criteria.getResourceType())) {
            sqlQuery.and("resourceType = ?", new Object[]{criteria.getResourceType()});
        }
        if (!criteria.getUserIds().isEmpty()) {
            sqlQuery.and(USER_ID, new Object[0]).in(criteria.getUserIds());
        }
        if (!criteria.getExcludedUserIds().isEmpty()) {
            sqlQuery.and(USER_ID, new Object[0]).notIn(criteria.getExcludedUserIds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHistoryByObject(Connection con, ResourceReference resourceReference, String objectType) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(QUERY_STATISTIC_DELETE_BY_RESOURCE);
            prepStmt.setString(1, resourceReference.getId());
            prepStmt.setString(2, resourceReference.getInstanceId());
            prepStmt.setString(3, objectType);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void deleteStatsOfComponent(Connection con, String componentId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(QUERY_STATISTIC_DELETE_BY_COMPONENT);
            prepStmt.setString(1, componentId);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static int getCount(Connection con, Collection<ResourceReference> resourceReferences, String objectType) throws SQLException {
        int nb = 0;
        for (ResourceReference pk : resourceReferences) {
            nb += HistoryObjectDAO.getCount(con, pk, objectType);
        }
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(Connection con, ResourceReference resourceReference, String objectType) throws SQLException {
        int n;
        int nb = 0;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(QUERY_STATISTIC_COUNT);
            prepStmt.setString(1, resourceReference.getId());
            prepStmt.setString(2, resourceReference.getInstanceId());
            prepStmt.setString(3, objectType);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                nb = rs.getInt(1);
            }
            n = nb;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCountByPeriod(Connection con, ResourceReference resourceRef, String objectType, Date startDate, Date endDate) throws SQLException {
        int n;
        int nb = 0;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(QUERY_STATISTIC_COUNT_BY_PERIOD);
            prepStmt.setString(1, resourceRef.getLocalId());
            prepStmt.setString(2, resourceRef.getComponentInstanceId());
            prepStmt.setString(3, objectType);
            prepStmt.setString(4, DateUtil.date2SQLDate((Date)startDate));
            prepStmt.setString(5, DateUtil.date2SQLDate((Date)endDate));
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                nb = rs.getInt(1);
            }
            n = nb;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return n;
    }

    public static Stream<Pair<ContributionIdentifier, Integer>> countByPeriodAndUser(Connection con, Collection<ContributionIdentifier> contributionIds, Date startDate, Date endDate, String userId) throws SQLException {
        Set ids = contributionIds.stream().map(ContributionIdentifier::getLocalId).collect(Collectors.toSet());
        Set instanceIds = contributionIds.stream().map(ContributionIdentifier::getComponentInstanceId).collect(Collectors.toSet());
        Set types = contributionIds.stream().map(ContributionIdentifier::getType).collect(Collectors.toSet());
        HashMap result = new HashMap(contributionIds.size());
        JdbcSqlQuery.executeBySplittingOn(ids, (idBatch, ignore) -> JdbcSqlQuery.executeBySplittingOn((Collection)instanceIds, (instanceIdBatch, ignoreToo) -> JdbcSqlQuery.executeBySplittingOn((Collection)types, (typeBatch, ignoreAlsoToo) -> JdbcSqlQuery.select((String)"resourceId, ComponentId, resourceType, count(*)").from(new String[]{HISTORY_TABLE_NAME}).where(RESOURCE_ID, new Object[0]).in(idBatch).and("ComponentId", new Object[0]).in(instanceIdBatch).and("resourceType", new Object[0]).in(typeBatch).and("datestat >= ?", new Object[]{DateUtil.date2SQLDate((Date)(startDate != null ? startDate : DateUtil.MINIMUM_DATE))}).and("datestat <= ?", new Object[]{DateUtil.date2SQLDate((Date)(endDate != null ? endDate : DateUtil.MAXIMUM_DATE))}).and("userid = ?", new Object[]{userId}).groupBy(new String[]{"resourceId, ComponentId, resourceType"}).executeWith(con, r -> {
            ContributionIdentifier cId = ContributionIdentifier.from((String)r.getString(2), (String)r.getString(1), (String)r.getString(3));
            result.put(cId, r.getInt(4));
            return null;
        }))));
        return contributionIds.stream().map(i -> Pair.of((Object)i, (Object)result.getOrDefault(i, 0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(Connection con, ResourceReference toResourceReference, int actionType, String objectType) throws SQLException {
        String insertStatement = "update SB_Statistic_History set componentId = ? where resourceId = ? and actionType = ? and resourceType = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, toResourceReference.getInstanceId());
            prepStmt.setString(2, toResourceReference.getId());
            prepStmt.setInt(3, actionType);
            prepStmt.setString(4, objectType);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static List<String> getListObjectAccessByPeriod(Connection con, List<ResourceReference> primaryKeys, String objectType, Date startDate, Date endDate) throws SQLException {
        return HistoryObjectDAO.getListObjectAccessByPeriodAndUser(con, primaryKeys, objectType, startDate, endDate, null);
    }

    public static List<String> getListObjectAccessByPeriodAndUser(Connection con, List<ResourceReference> primaryKeys, String objectType, Date startDate, Date endDate, String userId) throws SQLException {
        String instanceId = Optional.ofNullable(primaryKeys).flatMap(l -> l.stream().findFirst()).map(ResourceReference::getComponentInstanceId).orElse(null);
        List ids = Optional.ofNullable(primaryKeys).orElse(Collections.emptyList()).stream().map(ResourceReference::getLocalId).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>(ids.size());
        JdbcSqlQuery.executeBySplittingOn(ids, (idBatch, ignore) -> {
            JdbcSqlQuery sqlQuery = JdbcSqlQuery.select((String)RESOURCE_ID).from(new String[]{HISTORY_TABLE_NAME}).where("ComponentId = ?", new Object[]{instanceId}).and("resourceType = ?", new Object[]{objectType}).and(RESOURCE_ID, new Object[0]).in(idBatch).and("datestat >= ?", new Object[]{DateUtil.date2SQLDate((Date)startDate)}).and("datestat <= ?", new Object[]{DateUtil.date2SQLDate((Date)endDate)});
            if (StringUtil.isDefined((String)userId)) {
                sqlQuery.and("userId = ?", new Object[]{userId});
            }
            sqlQuery.executeWith(con, r -> {
                result.add(r.getString(1));
                return null;
            });
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<HistoryObjectDetail> getLastHistoryDetailOfObjectsForUser(Connection con, String userId, int actionType, String objectType, int nbObjects) throws SQLException {
        String selectStatement = "select componentId, resourceId, datestat, heurestat from SB_Statistic_History where userId='" + userId + "' and actionType=" + actionType + " and resourceType='" + objectType + "' order by datestat desc, heurestat desc";
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<HistoryObjectDetail> result = new ArrayList<HistoryObjectDetail>();
        HashSet<ResourceReference> performedIds = new HashSet<ResourceReference>(nbObjects * 2);
        try {
            stmt = con.createStatement();
            stmt.setFetchSize(50);
            rs = stmt.executeQuery(selectStatement);
            while (rs.next() && performedIds.size() < nbObjects) {
                Date date;
                String componentId = rs.getString(1);
                String foreignId = rs.getString(2);
                ResourceReference resourceReference = new ResourceReference(foreignId, componentId);
                if (!performedIds.add(resourceReference)) continue;
                try {
                    date = DateUtil.parse((String)rs.getString(3));
                    date = DateUtil.getDate((Date)date, (String)rs.getString(4));
                }
                catch (ParseException e) {
                    throw new StatisticRuntimeException(e);
                }
                result.add(new HistoryObjectDetail(date, userId, resourceReference));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return result;
    }
}

