/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sasl;

import com.novell.security.sasl.SaslClient;
import com.novell.security.sasl.SaslClientFactory;
import com.novell.security.sasl.SaslEnumFactory;
import com.novell.security.sasl.SaslException;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class Sasl {
    private static SaslClientFactory cFactory = null;
    public static final String CLIENTPKGS = "com.novell.security.sasl.client.pkgs";
    public static final String QOP = "com.novell.security.sasl.qop";
    public static final String STRENGTH = "com.novell.security.sasl.strength";
    public static final String SERVER_AUTH = "com.novell.security.sasl.server.authentication";
    public static final String MAX_BUFFER = "com.novell.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "com.novell.security.sasl.rawsendsize";
    public static final String POLICY_NOPLAINTEXT = "com.novell.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "com.novell.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "com.novell.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "com.novell.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "com.novell.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "com.novell.security.sasl.policy.credentials";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        SaslClient mclient = null;
        if (cFactory != null) {
            mclient = cFactory.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        }
        if (mclient == null) {
            Enumeration saslFactories = Sasl.getSaslClientFactories(props);
            while (mclient == null && saslFactories.hasMoreElements()) {
                SaslClientFactory factory = (SaslClientFactory)saslFactories.nextElement();
                mclient = factory.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
            }
        }
        return mclient;
    }

    public static Enumeration getSaslClientFactories(Map props) {
        return new SaslEnumFactory("SaslClientFactory", props, CLIENTPKGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSaslClientFactory(SaslClientFactory fac) {
        if (cFactory != null) {
            throw new IllegalStateException("SaslClientFactory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        SaslClientFactory saslClientFactory = cFactory;
        synchronized (saslClientFactory) {
            cFactory = fac;
        }
    }
}

