/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Choice;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.ASN1SetOf;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.rfc2251.RfcAssertionValue;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeValueAssertion;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcMatchingRuleAssertion;
import com.novell.ldap.rfc2251.RfcMatchingRuleId;
import com.novell.ldap.rfc2251.RfcSubstringFilter;
import com.novell.ldap.util.Base64;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;

public class RfcFilter
extends ASN1Choice {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EQUALITY_MATCH = 3;
    public static final int SUBSTRINGS = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int LESS_OR_EQUAL = 6;
    public static final int PRESENT = 7;
    public static final int APPROX_MATCH = 8;
    public static final int EXTENSIBLE_MATCH = 9;
    public static final int INITIAL = 0;
    public static final int ANY = 1;
    public static final int FINAL = 2;
    private FilterTokenizer ft;
    private Stack filterStack;
    private boolean finalFound;

    public RfcFilter(String filter) throws LDAPException {
        super((ASN1Object)null);
        this.setChoiceValue(this.parse(filter));
    }

    public RfcFilter() {
        super((ASN1Object)null);
        this.filterStack = new Stack();
    }

    private final ASN1Tagged parse(String filterExpr) throws LDAPException {
        int idx;
        if (filterExpr == null || filterExpr.equals("")) {
            filterExpr = new String("(objectclass=*)");
        }
        if ((idx = filterExpr.indexOf(92)) != -1) {
            StringBuffer sb = new StringBuffer(filterExpr);
            int i = idx;
            while (i < sb.length() - 1) {
                char c;
                if ((c = sb.charAt(i++)) != '\\' || (c = sb.charAt(i)) != '*' && c != '(' && c != ')' && c != '\\') continue;
                sb.delete(i, i + 1);
                sb.insert(i, Integer.toHexString(c));
                i += 2;
            }
            filterExpr = sb.toString();
        }
        if (filterExpr.charAt(0) != '(' && filterExpr.charAt(filterExpr.length() - 1) != ')') {
            filterExpr = "(" + filterExpr + ")";
        }
        char ch = filterExpr.charAt(0);
        int len = filterExpr.length();
        if (ch != '(') {
            throw new LDAPLocalException("MISSING_LEFT_PAREN", 87);
        }
        if (filterExpr.charAt(len - 1) != ')') {
            throw new LDAPLocalException("MISSING_RIGHT_PAREN", 87);
        }
        int parenCount = 0;
        for (int i = 0; i < len; ++i) {
            if (filterExpr.charAt(i) == '(') {
                ++parenCount;
            }
            if (filterExpr.charAt(i) != ')') continue;
            --parenCount;
        }
        if (parenCount > 0) {
            throw new LDAPLocalException("MISSING_RIGHT_PAREN", 87);
        }
        if (parenCount < 0) {
            throw new LDAPLocalException("MISSING_LEFT_PAREN", 87);
        }
        this.ft = new FilterTokenizer(filterExpr);
        return this.parseFilter();
    }

    private final ASN1Tagged parseFilter() throws LDAPException {
        this.ft.getLeftParen();
        ASN1Tagged filter = this.parseFilterComp();
        this.ft.getRightParen();
        return filter;
    }

    private final ASN1Tagged parseFilterComp() throws LDAPException {
        ASN1Tagged tag = null;
        int filterComp = this.ft.getOpOrAttr();
        block0 : switch (filterComp) {
            case 0: 
            case 1: {
                tag = new ASN1Tagged(new ASN1Identifier(2, true, filterComp), this.parseFilterList(), false);
                break;
            }
            case 2: {
                tag = new ASN1Tagged(new ASN1Identifier(2, true, filterComp), this.parseFilter(), true);
                break;
            }
            default: {
                int filterType = this.ft.getFilterType();
                String value = this.ft.getValue();
                switch (filterType) {
                    case 5: 
                    case 6: 
                    case 8: {
                        tag = new ASN1Tagged(new ASN1Identifier(2, true, filterType), new RfcAttributeValueAssertion(new RfcAttributeDescription(this.ft.getAttr()), new RfcAssertionValue(this.unescapeString(value))), false);
                        break block0;
                    }
                    case 3: {
                        if (value.equals("*")) {
                            tag = new ASN1Tagged(new ASN1Identifier(2, false, 7), new RfcAttributeDescription(this.ft.getAttr()), false);
                            break block0;
                        }
                        if (value.indexOf(42) != -1) {
                            StringTokenizer sub = new StringTokenizer(value, "*", true);
                            ASN1SequenceOf seq = new ASN1SequenceOf(5);
                            int tokCnt = sub.countTokens();
                            int cnt = 0;
                            String lastTok = new String("");
                            while (sub.hasMoreTokens()) {
                                String subTok = sub.nextToken();
                                ++cnt;
                                if (subTok.equals("*")) {
                                    if (lastTok.equals(subTok)) {
                                        seq.add(new ASN1Tagged(new ASN1Identifier(2, false, 1), new RfcLDAPString(this.unescapeString("")), false));
                                    }
                                } else if (cnt == 1) {
                                    seq.add(new ASN1Tagged(new ASN1Identifier(2, false, 0), new RfcLDAPString(this.unescapeString(subTok)), false));
                                } else if (cnt < tokCnt) {
                                    seq.add(new ASN1Tagged(new ASN1Identifier(2, false, 1), new RfcLDAPString(this.unescapeString(subTok)), false));
                                } else {
                                    seq.add(new ASN1Tagged(new ASN1Identifier(2, false, 2), new RfcLDAPString(this.unescapeString(subTok)), false));
                                }
                                lastTok = subTok;
                            }
                            tag = new ASN1Tagged(new ASN1Identifier(2, true, 4), new RfcSubstringFilter(new RfcAttributeDescription(this.ft.getAttr()), seq), false);
                            break block0;
                        }
                        tag = new ASN1Tagged(new ASN1Identifier(2, true, 3), new RfcAttributeValueAssertion(new RfcAttributeDescription(this.ft.getAttr()), new RfcAssertionValue(this.unescapeString(value))), false);
                        break block0;
                    }
                    case 9: {
                        String type = null;
                        String matchingRule = null;
                        boolean dnAttributes = false;
                        StringTokenizer st = new StringTokenizer(this.ft.getAttr(), ":", true);
                        boolean first = true;
                        while (st.hasMoreTokens()) {
                            String s = st.nextToken().trim();
                            if (first && !s.equals(":")) {
                                type = s;
                            } else if (s.equals("dn")) {
                                dnAttributes = true;
                            } else if (!s.equals(":")) {
                                matchingRule = s;
                            }
                            first = false;
                        }
                        tag = new ASN1Tagged(new ASN1Identifier(2, true, 9), new RfcMatchingRuleAssertion(matchingRule == null ? null : new RfcMatchingRuleId(matchingRule), type == null ? null : new RfcAttributeDescription(type), new RfcAssertionValue(this.unescapeString(value)), !dnAttributes ? null : new ASN1Boolean(true)), false);
                    }
                }
            }
        }
        return tag;
    }

    private final ASN1SetOf parseFilterList() throws LDAPException {
        ASN1SetOf set = new ASN1SetOf();
        set.add(this.parseFilter());
        while (this.ft.peekChar() == '(') {
            set.add(this.parseFilter());
        }
        return set;
    }

    static final int hex2int(char c) {
        return c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
    }

    private final byte[] unescapeString(String string) throws LDAPException {
        byte[] octets = new byte[string.length() * 3];
        boolean escape = false;
        boolean escStart = false;
        int length = string.length();
        char[] ca = new char[1];
        char temp = '\u0000';
        int iOctets = 0;
        for (int iString = 0; iString < length; ++iString) {
            char ch = string.charAt(iString);
            if (escape) {
                int ival = RfcFilter.hex2int(ch);
                if (ival < 0) {
                    throw new LDAPLocalException("INVALID_ESCAPE", new Object[]{new Character(ch)}, 87);
                }
                if (escStart) {
                    temp = (char)(ival << 4);
                    escStart = false;
                    continue;
                }
                temp = (char)(temp | (char)ival);
                octets[iOctets++] = (byte)temp;
                escape = false;
                escStart = false;
                continue;
            }
            if (ch == '\\') {
                escape = true;
                escStart = true;
                continue;
            }
            try {
                byte[] utf8Bytes;
                if (ch >= '\u0001' && ch <= '\'' || ch >= '+' && ch <= '[' || ch >= ']') {
                    if (ch <= '\u007f') {
                        octets[iOctets++] = (byte)ch;
                    } else {
                        ca[0] = ch;
                        utf8Bytes = new String(ca).getBytes("UTF-8");
                        System.arraycopy(utf8Bytes, 0, octets, iOctets, utf8Bytes.length);
                        iOctets += utf8Bytes.length;
                    }
                } else {
                    String escString = "";
                    ca[0] = ch;
                    utf8Bytes = new String(ca).getBytes("UTF-8");
                    for (int i = 0; i < utf8Bytes.length; ++i) {
                        byte u = utf8Bytes[i];
                        escString = u >= 0 && u < 16 ? escString + "\\0" + Integer.toHexString(u & 0xFF) : escString + "\\" + Integer.toHexString(u & 0xFF);
                    }
                    throw new LDAPLocalException("INVALID_CHAR_IN_FILTER", new Object[]{new Character(ch), escString}, 87);
                }
                escape = false;
                continue;
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException("UTF-8 String encoding not supported by JVM");
            }
        }
        if (escStart || escape) {
            throw new LDAPLocalException("SHORT_ESCAPE", 87);
        }
        byte[] toReturn = new byte[iOctets];
        System.arraycopy(octets, 0, toReturn, 0, iOctets);
        octets = null;
        return toReturn;
    }

    private void addObject(ASN1Object current) throws LDAPLocalException {
        if (this.filterStack == null) {
            this.filterStack = new Stack();
        }
        if (this.choiceValue() == null) {
            this.setChoiceValue(current);
        } else {
            ASN1Tagged topOfStack = (ASN1Tagged)this.filterStack.peek();
            ASN1Object value = topOfStack.taggedValue();
            if (value == null) {
                topOfStack.setTaggedValue(current);
                this.filterStack.add(current);
            } else if (value instanceof ASN1SetOf) {
                ((ASN1SetOf)value).add(current);
            } else if (value instanceof ASN1Set) {
                ((ASN1Set)value).add(current);
            } else if (value.getIdentifier().getTag() == 2) {
                throw new LDAPLocalException("Attemp to create more than one 'not' sub-filter", 87);
            }
        }
        int type = current.getIdentifier().getTag();
        if (type == 0 || type == 1 || type == 2) {
            this.filterStack.add(current);
        }
    }

    public void startSubstrings(String attrName) throws LDAPLocalException {
        this.finalFound = false;
        ASN1SequenceOf seq = new ASN1SequenceOf(5);
        ASN1Tagged current = new ASN1Tagged(new ASN1Identifier(2, true, 4), new RfcSubstringFilter(new RfcAttributeDescription(attrName), seq), false);
        this.addObject(current);
        this.filterStack.push(seq);
    }

    public void addSubstring(int type, byte[] value) throws LDAPLocalException {
        try {
            ASN1SequenceOf substringSeq = (ASN1SequenceOf)this.filterStack.peek();
            if (type != 0 && type != 1 && type != 2) {
                throw new LDAPLocalException("Attempt to add an invalid substring type", 87);
            }
            if (type == 0 && substringSeq.size() != 0) {
                throw new LDAPLocalException("Attempt to add an initial substring match after the first substring", 87);
            }
            if (this.finalFound) {
                throw new LDAPLocalException("Attempt to add a substring match after a final substring match", 87);
            }
            if (type == 2) {
                this.finalFound = true;
            }
            substringSeq.add(new ASN1Tagged(new ASN1Identifier(2, false, type), new RfcLDAPString(value), false));
        }
        catch (ClassCastException e) {
            throw new LDAPLocalException("A call to addSubstring occured without calling startSubstring", 87);
        }
    }

    public void endSubstrings() throws LDAPLocalException {
        try {
            this.finalFound = false;
            ASN1SequenceOf substringSeq = (ASN1SequenceOf)this.filterStack.peek();
            if (substringSeq.size() == 0) {
                throw new LDAPLocalException("Empty substring filter", 87);
            }
        }
        catch (ClassCastException e) {
            throw new LDAPLocalException("Missmatched ending of substrings", 87);
        }
        this.filterStack.pop();
    }

    public void addAttributeValueAssertion(int rfcType, String attrName, byte[] value) throws LDAPLocalException {
        if (this.filterStack != null && !this.filterStack.empty() && this.filterStack.peek() instanceof ASN1SequenceOf) {
            throw new LDAPLocalException("Cannot insert an attribute assertion in a substring", 87);
        }
        if (rfcType != 3 && rfcType != 5 && rfcType != 6 && rfcType != 8) {
            throw new LDAPLocalException("Invalid filter type for AttributeValueAssertion", 87);
        }
        ASN1Tagged current = new ASN1Tagged(new ASN1Identifier(2, true, rfcType), new RfcAttributeValueAssertion(new RfcAttributeDescription(attrName), new RfcAssertionValue(value)), false);
        this.addObject(current);
    }

    public void addPresent(String attrName) throws LDAPLocalException {
        ASN1Tagged current = new ASN1Tagged(new ASN1Identifier(2, false, 7), new RfcAttributeDescription(attrName), false);
        this.addObject(current);
    }

    public void addExtensibleMatch(String matchingRule, String attrName, byte[] value, boolean useDNMatching) throws LDAPLocalException {
        ASN1Tagged current = new ASN1Tagged(new ASN1Identifier(2, true, 9), new RfcMatchingRuleAssertion(matchingRule == null ? null : new RfcMatchingRuleId(matchingRule), attrName == null ? null : new RfcAttributeDescription(attrName), new RfcAssertionValue(value), !useDNMatching ? null : new ASN1Boolean(true)), false);
        this.addObject(current);
    }

    /*
     * WARNING - void declaration
     */
    public void startNestedFilter(int rfcType) throws LDAPLocalException {
        void var2_2;
        ASN1Tagged current;
        if (rfcType == 0 || rfcType == 1) {
            current = new ASN1Tagged(new ASN1Identifier(2, true, rfcType), new ASN1SetOf(), false);
        } else if (rfcType == 2) {
            current = new ASN1Tagged(new ASN1Identifier(2, true, rfcType), null, true);
        } else {
            throw new LDAPLocalException("Attempt to create a nested filter other than AND, OR or NOT", 87);
        }
        this.addObject((ASN1Object)var2_2);
    }

    public void endNestedFilter(int rfcType) throws LDAPLocalException {
        int topOfStackType;
        if (rfcType == 2) {
            this.filterStack.pop();
        }
        if ((topOfStackType = ((ASN1Object)this.filterStack.peek()).getIdentifier().getTag()) != rfcType) {
            throw new LDAPLocalException("Missmatched ending of nested filter", 87);
        }
        this.filterStack.pop();
    }

    public Iterator getFilterIterator() {
        return new FilterIterator((ASN1Tagged)this.choiceValue());
    }

    public String filterToString() {
        StringBuffer filter = new StringBuffer();
        RfcFilter.stringFilter(this.getFilterIterator(), filter);
        return filter.toString();
    }

    private static void stringFilter(Iterator itr, StringBuffer filter) {
        int op = -1;
        filter.append('(');
        while (itr.hasNext()) {
            Object filterpart = itr.next();
            if (filterpart instanceof Integer) {
                op = (Integer)filterpart;
                switch (op) {
                    case 0: {
                        filter.append('&');
                        break;
                    }
                    case 1: {
                        filter.append('|');
                        break;
                    }
                    case 2: {
                        filter.append('!');
                        break;
                    }
                    case 3: {
                        filter.append((String)itr.next());
                        filter.append('=');
                        byte[] value = (byte[])itr.next();
                        filter.append(RfcFilter.byteString(value));
                        break;
                    }
                    case 5: {
                        filter.append((String)itr.next());
                        filter.append(">=");
                        byte[] value = (byte[])itr.next();
                        filter.append(RfcFilter.byteString(value));
                        break;
                    }
                    case 6: {
                        filter.append((String)itr.next());
                        filter.append("<=");
                        byte[] value = (byte[])itr.next();
                        filter.append(RfcFilter.byteString(value));
                        break;
                    }
                    case 7: {
                        filter.append((String)itr.next());
                        filter.append("=*");
                        break;
                    }
                    case 8: {
                        filter.append((String)itr.next());
                        filter.append("~=");
                        byte[] value = (byte[])itr.next();
                        filter.append(RfcFilter.byteString(value));
                        break;
                    }
                    case 9: {
                        String oid = (String)itr.next();
                        filter.append((String)itr.next());
                        filter.append(':');
                        filter.append(oid);
                        filter.append(":=");
                        filter.append((String)itr.next());
                        break;
                    }
                    case 4: {
                        filter.append((String)itr.next());
                        filter.append('=');
                        boolean noStarLast = false;
                        while (itr.hasNext()) {
                            op = (Integer)itr.next();
                            switch (op) {
                                case 0: {
                                    filter.append((String)itr.next());
                                    filter.append('*');
                                    noStarLast = false;
                                    break;
                                }
                                case 1: {
                                    if (noStarLast) {
                                        filter.append('*');
                                    }
                                    filter.append((String)itr.next());
                                    filter.append('*');
                                    noStarLast = false;
                                    break;
                                }
                                case 2: {
                                    if (noStarLast) {
                                        filter.append('*');
                                    }
                                    filter.append((String)itr.next());
                                }
                            }
                        }
                        break;
                    }
                }
                continue;
            }
            if (!(filterpart instanceof Iterator)) continue;
            RfcFilter.stringFilter((Iterator)filterpart, filter);
        }
        filter.append(')');
    }

    private static String byteString(byte[] value) {
        String toReturn = null;
        if (Base64.isValidUTF8(value, true)) {
            try {
                toReturn = new String(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Default JVM does not support UTF-8 encoding" + e);
            }
        } else {
            StringBuffer binary = new StringBuffer();
            for (int i = 0; i < value.length; ++i) {
                if (value[i] >= 0) {
                    binary.append("\\0");
                    binary.append(Integer.toHexString(value[i]));
                    continue;
                }
                binary.append("\\" + Integer.toHexString(value[i]).substring(6));
            }
            toReturn = binary.toString();
        }
        return toReturn;
    }

    class FilterTokenizer
    implements Serializable {
        private String filter;
        private String attr;
        private int offset;
        private int filterLength;

        public FilterTokenizer(String filter) {
            this.filter = filter;
            this.offset = 0;
            this.filterLength = filter.length();
        }

        public final void getLeftParen() throws LDAPException {
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            if (this.filter.charAt(this.offset++) != '(') {
                throw new LDAPLocalException("EXPECTING_LEFT_PAREN", new Object[]{new Character(this.filter.charAt(--this.offset))}, 87);
            }
        }

        public final void getRightParen() throws LDAPException {
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            if (this.filter.charAt(this.offset++) != ')') {
                throw new LDAPLocalException("EXPECTING_RIGHT_PAREN", new Object[]{new Character(this.filter.charAt(this.offset - 1))}, 87);
            }
        }

        public final int getOpOrAttr() throws LDAPException {
            int ret;
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            char testChar = this.filter.charAt(this.offset);
            if (testChar == '&') {
                ++this.offset;
                ret = 0;
            } else if (testChar == '|') {
                ++this.offset;
                ret = 1;
            } else if (testChar == '!') {
                ++this.offset;
                ret = 2;
            } else {
                int index;
                if (this.filter.startsWith(":=", this.offset)) {
                    throw new LDAPLocalException("NO_MATCHING_RULE", 87);
                }
                if (this.filter.startsWith("::=", this.offset) || this.filter.startsWith(":::=", this.offset)) {
                    throw new LDAPLocalException("NO_DN_NOR_MATCHING_RULE", 87);
                }
                String delims = "=~<>()";
                StringBuffer sb = new StringBuffer();
                while (delims.indexOf(this.filter.charAt(this.offset)) == -1 && !this.filter.startsWith(":=", this.offset)) {
                    sb.append(this.filter.charAt(this.offset++));
                }
                this.attr = sb.toString().trim();
                if (this.attr.length() == 0 || this.attr.charAt(0) == ';') {
                    throw new LDAPLocalException("NO_ATTRIBUTE_NAME", 87);
                }
                for (index = 0; index < this.attr.length(); ++index) {
                    char atIndex = this.attr.charAt(index);
                    if (Character.isLetterOrDigit(atIndex) || atIndex == '-' || atIndex == '.' || atIndex == ';' || atIndex == ':') continue;
                    if (atIndex == '\\') {
                        throw new LDAPLocalException("INVALID_ESC_IN_DESCR", 87);
                    }
                    throw new LDAPLocalException("INVALID_CHAR_IN_DESCR", new Object[]{new Character(atIndex)}, 87);
                }
                index = this.attr.indexOf(59);
                if (index != -1 && index == this.attr.length() - 1) {
                    throw new LDAPLocalException("NO_OPTION", 87);
                }
                ret = -1;
            }
            return ret;
        }

        /*
         * WARNING - void declaration
         */
        public final int getFilterType() throws LDAPException {
            void var1_1;
            int ret;
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            if (this.filter.startsWith(">=", this.offset)) {
                this.offset += 2;
                ret = 5;
            } else if (this.filter.startsWith("<=", this.offset)) {
                this.offset += 2;
                ret = 6;
            } else if (this.filter.startsWith("~=", this.offset)) {
                this.offset += 2;
                ret = 8;
            } else if (this.filter.startsWith(":=", this.offset)) {
                this.offset += 2;
                ret = 9;
            } else if (this.filter.charAt(this.offset) == '=') {
                ++this.offset;
                ret = 3;
            } else {
                throw new LDAPLocalException("INVALID_FILTER_COMPARISON", 87);
            }
            return (int)var1_1;
        }

        public final String getValue() throws LDAPException {
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            int idx = this.filter.indexOf(41, this.offset);
            if (idx == -1) {
                idx = this.filterLength;
            }
            String ret = this.filter.substring(this.offset, idx);
            this.offset = idx;
            return ret;
        }

        public final String getAttr() {
            return this.attr;
        }

        public final char peekChar() throws LDAPException {
            if (this.offset >= this.filterLength) {
                throw new LDAPLocalException("UNEXPECTED_END", 87);
            }
            return this.filter.charAt(this.offset);
        }

        private void writeObject(ObjectOutputStream objectOStrm) throws IOException {
            objectOStrm.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectIStrm) throws IOException, ClassNotFoundException {
            objectIStrm.defaultReadObject();
        }
    }

    private class FilterIterator
    implements Iterator {
        ASN1Tagged root;
        boolean tagReturned = false;
        int index = -1;
        private boolean hasMore = true;

        public FilterIterator(ASN1Tagged root) {
            this.root = root;
        }

        public boolean hasNext() {
            return this.hasMore;
        }

        public Object next() {
            Object toReturn = null;
            if (!this.tagReturned) {
                this.tagReturned = true;
                toReturn = new Integer(this.root.getIdentifier().getTag());
            } else {
                ASN1Object asn1 = this.root.taggedValue();
                if (asn1 instanceof RfcLDAPString) {
                    this.hasMore = false;
                    toReturn = ((RfcLDAPString)asn1).stringValue();
                } else if (asn1 instanceof RfcSubstringFilter) {
                    RfcSubstringFilter sub = (RfcSubstringFilter)asn1;
                    if (this.index == -1) {
                        this.index = 0;
                        RfcAttributeDescription attr = (RfcAttributeDescription)sub.get(0);
                        toReturn = attr.stringValue();
                    } else if (this.index % 2 == 0) {
                        ASN1SequenceOf substrs = (ASN1SequenceOf)sub.get(1);
                        toReturn = new Integer(((ASN1Tagged)substrs.get(this.index / 2)).getIdentifier().getTag());
                        ++this.index;
                    } else {
                        ASN1SequenceOf substrs = (ASN1SequenceOf)sub.get(1);
                        ASN1Tagged tag = (ASN1Tagged)substrs.get(this.index / 2);
                        RfcLDAPString value = (RfcLDAPString)tag.taggedValue();
                        toReturn = value.stringValue();
                        ++this.index;
                    }
                    if (this.index / 2 >= ((ASN1SequenceOf)sub.get(1)).size()) {
                        this.hasMore = false;
                    }
                } else if (asn1 instanceof RfcAttributeValueAssertion) {
                    RfcAttributeValueAssertion assertion = (RfcAttributeValueAssertion)asn1;
                    if (this.index == -1) {
                        toReturn = assertion.getAttributeDescription();
                        this.index = 1;
                    } else if (this.index == 1) {
                        toReturn = assertion.getAssertionValue();
                        this.index = 2;
                        this.hasMore = false;
                    }
                } else if (asn1 instanceof RfcMatchingRuleAssertion) {
                    RfcMatchingRuleAssertion exMatch = (RfcMatchingRuleAssertion)asn1;
                    if (this.index == -1) {
                        this.index = 0;
                    }
                    toReturn = ((ASN1OctetString)((ASN1Tagged)exMatch.get(this.index++)).taggedValue()).stringValue();
                    if (this.index > 2) {
                        this.hasMore = false;
                    }
                } else if (asn1 instanceof ASN1SetOf) {
                    ASN1SetOf set = (ASN1SetOf)asn1;
                    if (this.index == -1) {
                        this.index = 0;
                    }
                    toReturn = new FilterIterator((ASN1Tagged)set.get(this.index++));
                    if (this.index >= set.size()) {
                        this.hasMore = false;
                    }
                } else if (asn1 instanceof ASN1Tagged) {
                    toReturn = new FilterIterator((ASN1Tagged)asn1);
                    this.hasMore = false;
                }
            }
            return toReturn;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported on a filter iterator");
        }
    }
}

