/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class LDAPDnsToX500DNResponse
extends LDAPExtendedResponse {
    private String namemappedDn;

    public LDAPDnsToX500DNResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        if (this.getID() == null || !this.getID().equals("2.16.840.1.113719.1.27.100.102")) {
            throw new IOException("LDAP Extended Operation not supported");
        }
        if (this.getResultCode() == 0) {
            byte[] returnedValue = this.getValue();
            if (returnedValue == null) {
                throw new IOException("LDAP Operations error. No returned value.");
            }
            LBERDecoder decoder = new LBERDecoder();
            if (decoder == null) {
                throw new IOException("Decoding error");
            }
            ByteArrayInputStream currentPtr = new ByteArrayInputStream(returnedValue);
            ASN1OctetString asn1_dn = (ASN1OctetString)decoder.decode(currentPtr);
            if (asn1_dn == null) {
                throw new IOException("Decoding error");
            }
            this.namemappedDn = asn1_dn.stringValue();
            if (this.namemappedDn == null) {
                throw new IOException("Decoding error");
            }
        } else {
            this.namemappedDn = "";
        }
    }

    public String getX500DN() {
        return this.namemappedDn;
    }
}

