/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ASN1Length {
    private int length;
    private int encodedLength;

    public ASN1Length() {
    }

    public ASN1Length(int length) {
        this.length = length;
    }

    public ASN1Length(InputStream in) throws IOException {
        int r = in.read();
        ++this.encodedLength;
        if (r == 128) {
            this.length = -1;
        } else if (r < 128) {
            this.length = r;
        } else {
            this.length = 0;
            r &= 0x7F;
            while (r > 0) {
                int part = in.read();
                ++this.encodedLength;
                if (part < 0) {
                    throw new EOFException("BERDecoder: decode: EOF in ASN1Length");
                }
                this.length = (this.length << 8) + part;
                --r;
            }
        }
    }

    public final void reset(InputStream in) throws IOException {
        this.encodedLength = 0;
        int r = in.read();
        ++this.encodedLength;
        if (r == 128) {
            this.length = -1;
        } else if (r < 128) {
            this.length = r;
        } else {
            this.length = 0;
            r &= 0x7F;
            while (r > 0) {
                int part = in.read();
                ++this.encodedLength;
                if (part < 0) {
                    throw new EOFException("BERDecoder: decode: EOF in ASN1Length");
                }
                this.length = (this.length << 8) + part;
                --r;
            }
        }
    }

    public final int getLength() {
        return this.length;
    }

    public final int getEncodedLength() {
        return this.encodedLength;
    }
}

