/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class LDAPExtendedOperation
implements Cloneable,
Externalizable {
    private String oid;
    private byte[] vals;

    public LDAPExtendedOperation() {
    }

    public LDAPExtendedOperation(String oid, byte[] vals) {
        this.oid = oid;
        this.vals = vals;
    }

    public Object clone() {
        try {
            Object newObj = super.clone();
            System.arraycopy(this.vals, 0, ((LDAPExtendedOperation)newObj).vals, 0, this.vals.length);
            return newObj;
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public String getID() {
        return this.oid;
    }

    public byte[] getValue() {
        return this.vals;
    }

    protected void setValue(byte[] newVals) {
        this.vals = newVals;
    }

    protected void setID(String newoid) {
        this.oid = newoid;
    }

    void newLine(int indentTabs, Writer out) throws IOException {
        String tabString = "    ";
        out.write("\n");
        for (int i = 0; i < indentTabs; ++i) {
            out.write(tabString);
        }
    }

    public void writeDSML(OutputStream oout) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(oout, "UTF-8");
        out.write("<LDAPExtendedOperation>");
        this.newLine(1, out);
        out.write("<requestName>");
        out.write(this.getID());
        out.write("</requestName>");
        byte[] vals = this.getValue();
        if (vals != null) {
            this.newLine(1, out);
            out.write("<requestValue xsi:type=\"xsd:base64Binary\">");
            out.write(Base64.encode(vals));
            out.write("</requestValue>");
        }
        this.newLine(0, out);
        out.write("</LDAPExtendedOperation>");
        ((Writer)out).close();
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPExtendedOperation.getXMLHandler("LDAPExtendedOperation", null));
        return (LDAPExtendedOperation)xmlreader.parseXML(input);
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String requestName;
            byte[] requestValue;

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler("requestName", this));
                this.setchildelement(new ValueXMLhandler("requestValue", this));
            }

            protected void endElement() {
                LDAPExtendedOperation op = new LDAPExtendedOperation(this.requestName, this.requestValue);
                this.setObject(op);
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("requestName")) {
                    this.requestName = new String((byte[])value);
                } else if (tag.equals("requestValue")) {
                    this.requestValue = (byte[])value;
                }
            }
        };
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LDAPExtendedOperation:");
        buf.append("((requestName=" + this.getID());
        buf.append("),(requestValue=" + this.getValue() + "))");
        return buf.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String header = "";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n";
        buff.append(header);
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("<LDAPExtendedOperation>");
        buff.append(ValueXMLhandler.newLine(1));
        buff.append("<requestName>");
        buff.append(this.getID());
        buff.append("</requestName>");
        byte[] vals = this.getValue();
        if (vals != null) {
            buff.append(ValueXMLhandler.newLine(1));
            buff.append("<requestValue xsi:type=\"xsd:base64Binary\">");
            buff.append(Base64.encode(vals));
            buff.append("</requestValue>");
        }
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("</LDAPExtendedOperation>");
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String tail = "";
        tail = tail + "*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        buff.append(tail);
        buff.append(ValueXMLhandler.newLine(0));
        out.writeUTF(buff.toString());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String readData = in.readUTF();
        String readProperties = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readProperties, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        LDAPExtendedOperation readObject = (LDAPExtendedOperation)LDAPExtendedOperation.readDSML(istream);
        this.oid = readObject.getID();
        this.vals = readObject.getValue();
        readObject = null;
    }
}

