/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.tree.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.pdc.tree.model.TreeNode;
import org.silverpeas.core.pdc.tree.model.TreeNodePK;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class TreeDAO {
    private static String TreeTable = "SB_Tree_Tree";

    protected TreeDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createRoot(Connection con, TreeNode root) throws SQLException {
        int newTreeId = DBUtil.getNextId((String)TreeTable, (String)"treeId");
        String insertQuery = "INSERT INTO SB_Tree_Tree VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ?, ? )";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertQuery);
            prepStmt.setInt(1, newTreeId);
            prepStmt.setInt(2, 0);
            prepStmt.setString(3, root.getName());
            prepStmt.setString(4, root.getDescription());
            prepStmt.setString(5, root.getCreationDate());
            prepStmt.setInt(6, Integer.parseInt(root.getCreatorId()));
            prepStmt.setString(7, "/");
            prepStmt.setInt(8, 0);
            prepStmt.setInt(9, -1);
            prepStmt.setInt(10, 0);
            prepStmt.setString(11, root.getLanguage());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return Integer.toString(newTreeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeNodePK createNode(Connection con, TreeNode node) throws SQLException {
        int newNodeId = 0;
        try {
            newNodeId = TreeDAO.getNextValueIdToTree(con, node.getTreeId());
        }
        catch (Exception e) {
            throw new SQLException("DBUtil.getNextValueIdToTree() failed !");
        }
        String insertQuery = "INSERT INTO SB_Tree_Tree VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertQuery);
            prepStmt.setInt(1, Integer.parseInt(node.getTreeId()));
            prepStmt.setInt(2, newNodeId);
            prepStmt.setString(3, node.getName());
            prepStmt.setString(4, node.getDescription());
            prepStmt.setString(5, node.getCreationDate());
            prepStmt.setInt(6, Integer.parseInt(node.getCreatorId()));
            prepStmt.setString(7, node.getPath());
            prepStmt.setInt(8, node.getLevelNumber());
            prepStmt.setInt(9, Integer.parseInt(node.getFatherId()));
            prepStmt.setInt(10, node.getOrderNumber());
            prepStmt.setString(11, node.getLanguage());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return new TreeNodePK(Integer.toString(newNodeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateNode(Connection con, TreeNode node) throws SQLException {
        String updateQuery = "UPDATE SB_Tree_Tree SET name = ? , description = ? , path = ? , levelNumber = ? , fatherId = ? , orderNumber = ? , lang = ? WHERE treeId = ? AND id = ? ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateQuery);
            prepStmt.setString(1, node.getName());
            prepStmt.setString(2, node.getDescription());
            prepStmt.setString(3, node.getPath());
            prepStmt.setInt(4, node.getLevelNumber());
            prepStmt.setInt(5, Integer.parseInt(node.getFatherId()));
            prepStmt.setInt(6, node.getOrderNumber());
            prepStmt.setString(7, node.getLanguage());
            prepStmt.setInt(8, Integer.parseInt(node.getTreeId()));
            prepStmt.setInt(9, Integer.parseInt(node.getPK().getId()));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteNode(Connection con, TreeNodePK treeNodePK, String treeId) throws SQLException {
        String deleteQuery = "DELETE FROM SB_Tree_Tree WHERE treeId= ? AND id = ?";
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(deleteQuery);
            stmt.setInt(1, Integer.parseInt(treeId));
            stmt.setInt(2, Integer.parseInt(treeNodePK.getId()));
            stmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void levelUp(Connection con, String path, String treeId) throws SQLException {
        String updateStatement = "update " + TreeTable + " set levelNumber = levelNumber - 1 where treeId = " + treeId + " and path like '" + path + "%' ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateStatement);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void levelDown(Connection con, String path, String treeId) throws SQLException {
        String updateStatement = "update " + TreeTable + " set levelNumber = levelNumber - 1 where treeId = " + treeId + " and path like '" + path + "%' ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateStatement);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeFatherAndPath(Connection con, int oldFather, int newFather, String path, String treeId) throws SQLException {
        String updateStatement = "update " + TreeTable + " set fatherId = ?, path = ? where treeId = " + treeId + " and fatherId = ? ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateStatement);
            prepStmt.setInt(1, newFather);
            prepStmt.setString(2, path);
            prepStmt.setInt(3, oldFather);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void updatePath(Connection con, String oldFather, String treeId) throws SQLException {
        List<String> pathes = TreeDAO.getPathes(con, oldFather, treeId);
        String oldPath = "";
        Object newPath = "";
        String pattern = "/" + oldFather;
        int lenOfPattern = pattern.length();
        while (!pathes.isEmpty()) {
            oldPath = pathes.remove(0);
            int pattern_idx = oldPath.indexOf(pattern);
            newPath = oldPath.substring(0, pattern_idx) + oldPath.substring(pattern_idx + lenOfPattern);
            TreeDAO.updatePath(con, oldPath, (String)newPath, treeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePath(Connection con, String oldPath, String newPath, String treeId) throws SQLException {
        String updateQuery = " update " + TreeTable + " set path = ? where treeId = " + treeId + " and path = ? ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateQuery);
            prepStmt.setString(1, newPath);
            prepStmt.setString(2, oldPath);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPathes(Connection con, String oldFather, String treeId) throws SQLException {
        String selectQuery = " select path from " + TreeTable + " where treeId = " + treeId + " and path like '%/" + oldFather + "/%'";
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> pathes = new ArrayList<String>();
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(selectQuery);
            while (rs.next()) {
                pathes.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return pathes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized int getNextValueIdToTree(Connection con, String treeId) throws SQLException {
        String selectQuery = " select max(id) from " + TreeTable + " where treeId = " + treeId;
        Statement stmt = null;
        ResultSet rs = null;
        int nextValueId = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(selectQuery);
            if (rs.next()) {
                nextValueId = rs.getInt(1);
                ++nextValueId;
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return nextValueId;
    }
}

