/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.subscription.service;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.pdc.classification.Value;
import org.silverpeas.core.pdc.subscription.model.PdcSubscription;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionService;
import org.silverpeas.core.util.ServiceProvider;

@Service
public class PdcSubscriptionManager {
    @Inject
    private PdcSubscriptionService pdcSubscriptionService;

    public static PdcSubscriptionManager getInstance() {
        return (PdcSubscriptionManager)ServiceProvider.getService(PdcSubscriptionManager.class, (Annotation[])new Annotation[0]);
    }

    protected PdcSubscriptionManager() {
    }

    public PdcSubscription getPDCSubsriptionById(int id) {
        return this.pdcSubscriptionService.getPDCSubsriptionById(id);
    }

    public void createPDCSubsription(PdcSubscription subscription) {
        this.pdcSubscriptionService.createPDCSubscription(subscription);
    }

    public void checkSubscriptions(List<? extends Value> classifyValues, String componentId, int silverObjectId) {
        this.pdcSubscriptionService.checkSubscriptions(classifyValues, componentId, silverObjectId);
    }

    public void checkAxisOnDelete(int axisId, String axisName) {
        this.pdcSubscriptionService.checkAxisOnDelete(axisId, axisName);
    }

    public void checkValueOnDelete(int axiId, String axisName, List<String> oldPath, List<String> newPath, List<org.silverpeas.core.pdc.pdc.model.Value> pathInfo) {
        this.pdcSubscriptionService.checkValueOnDelete(axiId, axisName, oldPath, newPath, pathInfo);
    }
}

