/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.subscription.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.notification.user.builder.AbstractResourceUserNotificationBuilder;
import org.silverpeas.core.pdc.subscription.model.PdcSubscription;
import org.silverpeas.core.personalization.service.PersonalizationServiceProvider;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractPdcSubscriptionUserNotification<T>
extends AbstractResourceUserNotificationBuilder<T> {
    private final PdcSubscription pdcSubscription;
    private final Map<Integer, String> userLanguages = new HashMap<Integer, String>();

    public AbstractPdcSubscriptionUserNotification(PdcSubscription pdcSubscription, T resource) {
        super(resource);
        this.pdcSubscription = pdcSubscription;
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.pdcSubscription.multilang.pdcsubscription";
    }

    protected Collection<String> getUserIdsToNotify() {
        return Collections.singletonList(String.valueOf(this.pdcSubscription.getOwnerId()));
    }

    protected String getUserLanguage(int userID) {
        String userLanguage = this.userLanguages.get(userID);
        if (StringUtil.isNotDefined((String)userLanguage)) {
            userLanguage = PersonalizationServiceProvider.getPersonalizationService().getUserSettings(String.valueOf(userID)).getLanguage();
            this.userLanguages.put(userID, userLanguage);
        }
        return userLanguage;
    }

    public PdcSubscription getPdcSubscription() {
        return this.pdcSubscription;
    }
}

