/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.classification;

import java.util.List;
import org.silverpeas.core.pdc.classification.Criteria;
import org.silverpeas.core.pdc.classification.Position;
import org.silverpeas.core.pdc.classification.Value;
import org.silverpeas.core.util.JoinStatement;
import org.silverpeas.kernel.util.StringUtil;

class SQLStatement {
    private static final String INSTANCES_TABLE = "SB_ContentManager_Instance";
    private static final String CLASSIFICATION_TABLE = "SB_ClassifyEngine_Classify";
    private static final String POSITION_ID_COLUMN = "PositionId";
    private static final String SILVEROBJECT_ID_COLUMN = "ObjectId";
    private static final String AXIS_COLUMN = "Axis";
    private static final int AXIS_MAX_NUMBER = 49;
    private static final String SELECT = "SELECT ";
    private static final String FROM = " FROM ";
    private static final String AND = " AND ";
    private static final String WHERE = " WHERE ";
    private static final String UPDATE = "UPDATE ";
    private static final String SET = " SET ";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String AND_CEC = " AND CEC.";
    private static final String CMI_COMPONENT_ID_IN = "CMI.componentId IN ('";
    private static final String LIKE = " LIKE '";
    private static final String AND_BLOCK_BEGIN = " AND ('";
    private static final String BETWEEN_CMC_BEGIN_DATE_AND_CMC_END_DATE = "' between CMC.beginDate AND CMC.endDate)";
    private static final String AND_CMC_IS_VISIBLE = " AND (CMC.isVisible = 1 )";
    private static final String GROUP_BY_CEC = " GROUP BY CEC.";
    private static final String IS_NULL = " IS NULL)";
    private static final String AND_BLOCK_CEC = " AND (CEC.";
    private static final String IS_NOT_NULL = " IS NOT NULL)";
    private static final String CEC = " CEC, ";
    private static final String EQUAL_CMC_SILVER_CONTENT_ID = " = CMC.silverContentId ";

    SQLStatement() {
    }

    public String buildLoadRegisteredAxisStatement() {
        return "SELECT * FROM SB_ClassifyEngine_Classify WHERE (PositionId = -1)";
    }

    public String buildRegisterAxisStatement(int nNextAvailableAxis, int nLogicalAxisId) {
        return "UPDATE SB_ClassifyEngine_Classify SET Axis" + nNextAvailableAxis + " = " + nLogicalAxisId + " WHERE (PositionId = -1)";
    }

    public String buildUnregisterAxisStatement(int nAxisId) {
        return "UPDATE SB_ClassifyEngine_Classify SET Axis" + nAxisId + " = -1 WHERE PositionId = -1";
    }

    public <T extends Value> String buildClassifyStatement(int nSilverObjectId, Position<T> position, int nNextPositionId) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        List<T> alValues = position.getValues();
        sSQLStatement.append("INSERT INTO ").append(CLASSIFICATION_TABLE).append(" (").append(POSITION_ID_COLUMN).append(", ").append(SILVEROBJECT_ID_COLUMN).append(", ");
        SQLStatement.setClassificationPositions(nSilverObjectId, nNextPositionId, sSQLStatement, alValues);
        return sSQLStatement.toString();
    }

    private static <T extends Value> void setClassificationPositions(int nSilverObjectId, int nNextPositionId, StringBuilder sSQLStatement, List<T> alValues) {
        for (int nI = 0; nI < alValues.size(); ++nI) {
            sSQLStatement.append(AXIS_COLUMN).append(((Value)alValues.get(nI)).getPhysicalAxisId());
            if (nI < alValues.size() - 1) {
                sSQLStatement.append(", ");
                continue;
            }
            sSQLStatement.append(") ");
        }
        sSQLStatement.append("VALUES(").append(nNextPositionId).append(", ").append(nSilverObjectId).append(", ");
        if (alValues.get(0) != null) {
            sSQLStatement.append("'");
        }
        SQLStatement.setPositionValues(sSQLStatement, alValues);
    }

    private static <T extends Value> void setPositionValues(StringBuilder sSQLStatement, List<T> alValues) {
        for (int nI = 0; nI < alValues.size(); ++nI) {
            sSQLStatement.append(((Value)alValues.get(nI)).getValue());
            if (nI < alValues.size() - 1) {
                if (((Value)alValues.get(nI)).getValue() == null) {
                    if (((Value)alValues.get(nI + 1)).getValue() != null) {
                        sSQLStatement.append(", '");
                        continue;
                    }
                    sSQLStatement.append(", ");
                    continue;
                }
                if (((Value)alValues.get(nI + 1)).getValue() != null) {
                    sSQLStatement.append("', '");
                    continue;
                }
                sSQLStatement.append("', ");
                continue;
            }
            if (((Value)alValues.get(nI)).getValue() == null) {
                sSQLStatement.append(") ");
                continue;
            }
            sSQLStatement.append("') ");
        }
    }

    public <T extends Value> String buildVerifyStatement(int nSilverObjectId, Position<T> position) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        List<T> alValues = position.getValues();
        sSQLStatement.append(SELECT).append(POSITION_ID_COLUMN).append(FROM).append(CLASSIFICATION_TABLE);
        sSQLStatement.append(WHERE).append("(");
        for (int axis = 0; axis <= 49; ++axis) {
            Value foundValue = null;
            for (Value aValue : alValues) {
                if (aValue.getPhysicalAxisId() != axis) continue;
                foundValue = aValue;
                break;
            }
            String axisValue = null;
            if (foundValue != null) {
                axisValue = "'" + foundValue.getValue() + "'";
            }
            sSQLStatement.append(AXIS_COLUMN).append(axis).append(" = ").append(axisValue);
            if (axis >= 49) continue;
            sSQLStatement.append(AND);
        }
        sSQLStatement.append(")");
        sSQLStatement.append(AND).append(SILVEROBJECT_ID_COLUMN).append(" = ").append(nSilverObjectId);
        return sSQLStatement.toString();
    }

    public String buildRemoveSilverObjectStatement(int nSilverObjectId) {
        return "DELETE FROM SB_ClassifyEngine_Classify WHERE (ObjectId=" + nSilverObjectId + ")";
    }

    public String buildRemoveByPositionIdStatement(int nPositionId) {
        return "DELETE FROM SB_ClassifyEngine_Classify WHERE (PositionId=" + nPositionId + ")";
    }

    public <T extends Value> String buildUpdateByPositionIdStatement(Position<T> newPosition) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        sSQLStatement.append(UPDATE).append(CLASSIFICATION_TABLE).append(SET).append(POSITION_ID_COLUMN).append(" = ").append(newPosition.getPositionId()).append(", ");
        List<T> allValues = newPosition.getValues();
        int valuesTakenInCharge = 0;
        SQLStatement.setNewAxisPositionValues(sSQLStatement, allValues, valuesTakenInCharge);
        sSQLStatement.append(WHERE).append(POSITION_ID_COLUMN).append(" = ").append(newPosition.getPositionId());
        return sSQLStatement.toString();
    }

    private static <T extends Value> void setNewAxisPositionValues(StringBuilder sSQLStatement, List<T> allValues, int valuesTakenInCharge) {
        for (int axisId = 0; axisId < 49; ++axisId) {
            String value = null;
            if (valuesTakenInCharge >= allValues.size()) continue;
            for (Value aValue : allValues) {
                if (aValue.getPhysicalAxisId() != axisId) continue;
                value = aValue.getValue();
                ++valuesTakenInCharge;
                break;
            }
            sSQLStatement.append(AXIS_COLUMN).append(axisId);
            if (value == null || value.equals("-")) {
                sSQLStatement.append(" = ").append(value);
            } else {
                sSQLStatement.append(" = '").append(value).append("'");
            }
            if (axisId >= 48) continue;
            sSQLStatement.append(", ");
        }
    }

    public String buildUpdateByObjectIdStatement(Value value, int nSilverObjectId) {
        Object sSQLStatement = "UPDATE SB_ClassifyEngine_Classify";
        sSQLStatement = (String)sSQLStatement + " SET Axis" + value.getAxisId() + " = '" + value.getValue() + "' ";
        sSQLStatement = (String)sSQLStatement + " WHERE ObjectId =  " + nSilverObjectId;
        sSQLStatement = (String)sSQLStatement + " AND Axis" + value.getAxisId() + " IS NOT NULL";
        return sSQLStatement;
    }

    public String buildFindByCriteriasStatementByJoin(List<Criteria> alCriterias, List<String> instanceIds, JoinStatement joinStatementContent, String todayFormatted, boolean recursiveSearch, boolean visibilitySensitive) {
        String whereClause;
        StringBuilder sSQLStatement = new StringBuilder(1000);
        String contentMgr = joinStatementContent.getTable(0);
        String contentMgrKey = joinStatementContent.getJoinKey(0);
        sSQLStatement.append(" SELECT CEC.").append(SILVEROBJECT_ID_COLUMN).append(FROM).append(CLASSIFICATION_TABLE).append(" CEC,").append(INSTANCES_TABLE).append(" CMI,").append(contentMgr).append(" CMC");
        sSQLStatement.append(WHERE);
        sSQLStatement.append(" CMC.contentInstanceId = CMI.instanceId");
        sSQLStatement.append(AND_CEC).append(SILVEROBJECT_ID_COLUMN).append(" = CMC.").append(contentMgrKey);
        if (!instanceIds.isEmpty()) {
            sSQLStatement.append(AND).append(CMI_COMPONENT_ID_IN);
            sSQLStatement.append(String.join((CharSequence)"','", instanceIds));
            sSQLStatement.append("')");
        }
        if (StringUtil.isDefined((String)(whereClause = joinStatementContent.getWhere()))) {
            sSQLStatement.append(AND).append(whereClause);
        }
        for (Criteria alCriteria : alCriterias) {
            if (alCriteria.getValue() == null) continue;
            sSQLStatement.append(" AND (").append(AXIS_COLUMN).append(alCriteria.getAxisId());
            if (recursiveSearch) {
                sSQLStatement.append(LIKE);
            } else {
                sSQLStatement.append(" = '");
            }
            sSQLStatement.append(alCriteria.getValue());
            if (recursiveSearch) {
                sSQLStatement.append("%')");
                continue;
            }
            sSQLStatement.append("')");
        }
        sSQLStatement.append(AND_BLOCK_BEGIN).append(todayFormatted).append(BETWEEN_CMC_BEGIN_DATE_AND_CMC_END_DATE);
        if (visibilitySensitive) {
            sSQLStatement.append(AND_CMC_IS_VISIBLE);
        }
        sSQLStatement.append(GROUP_BY_CEC).append(SILVEROBJECT_ID_COLUMN);
        return sSQLStatement.toString();
    }

    public String buildFindBySilverObjectIdStatement(int nSilverObjectId) {
        return "SELECT * FROM SB_ClassifyEngine_Classify WHERE (ObjectId=" + nSilverObjectId + ")";
    }

    public String buildRemoveAllPositionValuesStatement(int nAxisId) {
        return "UPDATE SB_ClassifyEngine_Classify SET Axis" + nAxisId + " = null WHERE NOT PositionId = -1";
    }

    public String buildGetEmptyPositionsStatement(int nbMaxAxis) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        sSQLStatement.append(SELECT).append(POSITION_ID_COLUMN).append(FROM).append(CLASSIFICATION_TABLE).append(WHERE);
        return this.setAxisPositionAsNull(sSQLStatement, nbMaxAxis);
    }

    private String setAxisPositionAsNull(StringBuilder sSQLStatement, int nbMaxAxis) {
        for (int nI = 0; nI < nbMaxAxis; ++nI) {
            sSQLStatement.append("(").append(AXIS_COLUMN).append(nI).append(IS_NULL);
            if (nI >= nbMaxAxis - 1) continue;
            sSQLStatement.append(AND);
        }
        return sSQLStatement.toString();
    }

    public String buildRemoveEmptyPositionsStatement(int nbMaxAxis) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        sSQLStatement.append(DELETE_FROM).append(CLASSIFICATION_TABLE).append(WHERE);
        return this.setAxisPositionAsNull(sSQLStatement, nbMaxAxis);
    }

    public String buildReplaceValuesStatement(Value oldValue, Value newValue) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        if (newValue.getValue() != null) {
            sSQLStatement.append(UPDATE).append(CLASSIFICATION_TABLE).append(SET).append(AXIS_COLUMN).append(newValue.getAxisId()).append(" = '").append(newValue.getValue()).append("'");
        } else {
            sSQLStatement.append(UPDATE).append(CLASSIFICATION_TABLE).append(SET).append(AXIS_COLUMN).append(newValue.getAxisId()).append(" = ").append(newValue.getValue());
        }
        if (oldValue.getValue() != null) {
            sSQLStatement.append(WHERE).append("(").append(AXIS_COLUMN).append(oldValue.getAxisId()).append(" = '").append(oldValue.getValue()).append("')");
        } else {
            sSQLStatement.append(WHERE).append("(").append(AXIS_COLUMN).append(oldValue.getAxisId()).append(IS_NULL);
        }
        return sSQLStatement.toString();
    }

    public String buildGetPertinentAxisStatementByJoin(List<? extends Criteria> alCriterias, int nAxisId, String sRootValue, List<String> instanceIds, String todayFormatted) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        sSQLStatement.append("SELECT COUNT(DISTINCT CEC.").append(SILVEROBJECT_ID_COLUMN).append(")");
        sSQLStatement.append(FROM).append(CLASSIFICATION_TABLE).append(CEC).append(INSTANCES_TABLE).append(" CMI, SB_ContentManager_Content CMC ");
        sSQLStatement.append(" WHERE CMC.contentInstanceId").append(" = CMI.instanceId");
        sSQLStatement.append(AND_CEC).append(SILVEROBJECT_ID_COLUMN).append(EQUAL_CMC_SILVER_CONTENT_ID);
        if (!instanceIds.isEmpty()) {
            sSQLStatement.append(AND).append(CMI_COMPONENT_ID_IN);
            sSQLStatement.append(String.join((CharSequence)"','", instanceIds));
            sSQLStatement.append("')");
        }
        if (alCriterias != null) {
            for (Criteria criteria : alCriterias) {
                if (criteria.getValue() == null) continue;
                sSQLStatement.append(AND_BLOCK_CEC).append(AXIS_COLUMN).append(criteria.getAxisId()).append(LIKE).append(criteria.getValue()).append("%')");
            }
        }
        sSQLStatement.append(AND_BLOCK_BEGIN).append(todayFormatted).append(BETWEEN_CMC_BEGIN_DATE_AND_CMC_END_DATE).append(AND_CMC_IS_VISIBLE);
        if (sRootValue.length() == 0) {
            sSQLStatement.append(AND_BLOCK_CEC).append(AXIS_COLUMN).append(nAxisId).append(IS_NOT_NULL);
        } else {
            sSQLStatement.append(AND_BLOCK_CEC).append(AXIS_COLUMN).append(nAxisId).append(LIKE).append(sRootValue).append("%')");
        }
        return sSQLStatement.toString();
    }

    public String buildGetPertinentValueByJoinStatement(List<Criteria> alCriterias, int nAxisId, List<String> instanceIds, String todayFormatted) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        sSQLStatement.append("SELECT COUNT(DISTINCT CEC.").append(SILVEROBJECT_ID_COLUMN).append("), CEC.").append(AXIS_COLUMN).append(nAxisId);
        sSQLStatement.append(FROM).append(CLASSIFICATION_TABLE).append(CEC).append(INSTANCES_TABLE).append(" CMI, SB_ContentManager_Content CMC ");
        sSQLStatement.append(" WHERE CMC.contentInstanceId").append(" = CMI.instanceId");
        sSQLStatement.append(AND_CEC).append(SILVEROBJECT_ID_COLUMN).append(EQUAL_CMC_SILVER_CONTENT_ID);
        SQLStatement.completeStatement(sSQLStatement, instanceIds, alCriterias, nAxisId, todayFormatted, true);
        sSQLStatement.append(GROUP_BY_CEC).append(AXIS_COLUMN).append(nAxisId);
        return sSQLStatement.toString();
    }

    public String buildGetObjectValuePairsByJoinStatement(List<Criteria> alCriterias, int nAxisId, List<String> instanceIds, String todayFormatted, boolean visibilitySensitive) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        sSQLStatement.append("SELECT CMC.internalContentId").append(", CEC.").append(AXIS_COLUMN).append(nAxisId).append(", CMI.componentId");
        sSQLStatement.append(FROM).append(CLASSIFICATION_TABLE).append(CEC).append(" SB_ContentManager_Content CMC, SB_ContentManager_Instance CMI ");
        sSQLStatement.append(" WHERE CEC.").append(SILVEROBJECT_ID_COLUMN).append(EQUAL_CMC_SILVER_CONTENT_ID);
        sSQLStatement.append(" AND CMC.contentInstanceId").append(" = CMI.instanceId ");
        SQLStatement.completeStatement(sSQLStatement, instanceIds, alCriterias, nAxisId, todayFormatted, visibilitySensitive);
        return sSQLStatement.toString();
    }

    private static void completeStatement(StringBuilder sSQLStatement, List<String> instanceIds, List<Criteria> alCriterias, int nAxisId, String todayFormatted, boolean visibilitySensitive) {
        if (!instanceIds.isEmpty()) {
            sSQLStatement.append(AND).append(CMI_COMPONENT_ID_IN);
            sSQLStatement.append(String.join((CharSequence)"','", instanceIds));
            sSQLStatement.append("')");
        }
        for (Criteria criteria : alCriterias) {
            if (criteria.getValue() == null) continue;
            sSQLStatement.append(AND_BLOCK_CEC).append(AXIS_COLUMN).append(criteria.getAxisId()).append(LIKE).append(criteria.getValue()).append("%')");
        }
        sSQLStatement.append(AND_BLOCK_CEC).append(AXIS_COLUMN).append(nAxisId).append(IS_NOT_NULL);
        sSQLStatement.append(AND_BLOCK_BEGIN).append(todayFormatted).append(BETWEEN_CMC_BEGIN_DATE_AND_CMC_END_DATE);
        if (visibilitySensitive) {
            sSQLStatement.append(AND_CMC_IS_VISIBLE);
        }
    }
}

