/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.classification;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentPostUpdate;
import org.silverpeas.core.pdc.classification.ClassifyEngineException;
import org.silverpeas.core.pdc.classification.Criteria;
import org.silverpeas.core.pdc.classification.ObjectValuePair;
import org.silverpeas.core.pdc.classification.PertinentAxis;
import org.silverpeas.core.pdc.classification.PertinentValue;
import org.silverpeas.core.pdc.classification.Position;
import org.silverpeas.core.pdc.classification.SQLStatement;
import org.silverpeas.core.pdc.classification.Value;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.JoinStatement;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
@Transactional
public class ClassifyEngine
implements SilverContentPostUpdate {
    private int nbMaxAxis = 0;
    private SQLStatement sqlStatement = new SQLStatement();
    private int[] registeredAxis = null;
    private Map<String, PertinentAxis> singlePertinentAxis = new ConcurrentHashMap<String, PertinentAxis>(0);

    private static ClassifyEngine getInstance() {
        return (ClassifyEngine)ServiceProvider.getService(ClassifyEngine.class, (Annotation[])new Annotation[0]);
    }

    @PostConstruct
    protected void init() {
        SettingBundle res = ResourceLocator.getSettingBundle((String)"org.silverpeas.classifyEngine.ClassifyEngine");
        String sMaxAxis = res.getString("MaxAxis");
        this.nbMaxAxis = Integer.parseInt(sMaxAxis);
        try {
            this.registeredAxis = this.loadRegisteredAxis();
        }
        catch (ClassifyEngineException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
    }

    public static int getMaxAxis() {
        return ClassifyEngine.getInstance().nbMaxAxis;
    }

    protected ClassifyEngine() {
    }

    public void postSilverpeasContentUpdate(int silverContentId) {
        ClassifyEngine.clearCache();
    }

    private static void clearCache() {
        ClassifyEngine.getInstance().singlePertinentAxis.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerAxis(Connection connection, int nLogicalAxisId) throws ClassifyEngineException {
        PreparedStatement prepStmt = null;
        if (this.isAxisAlreadyRegistered(nLogicalAxisId)) {
            throw new ClassifyEngineException("Axis already registered. nLogicalAxisId: " + nLogicalAxisId, new String[0]);
        }
        try {
            int[] nArray = this.registeredAxis;
            synchronized (this.registeredAxis) {
                int nNextAvailableAxis = this.getNextUnregisteredAxis();
                if (nNextAvailableAxis == -1) {
                    throw new ClassifyEngineException("No more available axis. nLogicalAxisId: " + nLogicalAxisId, new String[0]);
                }
                String sSQLStatement = this.sqlStatement.buildRegisterAxisStatement(nNextAvailableAxis, nLogicalAxisId);
                prepStmt = connection.prepareStatement(sSQLStatement);
                prepStmt.executeUpdate();
                this.registeredAxis[nNextAvailableAxis] = nLogicalAxisId;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                this.singlePertinentAxis.clear();
            }
        }
        catch (Exception e) {
            try {
                throw new ClassifyEngineException(e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
        }
        {
            DBUtil.close((Statement)prepStmt);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Integer> unregisterAxis(Connection connection, int nLogicalAxisId) throws ClassifyEngineException {
        Object object;
        PreparedStatement prepStmt = null;
        List<Integer> alDeletedPositionIds = null;
        int nAxis = this.getPhysicalAxisId(nLogicalAxisId);
        this.checkAxisId(nAxis);
        try {
            String sSQLStatement = this.sqlStatement.buildUnregisterAxisStatement(nAxis);
            object = this.registeredAxis;
            synchronized (this.registeredAxis) {
                prepStmt = connection.prepareStatement(sSQLStatement);
                prepStmt.executeUpdate();
                this.registeredAxis[nAxis] = -1;
                this.removeAllPositionValuesOnAxis(connection, nAxis);
                alDeletedPositionIds = this.removeEmptyPositions(connection);
                // ** MonitorExit[var7_8 /* !! */ ] (shouldn't be in output)
                this.singlePertinentAxis.clear();
                object = alDeletedPositionIds;
            }
        }
        catch (Exception e) {
            try {
                throw new ClassifyEngineException(e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
        }
        {
            DBUtil.close((Statement)prepStmt);
            return object;
        }
    }

    private int[] loadRegisteredAxis() throws ClassifyEngineException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        int[] tempRegisteredAxis = new int[this.nbMaxAxis];
        try {
            connection = DBUtil.openConnection();
            String sSQLStatement = this.sqlStatement.buildLoadRegisteredAxisStatement();
            prepStmt = connection.prepareStatement(sSQLStatement);
            resSet = prepStmt.executeQuery();
            while (resSet.next()) {
                for (int nI = 0; nI < this.nbMaxAxis; ++nI) {
                    tempRegisteredAxis[nI] = Integer.parseInt(resSet.getString(3 + nI));
                }
            }
        }
        catch (Exception e) {
            try {
                throw new ClassifyEngineException(e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resSet, (Statement)prepStmt);
        DBUtil.close((Connection)connection);
        return tempRegisteredAxis;
    }

    private int getNextUnregisteredAxis() {
        int nNextUnregisteredAxis = -1;
        for (int nI = 0; nI < this.nbMaxAxis && nNextUnregisteredAxis == -1; ++nI) {
            if (this.registeredAxis[nI] != -1) continue;
            nNextUnregisteredAxis = nI;
        }
        return nNextUnregisteredAxis;
    }

    private int getPhysicalAxisId(int nLogicalAxisId) throws ClassifyEngineException {
        for (int nI = 0; nI < this.nbMaxAxis; ++nI) {
            if (this.registeredAxis[nI] != nLogicalAxisId) continue;
            return nI;
        }
        throw new ClassifyEngineException("Cannot get physical axis. nLogicalAxisId: " + nLogicalAxisId, new String[0]);
    }

    private int getLogicalAxisId(int nPhysicalAxisId) throws ClassifyEngineException {
        if (nPhysicalAxisId < 0 || nPhysicalAxisId > this.registeredAxis.length) {
            throw new ClassifyEngineException("Cannot get logical axis. nPhysicalAxisId: " + nPhysicalAxisId, new String[0]);
        }
        return this.registeredAxis[nPhysicalAxisId];
    }

    private boolean isAxisAlreadyRegistered(int nLogicalAxisId) {
        for (int nI = 0; nI < this.nbMaxAxis; ++nI) {
            if (this.registeredAxis[nI] != nLogicalAxisId) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public <T extends Value> int isPositionAlreadyExists(int nSilverObjectId, Position<T> position) throws ClassifyEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T extends Value> int classifySilverObject(Connection connection, int silverObjectId, Position<T> position) throws ClassifyEngineException {
        Objects.requireNonNull(connection);
        this.checkParameters(silverObjectId, position);
        List<T> alValues = position.getValues();
        for (Value value : alValues) {
            value.setPhysicalAxisId(this.getPhysicalAxisId(value.getAxisId()));
        }
        try {
            int newPositionId = DBUtil.getNextId((String)"SB_ClassifyEngine_Classify", (String)"PositionId");
            String sSQLStatement = this.sqlStatement.buildClassifyStatement(silverObjectId, position, newPositionId);
            try (PreparedStatement prepStmt = connection.prepareStatement(sSQLStatement);){
                prepStmt.executeUpdate();
            }
            this.singlePertinentAxis.clear();
            return newPositionId;
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
    }

    public void unclassifySilverObject(Connection connection, int nSilverObjectId) throws ClassifyEngineException {
        Objects.requireNonNull(connection);
        this.checkSilverObjectId(nSilverObjectId);
        String sSQLStatement = this.sqlStatement.buildRemoveSilverObjectStatement(nSilverObjectId);
        try (PreparedStatement prepStmt = connection.prepareStatement(sSQLStatement);){
            prepStmt.executeUpdate();
            this.singlePertinentAxis.clear();
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
    }

    public void unclassifySilverObjectByPositionId(Connection connection, int nPositionId) throws ClassifyEngineException {
        Objects.requireNonNull(connection);
        String sSQLStatement = this.sqlStatement.buildRemoveByPositionIdStatement(nPositionId);
        try (PreparedStatement prepStmt = connection.prepareStatement(sSQLStatement);){
            prepStmt.executeUpdate();
            this.singlePertinentAxis.clear();
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
    }

    public <T extends Value> void updateSilverObjectPosition(Position<T> newPosition) throws ClassifyEngineException {
        this.checkPosition(newPosition);
        List<T> alValues = newPosition.getValues();
        for (Value value : alValues) {
            value.setPhysicalAxisId(this.getPhysicalAxisId(value.getAxisId()));
        }
        try (Connection connection = DBUtil.openConnection();){
            String sSQLStatement = this.sqlStatement.buildUpdateByPositionIdStatement(newPosition);
            try (PreparedStatement prepStmt = connection.prepareStatement(sSQLStatement);){
                prepStmt.executeUpdate();
            }
            this.singlePertinentAxis.clear();
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
    }

    public void updateSilverObjectPositions(List<Value> classifyValues, int nSilverObjectId) throws ClassifyEngineException {
        try (Connection connection = DBUtil.openConnection();){
            for (Value classifyValue : classifyValues) {
                String sql = this.sqlStatement.buildUpdateByObjectIdStatement(classifyValue, nSilverObjectId);
                try (PreparedStatement prepStmt = connection.prepareStatement(sql);){
                    prepStmt.executeUpdate();
                }
                this.singlePertinentAxis.clear();
            }
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
    }

    public List<Integer> findSilverOjectByCriterias(List<? extends Criteria> alGivenCriterias, List<String> instanceIds, JoinStatement joinStatementContent, String afterDate, String beforeDate, boolean recursiveSearch, boolean visibilitySensitive) throws ClassifyEngineException {
        ArrayList<Integer> arrayList;
        block27: {
            ArrayList<Integer> allObjectIds = new ArrayList<Integer>();
            List<Criteria> allCriteria = this.buildCriteriaOnAxis(alGivenCriterias);
            Connection connection = DBUtil.openConnection();
            try {
                String today = DateUtil.today2SQLDate();
                String sSQLStatement = this.sqlStatement.buildFindByCriteriasStatementByJoin(allCriteria, instanceIds, joinStatementContent, today, recursiveSearch, visibilitySensitive);
                try (PreparedStatement prepStmt = connection.prepareStatement(sSQLStatement);){
                    if (beforeDate != null && beforeDate.length() > 0 && afterDate != null && afterDate.length() > 0) {
                        prepStmt.setDate(1, new Date(DateUtil.parseDate((String)beforeDate).getTime()));
                        prepStmt.setDate(2, new Date(DateUtil.parseDate((String)afterDate).getTime()));
                    } else if (beforeDate != null && beforeDate.length() > 0) {
                        prepStmt.setDate(1, new Date(DateUtil.parseDate((String)beforeDate).getTime()));
                    } else if (afterDate != null && afterDate.length() > 0) {
                        prepStmt.setDate(1, new Date(DateUtil.parseDate((String)afterDate).getTime()));
                    }
                    try (ResultSet resSet = prepStmt.executeQuery();){
                        while (resSet.next()) {
                            allObjectIds.add(resSet.getInt(1));
                        }
                    }
                }
                arrayList = allObjectIds;
                if (connection == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifyEngineException(e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    private List<Criteria> buildCriteriaOnAxis(List<? extends Criteria> allGivenCriteria) throws ClassifyEngineException {
        this.checkCriterias(allGivenCriteria);
        ArrayList<Criteria> allCriteria = new ArrayList<Criteria>();
        for (Criteria criteria : allGivenCriteria) {
            allCriteria.add(new Criteria(this.getPhysicalAxisId(criteria.getAxisId()), criteria.getValue()));
        }
        return allCriteria;
    }

    /*
     * Exception decompiling
     */
    public List<Position<Value>> findPositionsBySilverOjectId(int nSilverObjectId) throws ClassifyEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeAllPositionValuesOnAxis(Connection connection, int nAxisId) throws ClassifyEngineException {
        String sSQLStatement = this.sqlStatement.buildRemoveAllPositionValuesStatement(nAxisId);
        try (PreparedStatement prepStmt = connection.prepareStatement(sSQLStatement);){
            prepStmt.executeUpdate();
            this.singlePertinentAxis.clear();
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
    }

    private List<Integer> removeEmptyPositions(Connection connection) throws ClassifyEngineException {
        PreparedStatement prepStmt;
        String sSQLStatement = this.sqlStatement.buildGetEmptyPositionsStatement(this.nbMaxAxis);
        ArrayList<Integer> allDeletedPositionIds = new ArrayList<Integer>();
        try {
            prepStmt = connection.prepareStatement(sSQLStatement);
            try (ResultSet resSet = prepStmt.executeQuery();){
                while (resSet.next()) {
                    allDeletedPositionIds.add(resSet.getInt(1));
                }
            }
            finally {
                if (prepStmt != null) {
                    prepStmt.close();
                }
            }
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
        sSQLStatement = this.sqlStatement.buildRemoveEmptyPositionsStatement(this.nbMaxAxis);
        try {
            prepStmt = connection.prepareStatement(sSQLStatement);
            try {
                prepStmt.executeUpdate();
                this.singlePertinentAxis.clear();
            }
            finally {
                if (prepStmt != null) {
                    prepStmt.close();
                }
            }
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
        return allDeletedPositionIds;
    }

    public void replaceValuesOnAxis(Connection connection, List<Value> oldValue, List<Value> newValue) throws ClassifyEngineException {
        Objects.requireNonNull(connection);
        for (int nI = 0; nI < oldValue.size(); ++nI) {
            Value oldV = oldValue.get(nI);
            Value newV = newValue.get(nI);
            oldV.setAxisId(this.getPhysicalAxisId(oldV.getAxisId()));
            newV.setAxisId(this.getPhysicalAxisId(newV.getAxisId()));
            this.checkAxisId(oldV.getAxisId());
            if (oldV.getAxisId() != newV.getAxisId()) {
                throw new ClassifyEngineException("Axis ids not identical", new String[0]);
            }
            if (!oldV.getValue().equals(newV.getValue())) continue;
            throw new ClassifyEngineException("Axis values identical", new String[0]);
        }
        try {
            PreparedStatement prepStmt;
            String sSQLStatement;
            for (int nIndex = 0; nIndex < oldValue.size(); ++nIndex) {
                sSQLStatement = this.sqlStatement.buildReplaceValuesStatement(oldValue.get(nIndex), newValue.get(nIndex));
                prepStmt = connection.prepareStatement(sSQLStatement);
                try {
                    prepStmt.executeUpdate();
                    continue;
                }
                finally {
                    if (prepStmt != null) {
                        prepStmt.close();
                    }
                }
            }
            sSQLStatement = this.sqlStatement.buildRemoveEmptyPositionsStatement(this.nbMaxAxis);
            prepStmt = connection.prepareStatement(sSQLStatement);
            try {
                prepStmt.executeUpdate();
            }
            finally {
                if (prepStmt != null) {
                    prepStmt.close();
                }
            }
            this.singlePertinentAxis.clear();
        }
        catch (Exception e) {
            throw new ClassifyEngineException(e);
        }
    }

    private void checkSilverObjectId(int nSilverObjectId) throws ClassifyEngineException {
        if (nSilverObjectId < 0) {
            throw new ClassifyEngineException("Incorrect SilverObject id", new String[0]);
        }
    }

    private <T extends Value> void checkPosition(Position<T> position) throws ClassifyEngineException {
        if (position == null) {
            throw new ClassifyEngineException("Null position", new String[0]);
        }
        position.checkPosition();
    }

    private <T extends Value> void checkParameters(int nSilverObjectId, Position<T> position) throws ClassifyEngineException {
        this.checkSilverObjectId(nSilverObjectId);
        this.checkPosition(position);
    }

    private void checkCriterias(List<? extends Criteria> alCriterias) throws ClassifyEngineException {
        if (alCriterias == null) {
            throw new ClassifyEngineException("Null criteria", new String[0]);
        }
        for (Criteria criteria : alCriterias) {
            criteria.checkCriteria();
        }
    }

    private void checkAxisId(int nAxisId) throws ClassifyEngineException {
        if (nAxisId < 0) {
            throw new ClassifyEngineException("Incorrect axis id. nAxisId: " + nAxisId, new String[0]);
        }
    }

    public List<PertinentAxis> getPertinentAxisByJoin(List<? extends Criteria> alGivenCriterias, List<Integer> alAxisIds, List<String> instanceIds) throws ClassifyEngineException {
        ArrayList<PertinentAxis> arrayList;
        block9: {
            List<Criteria> alCriterias = this.buildCriteriaOnAxis(alGivenCriterias);
            Connection connection = DBUtil.openConnection();
            try {
                String today = DateUtil.today2SQLDate();
                ArrayList<PertinentAxis> alPertinentAxis = new ArrayList<PertinentAxis>();
                for (Integer alAxisId : alAxisIds) {
                    int nAxisId = this.getPhysicalAxisId(alAxisId);
                    alPertinentAxis.add(this.getSinglePertinentAxisByJoin(connection, alCriterias, nAxisId, "", instanceIds, today));
                }
                arrayList = alPertinentAxis;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ClassifyEngineException(e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    private PertinentAxis getSinglePertinentAxisByJoin(Connection connection, List<? extends Criteria> alCriterias, int nAxisId, String sRootValue, List<String> instanceIds, String todayFormatted) throws ClassifyEngineException {
        String sSQLStatement = this.sqlStatement.buildGetPertinentAxisStatementByJoin(alCriterias, nAxisId, sRootValue, instanceIds, todayFormatted);
        PertinentAxis pertinentAxis = this.singlePertinentAxis.get(sSQLStatement);
        if (pertinentAxis == null) {
            try (PreparedStatement prepStmt = connection.prepareStatement(sSQLStatement);
                 ResultSet resSet = prepStmt.executeQuery();){
                pertinentAxis = new PertinentAxis();
                pertinentAxis.setAxisId(this.getLogicalAxisId(nAxisId));
                int nDocs = 0;
                while (resSet.next()) {
                    nDocs += resSet.getInt(1);
                }
                pertinentAxis.setNbObjects(nDocs);
                pertinentAxis.setRootValue(sRootValue);
                this.singlePertinentAxis.put(sSQLStatement, pertinentAxis);
            }
            catch (Exception e) {
                throw new ClassifyEngineException(e);
            }
        }
        return pertinentAxis;
    }

    /*
     * Exception decompiling
     */
    public List<PertinentValue> getPertinentValuesByJoin(List<? extends Criteria> alGivenCriterias, int nLogicalAxisId, List<String> instanceIds) throws ClassifyEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<ObjectValuePair> getObjectValuePairsByJoin(List<? extends Criteria> alGivenCriterias, int nLogicalAxisId, List<String> instanceIds) throws ClassifyEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Integer> getPertinentAxisByInstanceIds(List<String> instanceIds) throws ClassifyEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

