/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.organizationchart.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.silverpeas.components.organizationchart.model.OrganizationalChart;
import org.silverpeas.components.organizationchart.model.OrganizationalChartType;
import org.silverpeas.components.organizationchart.model.OrganizationalPerson;
import org.silverpeas.components.organizationchart.model.OrganizationalPersonComparator;
import org.silverpeas.components.organizationchart.model.OrganizationalUnit;
import org.silverpeas.components.organizationchart.model.PersonCategory;
import org.silverpeas.components.organizationchart.service.AbstractOrganizationChartBuilder;
import org.silverpeas.components.organizationchart.service.GroupOrganizationChartConfiguration;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.kernel.util.StringUtil;

class GroupOrganizationChartBuilder
extends AbstractOrganizationChartBuilder {
    private final GroupOrganizationChartConfiguration config;

    static GroupOrganizationChartBuilder from(GroupOrganizationChartConfiguration config) {
        return new GroupOrganizationChartBuilder(config);
    }

    private GroupOrganizationChartBuilder(GroupOrganizationChartConfiguration config) {
        this.config = config;
    }

    OrganizationalChart buildFor(String groupId, OrganizationalChartType type) {
        OrganizationalChart chart;
        List<OrganizationalPerson> ouMembers;
        Group parent;
        if (!StringUtil.isDefined((String)groupId)) {
            groupId = this.config.getRoot();
        }
        Group group = OrganizationControllerProvider.getOrganisationController().getGroup(groupId);
        OrganizationalUnit root = new OrganizationalUnit(group.getName(), groupId);
        if (!groupId.equals(this.config.getRoot()) && !group.isRoot() && (parent = OrganizationControllerProvider.getOrganisationController().getGroup(group.getSuperGroupId())) != null) {
            root.setParentName(parent.getName());
            root.setParentOu(parent.getId());
        }
        root.setHasMembers((ouMembers = this.getMembers(groupId, group.getUserIds(), type)) != null && !ouMembers.isEmpty());
        switch (type) {
            case TYPE_UNITCHART: {
                List<OrganizationalUnit> units = this.getSubOrganizationUnits(group);
                chart = new OrganizationalChart(root, units, ouMembers, true);
                break;
            }
            default: {
                Set<PersonCategory> categories = this.getCategories(ouMembers);
                chart = new OrganizationalChart(root, ouMembers, categories, true);
            }
        }
        return chart;
    }

    private List<OrganizationalPerson> getMembers(String groupId, String[] userIds, OrganizationalChartType type) {
        ArrayList<OrganizationalPerson> personList = new ArrayList<OrganizationalPerson>(userIds.length);
        for (String userId : userIds) {
            OrganizationalPerson person = this.loadOrganizationalPerson(userId, type);
            if (person == null) continue;
            personList.add(person);
        }
        Collections.sort(personList, new OrganizationalPersonComparator());
        return personList;
    }

    private OrganizationalPerson loadOrganizationalPerson(String id, OrganizationalChartType type) {
        Map<String, String> attributesToReturn;
        UserFull user = OrganizationControllerProvider.getOrganisationController().getUserFull(id);
        if (!user.isActivatedState()) {
            return null;
        }
        String userFunction = user.getValue(this.config.getAttTitle());
        String userDescription = user.getValue(this.config.getAttDesc());
        String userService = user.getValue(this.config.getAttUnit());
        OrganizationalPerson person = new OrganizationalPerson(Integer.parseInt(id), -1, user.getDisplayedName(), userFunction, userDescription, userService, null);
        switch (type) {
            case TYPE_UNITCHART: {
                attributesToReturn = this.config.getUnitsChartOthersInfosKeys();
                break;
            }
            default: {
                attributesToReturn = this.config.getPersonnsChartOthersInfosKeys();
            }
        }
        HashMap<String, String> details = new HashMap<String, String>();
        for (Map.Entry<String, String> attribute : attributesToReturn.entrySet()) {
            details.put(attribute.getValue(), user.getValue(attribute.getKey()));
        }
        person.setDetail(details);
        if (userFunction != null) {
            switch (type) {
                case TYPE_UNITCHART: {
                    this.defineUnitChartRoles(person, userFunction, this.config);
                    break;
                }
                default: {
                    this.defineDetailledChartRoles(person, userFunction, this.config);
                    break;
                }
            }
        } else {
            person.setVisibleCategory(new PersonCategory("Personnel"));
        }
        return person;
    }

    private List<OrganizationalUnit> getSubOrganizationUnits(Group group) {
        List subgroups = group.getSubGroups();
        ArrayList<OrganizationalUnit> units = new ArrayList<OrganizationalUnit>(subgroups.size());
        for (Group subgroup : subgroups) {
            OrganizationalUnit unit = new OrganizationalUnit(subgroup.getName(), subgroup.getId());
            unit.setParentName(group.getName());
            unit.setParentOu(group.getId());
            unit.setHasSubUnits(!subgroup.getSubGroups().isEmpty());
            List<OrganizationalPerson> users = this.getMembers(subgroup.getId(), subgroup.getUserIds(), OrganizationalChartType.TYPE_UNITCHART);
            List<OrganizationalPerson> mainActors = this.getMainActors(users);
            unit.setMainActors(mainActors);
            unit.setHasMembers(users.size() > mainActors.size());
            units.add(unit);
        }
        return units;
    }
}

