/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.MethodGenerator;
import oracle.jdbc.proxy.MethodSignature;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.Utils;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.proxy.annotation.ProxyFor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class ClassGenerator {
    private final AnnotationsForIface annotationsForIface;
    private final String proxyName;
    private final String superclassName;
    private final String ifaceName;
    private final String proxyType;
    private final String ifaceType;
    final Map<MethodSignature, MethodGenerator> members;

    private ClassGenerator(AnnotationsForIface annotationsForIface, String string, String string2, String string3, Map<MethodSignature, MethodGenerator> map) {
        this.annotationsForIface = annotationsForIface;
        this.proxyName = Utils.makeSlashed(string);
        this.proxyType = Utils.makeType(string);
        this.superclassName = Utils.makeSlashed(string2);
        this.ifaceName = Utils.makeSlashed(string3);
        this.ifaceType = Utils.makeType(string3);
        this.members = map;
    }

    String getProxyName() {
        return this.proxyName;
    }

    String getSuperclassName() {
        return this.superclassName;
    }

    String getIfaceName() {
        return this.ifaceName;
    }

    String getProxyType() {
        return this.proxyType;
    }

    String getIfaceType() {
        return this.ifaceType;
    }

    static <T> byte[] generateBytecode(GeneratedProxiesRegistry.Key key, AnnotationsRegistry annotationsRegistry) {
        Class clazz = key.getIface();
        final Class clazz2 = key.getSuperclass();
        if (!clazz.isInterface()) {
            new RuntimeException("iface must be interface");
        }
        if (clazz2.isInterface()) {
            new RuntimeException("sclass must not be interface");
        }
        HashMap<MethodSignature, MethodGenerator> hashMap = new HashMap<MethodSignature, MethodGenerator>();
        final HashMap hashMap2 = new HashMap();
        final HashMap hashMap3 = new HashMap();
        AnnotationsForIface annotationsForIface = new AnnotationsForIface(annotationsRegistry, clazz, annotationsRegistry.get(clazz));
        ClassGenerator classGenerator = new ClassGenerator(annotationsForIface, key.toString(), clazz2.getName(), clazz.getName(), hashMap);
        new Runnable(){

            @Override
            public void run() {
                this.traverse(clazz2, clazz2.isAnnotationPresent(ProxyFor.class));
            }

            void traverse(Class clazz, boolean bl) {
                if (null == clazz) {
                    return;
                }
                for (Method method : clazz.getDeclaredMethods()) {
                    MethodSignature methodSignature = new MethodSignature(method);
                    if (bl) {
                        hashMap2.put(methodSignature, method);
                        continue;
                    }
                    if (Modifier.isAbstract(method.getModifiers())) continue;
                    hashMap3.put(methodSignature, method);
                }
                Class clazz22 = clazz.getSuperclass();
                this.traverse(clazz22, bl && clazz22.isAnnotationPresent(ProxyFor.class));
            }
        }.run();
        for (Method method : clazz.getMethods()) {
            MethodSignature methodSignature = new MethodSignature(method);
            Method method2 = (Method)hashMap2.get(methodSignature);
            if (null == method2 && hashMap3.containsKey(methodSignature)) continue;
            hashMap.put(methodSignature, new MethodGenerator(classGenerator, method, null == method2 || Modifier.isAbstract(method2.getModifiers())));
        }
        ClassWriter classWriter = new ClassWriter(3);
        classGenerator.generate(classWriter);
        return classWriter.toByteArray();
    }

    static <T> Class generate(Class<T> clazz, Class clazz2, AnnotationsRegistry annotationsRegistry) {
        GeneratedProxiesRegistry.Key key = new GeneratedProxiesRegistry.Key(clazz, clazz2);
        final byte[] byArray = ClassGenerator.generateBytecode(key, annotationsRegistry);
        String string = System.getProperty("oracle.jdbc.proxy.asm.verify");
        if (null != string && 0 == "true".compareToIgnoreCase(string)) {
            try {
                Class<?> clazz3 = Class.forName("org.objectweb.asm.util.CheckClassAdapter");
                Method method = clazz3.getMethod("verify", ClassReader.class, Boolean.TYPE, PrintWriter.class);
                method.invoke(null, new ClassReader(byArray), true, new PrintWriter(new OutputStreamWriter(System.out)));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        try {
            return Class.forName(key.toString(), false, new ClassLoader(){

                protected Class findClass(String string) {
                    return this.defineClass(string, byArray, 0, byArray.length);
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private void generate(ClassWriter classWriter) {
        Label label;
        Method method;
        Object object;
        classWriter.visit(50, 33, this.proxyName, null, this.superclassName, new String[]{this.ifaceName, Utils.makeSlashed(_Proxy_.class.getName())});
        for (MethodGenerator object32 : this.members.values()) {
            if (null == object32) continue;
            object32.generate(classWriter);
        }
        Object object4 = classWriter.visitMethod(1, "_getDelegate_", "()" + this.ifaceType, null, null);
        object4.visitCode();
        object4.visitVarInsn(25, 0);
        object4.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
        object4.visitInsn(176);
        object4.visitMaxs(0, 0);
        object4.visitEnd();
        object4 = classWriter.visitMethod(4161, "_getDelegate_", "()Ljava/lang/Object;", null, null);
        object4.visitCode();
        object4.visitVarInsn(25, 0);
        object4.visitMethodInsn(182, this.proxyName, "_getDelegate_", "()" + this.ifaceType);
        object4.visitInsn(176);
        object4.visitMaxs(0, 0);
        object4.visitEnd();
        object4 = this.annotationsForIface.getValue();
        if (null != object4) {
            Object object2;
            Method method2;
            Method method3 = ((AnnotationsRegistry.Value)object4).getMethodGetDelegate();
            if (null != method3) {
                MethodVisitor methodVisitor = classWriter.visitMethod(1, method3.getName(), "()" + Utils.makeType(method3.getReturnType()), null, null);
                methodVisitor.visitCode();
                object = new Label();
                methodVisitor.visitLabel((Label)object);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
                methodVisitor.visitInsn(176);
                method = new Label();
                methodVisitor.visitLabel((Label)method);
                methodVisitor.visitLocalVariable("this", this.proxyType, null, (Label)object, (Label)method, 0);
                methodVisitor.visitMaxs(0, 0);
                methodVisitor.visitEnd();
            }
            if (null != (method2 = ((AnnotationsRegistry.Value)object4).getMethodSetDelegate())) {
                object = method2.getParameterTypes();
                if (1 != ((Class<?>[])object).length) {
                    throw new RuntimeException("wrong delegate setter signature");
                }
                method = classWriter.visitMethod(1, method2.getName(), "(" + Utils.makeType((Class)object[0]) + ")V", null, null);
                method.visitCode();
                label = new Label();
                method.visitLabel(label);
                method.visitVarInsn(25, 0);
                method.visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class));
                method.visitVarInsn(25, 0);
                method.visitVarInsn(25, 0);
                method.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
                method.visitVarInsn(25, 1);
                method.visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class), "updateDelegate", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
                method.visitVarInsn(25, 0);
                method.visitVarInsn(25, 1);
                method.visitFieldInsn(181, this.proxyName, "delegate", this.ifaceType);
                method.visitInsn(177);
                object2 = new Label();
                method.visitLabel((Label)object2);
                method.visitLocalVariable("this", this.proxyType, null, label, (Label)object2, 0);
                method.visitLocalVariable("delegate", this.ifaceType, null, label, (Label)object2, 1);
                method.visitMaxs(0, 0);
                method.visitEnd();
            }
            if (null != (object = ((AnnotationsRegistry.Value)object4).getMethodGetCreator())) {
                method = classWriter.visitMethod(1, ((Method)object).getName(), "()" + Utils.makeType(((Method)object).getReturnType()), null, null);
                method.visitCode();
                label = new Label();
                method.visitLabel(label);
                method.visitVarInsn(25, 0);
                method.visitFieldInsn(180, this.proxyName, "creator", "Ljava/lang/Object;");
                method.visitInsn(176);
                object2 = new Label();
                method.visitLabel((Label)object2);
                method.visitLocalVariable("this", this.proxyType, null, label, (Label)object2, 0);
                method.visitMaxs(1, 1);
                method.visitEnd();
            }
            if (null != (method = ((AnnotationsRegistry.Value)object4).getMethodGetProxy())) {
                label = method.getParameterTypes();
                object2 = method.getReturnType();
                if (!Arrays.deepEquals(new Class[]{Object.class, Object.class}, (Object[])label) || !Object.class.equals(object2)) {
                    throw new RuntimeException("internal error: wrong @GetProxy method");
                }
                MethodVisitor methodVisitor = classWriter.visitMethod(1, method.getName(), "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "<T:Ljava/lang/Object;>(TT;Ljava/lang/Object;)TT;", null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class));
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class), "proxyFor", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(3, 3);
                methodVisitor.visitEnd();
            }
        }
        classWriter.visitField(2, "delegate", this.ifaceType, null, null).visitEnd();
        classWriter.visitField(18, "creator", "Ljava/lang/Object;", null, null).visitEnd();
        classWriter.visitField(18, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()), null, null).visitEnd();
        classWriter.visitField(18, "proxyCache", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;", null).visitEnd();
        classWriter.visitField(10, "zeroLengthObjectArray", "[Ljava/lang/Object;", null, null).visitEnd();
        boolean bl = false;
        for (MethodGenerator methodGenerator : this.members.values()) {
            classWriter.visitField(10, methodGenerator.getMethodObject(), "Ljava/lang/reflect/Method;", null, null).visitEnd();
            bl = true;
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        methodVisitor.visitCode();
        Utils.loadConst(methodVisitor, 0);
        methodVisitor.visitTypeInsn(189, "java/lang/Object");
        methodVisitor.visitFieldInsn(179, this.proxyName, "zeroLengthObjectArray", "[Ljava/lang/Object;");
        if (bl) {
            Label label2 = new Label();
            object = new Label();
            method = new Label();
            methodVisitor.visitTryCatchBlock(label2, (Label)object, (Label)method, "java/lang/Throwable");
            methodVisitor.visitLabel(label2);
            for (MethodGenerator methodGenerator : this.members.values()) {
                methodGenerator.initializeMethodObject(methodVisitor);
            }
            methodVisitor.visitLabel((Label)object);
            label = new Label();
            methodVisitor.visitJumpInsn(167, label);
            methodVisitor.visitLabel((Label)method);
            methodVisitor.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
            methodVisitor.visitVarInsn(58, 0);
            methodVisitor.visitTypeInsn(187, "java/lang/RuntimeException");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
            methodVisitor.visitInsn(191);
            methodVisitor.visitLabel(label);
            methodVisitor.visitFrame(3, 0, null, 0, null);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        String string = "(" + this.ifaceType + "Ljava/lang/Object;" + Utils.makeType(ProxyFactory.class.getName()) + "Ljava/util/Map;" + ")V";
        MethodVisitor methodVisitor2 = classWriter.visitMethod(1, "<init>", string, null, null);
        methodVisitor2.visitCode();
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitMethodInsn(183, this.superclassName, "<init>", "()V");
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitVarInsn(25, 1);
        methodVisitor2.visitFieldInsn(181, this.proxyName, "delegate", this.ifaceType);
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitVarInsn(25, 2);
        methodVisitor2.visitFieldInsn(181, this.proxyName, "creator", "Ljava/lang/Object;");
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitVarInsn(25, 3);
        methodVisitor2.visitFieldInsn(181, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()));
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitVarInsn(25, 4);
        methodVisitor2.visitFieldInsn(181, this.proxyName, "proxyCache", "Ljava/util/Map;");
        methodVisitor2.visitInsn(177);
        methodVisitor2.visitMaxs(0, 0);
        methodVisitor2.visitEnd();
        classWriter.visitEnd();
    }

    AnnotationsForIface getAnnotationsForIface() {
        return this.annotationsForIface;
    }

    static class AnnotationsForIface {
        private final AnnotationsRegistry registry;
        private final Class iface;
        private final AnnotationsRegistry.Value value;

        AnnotationsForIface(AnnotationsRegistry annotationsRegistry, Class clazz, AnnotationsRegistry.Value value) {
            this.registry = annotationsRegistry;
            this.iface = clazz;
            this.value = value;
        }

        AnnotationsRegistry getRegistry() {
            return this.registry;
        }

        Class getIface() {
            return this.iface;
        }

        AnnotationsRegistry.Value getValue() {
            return this.value;
        }
    }
}

