/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.spnego;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSException;
import org.silverpeas.spnego.SpnegoAuthenticator;
import org.silverpeas.spnego.SpnegoFilterConfig;
import org.silverpeas.spnego.SpnegoGSSException;
import org.silverpeas.spnego.SpnegoHttpServletRequest;
import org.silverpeas.spnego.SpnegoHttpServletResponse;
import org.silverpeas.spnego.SpnegoPrincipal;
import org.silverpeas.spnego.SpnegoUnauthenticatedException;
import org.silverpeas.spnego.SpnegoUnsupportedOperationException;

public final class SpnegoHttpFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger("SpnegoHttpFilter");
    private transient SpnegoAuthenticator authenticator = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            SpnegoFilterConfig config = SpnegoFilterConfig.getInstance(filterConfig);
            this.authenticator = new SpnegoAuthenticator(config);
        }
        catch (LoginException le) {
            throw new ServletException((Throwable)le);
        }
        catch (GSSException gsse) {
            throw new ServletException((Throwable)gsse);
        }
        catch (PrivilegedActionException pae) {
            throw new ServletException((Throwable)pae);
        }
        catch (FileNotFoundException fnfe) {
            throw new ServletException((Throwable)fnfe);
        }
        catch (URISyntaxException uri) {
            throw new ServletException((Throwable)uri);
        }
    }

    public void destroy() {
        if (null != this.authenticator) {
            this.authenticator.dispose();
            this.authenticator = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SpnegoPrincipal principal;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getUserPrincipal() instanceof SpnegoPrincipal) {
            chain.doFilter((ServletRequest)httpRequest, response);
            return;
        }
        SpnegoHttpServletResponse spnegoResponse = new SpnegoHttpServletResponse((HttpServletResponse)response);
        try {
            principal = this.authenticator.authenticate(httpRequest, spnegoResponse);
        }
        catch (GSSException gsse) {
            LOGGER.severe("HTTP Authorization Header=" + httpRequest.getHeader("Authorization"));
            if (this.authenticator.isTypedRuntimeExceptionThrown()) {
                throw new SpnegoGSSException(gsse);
            }
            throw new ServletException((Throwable)gsse);
        }
        catch (RuntimeException re) {
            if (this.authenticator.isTypedRuntimeExceptionThrown()) {
                throw new SpnegoUnsupportedOperationException(re);
            }
            throw re;
        }
        if (spnegoResponse.isStatusSet()) {
            return;
        }
        if (null == principal) {
            LOGGER.severe("Principal was null.");
            if (this.authenticator.isTypedRuntimeExceptionThrown()) {
                throw new SpnegoUnauthenticatedException("Principal was null.");
            }
            spnegoResponse.setStatus(500, true);
            return;
        }
        LOGGER.fine("principal=" + principal);
        chain.doFilter((ServletRequest)new SpnegoHttpServletRequest(httpRequest, principal), response);
    }

    public static final class Constants {
        public static final String THROW_TYPED_RUNTIME_EXCEPTION = "spnego.throw.typedRuntimeException";
        public static final String ALLOW_BASIC = "spnego.allow.basic";
        public static final String ALLOW_DELEGATION = "spnego.allow.delegation";
        public static final String ALLOW_LOCALHOST = "spnego.allow.localhost";
        public static final String ALLOW_UNSEC_BASIC = "spnego.allow.unsecure.basic";
        public static final String AUTHN_HEADER = "WWW-Authenticate";
        public static final String AUTHZ_HEADER = "Authorization";
        public static final String BASIC_HEADER = "Basic";
        public static final String CLIENT_MODULE = "spnego.login.client.module";
        public static final String KRB5_CONF = "spnego.krb5.conf";
        static final String LOGGER_LEVEL = "spnego.logger.level";
        static final String LOGGER_NAME = "SpnegoHttpFilter";
        public static final String LOGIN_CONF = "spnego.login.conf";
        public static final String NEGOTIATE_HEADER = "Negotiate";
        static final String NTLM_PROLOG = "TlRMTVNT";
        public static final String PREAUTH_PASSWORD = "spnego.preauth.password";
        public static final String PREAUTH_USERNAME = "spnego.preauth.username";
        public static final String PROMPT_NTLM = "spnego.prompt.ntlm";
        public static final String SERVER_MODULE = "spnego.login.server.module";

        private Constants() {
        }
    }
}

