/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.spnego;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.silverpeas.spnego.Base64;
import org.silverpeas.spnego.SpnegoAuthScheme;
import org.silverpeas.spnego.SpnegoFilterConfig;
import org.silverpeas.spnego.SpnegoHttpServletResponse;
import org.silverpeas.spnego.SpnegoPrincipal;
import org.silverpeas.spnego.SpnegoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpnegoAuthenticator {
    private static final Logger LOGGER = Logger.getLogger("SpnegoHttpFilter");
    private static final Lock LOCK = new ReentrantLock();
    private static final GSSManager MANAGER = GSSManager.getInstance();
    private final transient boolean throwTypedRuntimeException;
    private final transient boolean allowBasic;
    private final transient boolean allowDelegation;
    private final transient boolean allowLocalhost;
    private final transient boolean allowUnsecure;
    private final transient boolean promptIfNtlm;
    private final transient String clientModuleName;
    private final transient LoginContext loginContext;
    private final transient GSSCredential serverCredentials;
    private final transient KerberosPrincipal serverPrincipal;

    public SpnegoAuthenticator(SpnegoFilterConfig config) throws LoginException, GSSException, PrivilegedActionException {
        LOGGER.fine("config=" + config);
        this.throwTypedRuntimeException = config.isTypedRuntimeExceptionThrown();
        this.allowBasic = config.isBasicAllowed();
        this.allowUnsecure = config.isUnsecureAllowed();
        this.clientModuleName = config.getClientLoginModule();
        this.allowLocalhost = config.isLocalhostAllowed();
        this.promptIfNtlm = config.downgradeNtlm();
        this.allowDelegation = config.isDelegationAllowed();
        if (config.useKeyTab()) {
            this.loginContext = new LoginContext(config.getServerLoginModule());
        } else {
            CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(config.getPreauthUsername(), config.getPreauthPassword());
            this.loginContext = new LoginContext(config.getServerLoginModule(), handler);
        }
        this.loginContext.login();
        this.serverCredentials = SpnegoProvider.getServerCredential(this.loginContext.getSubject());
        this.serverPrincipal = new KerberosPrincipal(((Object)this.serverCredentials.getName()).toString());
    }

    public SpnegoAuthenticator(final Map<String, String> config) throws LoginException, GSSException, PrivilegedActionException, FileNotFoundException, URISyntaxException {
        this(SpnegoFilterConfig.getInstance(new FilterConfig(){
            private final Map<String, String> map;
            {
                this.map = Collections.unmodifiableMap(config);
            }

            public String getFilterName() {
                throw new UnsupportedOperationException();
            }

            public String getInitParameter(String param) {
                if (null == this.map.get(param)) {
                    throw new NullPointerException("Config missing param value for: " + param);
                }
                return this.map.get(param);
            }

            public Enumeration getInitParameterNames() {
                throw new UnsupportedOperationException();
            }

            public ServletContext getServletContext() {
                throw new UnsupportedOperationException();
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpnegoPrincipal authenticate(HttpServletRequest req, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        boolean basicSupported = this.allowBasic && (this.allowUnsecure || req.isSecure());
        String serverRealm = this.serverPrincipal.getRealm();
        if (this.allowLocalhost && this.isLocalhost(req)) {
            return this.doLocalhost();
        }
        SpnegoAuthScheme scheme = SpnegoProvider.negotiate(req, resp, basicSupported, this.promptIfNtlm, serverRealm);
        if (null == scheme) {
            LOGGER.finer("scheme null.");
            return null;
        }
        if (scheme.isNegotiateScheme()) {
            return this.doSpnegoAuth(scheme, resp);
        }
        if (!scheme.isBasicScheme()) throw new UnsupportedOperationException("scheme=" + scheme);
        if (basicSupported) {
            return this.doBasicAuth(scheme, resp);
        }
        LOGGER.severe("allowBasic=" + this.allowBasic + "; allowUnsecure=" + this.allowUnsecure + "; req.isSecure()=" + req.isSecure());
        throw new UnsupportedOperationException("Basic Auth not allowed or SSL required.");
    }

    public void dispose() {
        if (null != this.serverCredentials) {
            try {
                this.serverCredentials.dispose();
            }
            catch (GSSException e) {
                LOGGER.log(Level.WARNING, "Dispose failed.", e);
            }
        }
        if (null != this.loginContext) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException le) {
                LOGGER.log(Level.WARNING, "Logout failed.", le);
            }
        }
    }

    private SpnegoPrincipal doBasicAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws IOException {
        byte[] data = scheme.getToken();
        if (0 == data.length) {
            LOGGER.finer("Basic Auth data was NULL.");
            return null;
        }
        String[] basicData = new String(data).split(":", 2);
        if (basicData.length != 2) {
            throw new IllegalArgumentException("Username/Password may have contained an invalid character. basicData.length=" + basicData.length);
        }
        String username = basicData[0].substring(basicData[0].indexOf(92) + 1);
        String password = basicData[1];
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(username, password);
        SpnegoPrincipal principal = null;
        try {
            if (null == username || username.isEmpty()) {
                throw new LoginException("Username is required.");
            }
            LoginContext cntxt = new LoginContext(this.clientModuleName, handler);
            cntxt.login();
            cntxt.logout();
            principal = new SpnegoPrincipal(username + '@' + this.serverPrincipal.getRealm(), 1);
        }
        catch (LoginException le) {
            LOGGER.info(le.getMessage() + ": Login failed. username=" + username + "; password.hashCode()=" + password.hashCode());
            resp.setHeader("WWW-Authenticate", "Negotiate");
            resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.serverPrincipal.getRealm() + '\"');
            resp.setStatus(401, true);
        }
        return principal;
    }

    private SpnegoPrincipal doLocalhost() {
        String username = System.getProperty("user.name");
        if (null == username || username.isEmpty()) {
            return new SpnegoPrincipal(this.serverPrincipal.getName() + '@' + this.serverPrincipal.getRealm(), this.serverPrincipal.getNameType());
        }
        return new SpnegoPrincipal(username + '@' + this.serverPrincipal.getRealm(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpnegoPrincipal doSpnegoAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        String principal;
        byte[] gss = scheme.getToken();
        if (0 == gss.length) {
            LOGGER.finer("GSS data was NULL.");
            return null;
        }
        GSSContext context = null;
        GSSCredential delegCred = null;
        try {
            byte[] token = null;
            LOCK.lock();
            try {
                context = MANAGER.createContext(this.serverCredentials);
                token = context.acceptSecContext(gss, 0, gss.length);
            }
            finally {
                LOCK.unlock();
            }
            if (null == token) {
                LOGGER.finer("Token was NULL.");
                SpnegoPrincipal spnegoPrincipal = null;
                return spnegoPrincipal;
            }
            resp.setHeader("WWW-Authenticate", "Negotiate " + Base64.encode(token));
            if (!context.isEstablished()) {
                LOGGER.fine("context not established");
                resp.setStatus(401, true);
                SpnegoPrincipal spnegoPrincipal = null;
                return spnegoPrincipal;
            }
            principal = ((Object)context.getSrcName()).toString();
            if (this.allowDelegation && context.getCredDelegState()) {
                delegCred = context.getDelegCred();
            }
        }
        finally {
            if (null != context) {
                LOCK.lock();
                try {
                    context.dispose();
                }
                finally {
                    LOCK.unlock();
                }
            }
        }
        return new SpnegoPrincipal(principal, 1, delegCred);
    }

    private boolean isLocalhost(HttpServletRequest req) {
        return req.getLocalAddr().equals(req.getRemoteAddr());
    }

    public boolean isTypedRuntimeExceptionThrown() {
        return this.throwTypedRuntimeException;
    }
}

