/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.util.neko;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import javax.enterprise.inject.Default;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLTagBalancer;
import org.silverpeas.components.mailinglist.service.util.HtmlCleaner;
import org.silverpeas.components.mailinglist.service.util.neko.EntityReplaceWriter;
import org.silverpeas.components.mailinglist.service.util.neko.NekoElementRemover;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.kernel.annotation.Technical;

@Default
@Technical
@Bean
public class NekoHtmlCleaner
implements HtmlCleaner {
    private StringWriter content;
    private XMLParserConfiguration parser;
    private EntityReplaceWriter writer;
    private int maxSize = 0;

    public NekoHtmlCleaner() {
        NekoElementRemover remover = new NekoElementRemover();
        remover.removeElement("script");
        remover.removeElement("title");
        remover.removeElement("link");
        remover.removeElement("meta");
        remover.removeElement("select");
        remover.acceptElement("br", null);
        this.content = new StringWriter();
        this.writer = new EntityReplaceWriter(this.content, "UTF-8");
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new HTMLTagBalancer(), remover, this.writer};
        this.parser = new HTMLConfiguration();
        this.parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
        this.parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
    }

    @Override
    public String getSummary() {
        String buffer = this.content.toString();
        buffer = buffer.trim();
        buffer = buffer.replaceAll("<[B,b][R,r]>", " ");
        buffer = buffer.replaceAll("<[B,b][R,r]/>", " ");
        if ((buffer = buffer.replaceAll("\\s[\\s]*", " ")).length() <= this.maxSize) {
            return buffer;
        }
        return buffer.substring(0, this.maxSize);
    }

    @Override
    public void parse(Reader in) throws IOException {
        this.content = new StringWriter();
        this.writer.setWriter(this.content);
        XMLInputSource source = new XMLInputSource("-//W3C//DTD HTML 4.01", null, null, in, "UTF-8");
        this.parser.parse(source);
    }

    @Override
    public void setSummarySize(int size) {
        this.maxSize = size;
    }
}

