/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;
import org.silverpeas.components.mailinglist.service.MailingListServicesProvider;
import org.silverpeas.components.mailinglist.service.model.beans.MailingList;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Provider
@Named(value="mailinglistStatistics")
public class MailingListStatistics
implements ComponentStatisticsProvider {
    private static final String UNKNOWN_USER_ID = "-2";

    public Collection<UserIdCountVolumeCouple> getVolume(String spaceId, String componentId) {
        ArrayList<UserIdCountVolumeCouple> myArrayList = new ArrayList<UserIdCountVolumeCouple>();
        UserIdCountVolumeCouple myCouple = new UserIdCountVolumeCouple();
        myCouple.setUserId(UNKNOWN_USER_ID);
        MailingList ml = MailingListServicesProvider.getMailingListService().findMailingList(componentId);
        if (ml != null) {
            long totalNumberOfMessages = MailingListServicesProvider.getMessageService().getTotalNumberOfMessages(ml);
            myCouple.setCountVolume(totalNumberOfMessages);
        } else {
            SilverLogger.getLogger((Object)this).warn("space {0}, componentId {1} doesn't look like a mailinglist", new Object[]{spaceId, componentId});
            myCouple.setCountVolume(0L);
        }
        myArrayList.add(myCouple);
        return myArrayList;
    }
}

