/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.jetbrains.annotations.Nullable;

public class FileLineDifferenceIterator
implements Closeable,
Iterator<String> {
    private final Impl delegate;

    public FileLineDifferenceIterator(LineIterator marked, LineIterator available, @Nullable Function<String, String> transformer) throws IOException {
        this.delegate = new Impl(marked, available, transformer);
    }

    public FileLineDifferenceIterator(File marked, File available, @Nullable Function<String, String> transformer) throws IOException {
        this(FileUtils.lineIterator((File)marked, (String)StandardCharsets.UTF_8.toString()), FileUtils.lineIterator((File)available, (String)StandardCharsets.UTF_8.toString()), transformer);
    }

    public FileLineDifferenceIterator(LineIterator marked, LineIterator available) throws IOException {
        this(marked, available, null);
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public String next() {
        return (String)this.delegate.next();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static class Impl
    extends AbstractIterator<String>
    implements Closeable {
        private final PeekingIterator<String> peekMarked;
        private final LineIterator marked;
        private final LineIterator all;
        private Function<String, String> transformer = new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input;
            }
        };

        public Impl(LineIterator marked, LineIterator available, @Nullable Function<String, String> transformer) throws IOException {
            this.marked = marked;
            this.peekMarked = PeekingIterator.peekingIterator((Iterator)marked);
            this.all = available;
            if (transformer != null) {
                this.transformer = transformer;
            }
        }

        protected String computeNext() {
            String diff = this.computeNextDiff();
            if (diff == null) {
                this.close();
                return (String)this.endOfData();
            }
            return diff;
        }

        @Override
        public void close() {
            if (this.marked instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)this.marked);
            }
            if (this.all instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)this.all);
            }
        }

        private String computeNextDiff() {
            if (!this.all.hasNext()) {
                return null;
            }
            if (!this.peekMarked.hasNext()) {
                return this.all.next();
            }
            String diff = null;
            block0: while (this.all.hasNext() && diff == null) {
                diff = this.all.next();
                while (this.peekMarked.hasNext()) {
                    String marked = (String)this.peekMarked.peek();
                    int comparisonResult = this.transformer.apply(diff).compareTo(this.transformer.apply(marked));
                    if (comparisonResult > 0) {
                        this.peekMarked.next();
                        continue;
                    }
                    if (comparisonResult == 0) {
                        this.peekMarked.next();
                        diff = null;
                        continue block0;
                    }
                    return diff;
                }
            }
            return diff;
        }
    }
}

