/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.security.authorization.permission.CacheStrategy;
import org.apache.jackrabbit.oak.security.authorization.permission.NumEntries;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionCache;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryCache;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries;
import org.jetbrains.annotations.NotNull;

final class PermissionCacheBuilder {
    private final PermissionStore store;
    private final PermissionEntryCache peCache;
    private Set<String> existingNames;
    private boolean usePathEntryMap;
    private boolean initialized = false;

    PermissionCacheBuilder(@NotNull PermissionStore store) {
        this.store = store;
        this.peCache = new PermissionEntryCache();
    }

    boolean init(@NotNull Set<String> principalNames, @NotNull CacheStrategy cacheStrategy) {
        this.existingNames = new HashSet<String>();
        long cnt = 0L;
        for (String name : principalNames) {
            NumEntries ne = this.store.getNumEntries(name, cacheStrategy.maxSize());
            long n = ne.size;
            if (n > 0L) {
                this.existingNames.add(name);
                if (cacheStrategy.loadFully(n, cnt)) {
                    this.peCache.getFullyLoadedEntries(this.store, name);
                } else {
                    long expectedSize = ne.isExact ? n : Long.MAX_VALUE;
                    this.peCache.init(name, expectedSize);
                }
            }
            if (cnt >= Long.MAX_VALUE) continue;
            if (Long.MAX_VALUE == n) {
                cnt = Long.MAX_VALUE;
                continue;
            }
            cnt = LongUtils.safeAdd((long)cnt, (long)n);
        }
        this.usePathEntryMap = cacheStrategy.usePathEntryMap(cnt);
        this.initialized = true;
        return this.existingNames.isEmpty();
    }

    @NotNull
    PermissionCache build() {
        Validate.checkState((boolean)this.initialized);
        if (this.existingNames.isEmpty()) {
            return EmptyCache.INSTANCE;
        }
        if (this.usePathEntryMap) {
            HashMap<String, Collection<PermissionEntry>> pathEntryMap = new HashMap<String, Collection<PermissionEntry>>();
            for (String name : this.existingNames) {
                PrincipalPermissionEntries ppe = this.peCache.getFullyLoadedEntries(this.store, name);
                for (Map.Entry<String, Collection<PermissionEntry>> e : ppe.getEntries().entrySet()) {
                    String path = e.getKey();
                    TreeSet<PermissionEntry> pathEntries = (TreeSet<PermissionEntry>)pathEntryMap.get(path);
                    if (pathEntries == null) {
                        pathEntries = new TreeSet<PermissionEntry>(e.getValue());
                        pathEntryMap.put(path, pathEntries);
                        continue;
                    }
                    pathEntries.addAll(e.getValue());
                }
            }
            if (pathEntryMap.isEmpty()) {
                return EmptyCache.INSTANCE;
            }
            return new PathEntryMapCache(pathEntryMap);
        }
        return new DefaultPermissionCache(this.store, this.peCache, this.existingNames);
    }

    private static final class EmptyCache
    implements PermissionCache {
        private static final PermissionCache INSTANCE = new EmptyCache();

        private EmptyCache() {
        }

        @Override
        @NotNull
        public Collection<PermissionEntry> getEntries(@NotNull String path) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Collection<PermissionEntry> getEntries(@NotNull Tree accessControlledTree) {
            return Collections.emptyList();
        }
    }

    private static final class PathEntryMapCache
    implements PermissionCache {
        private final Map<String, Collection<PermissionEntry>> pathEntryMap;

        PathEntryMapCache(@NotNull Map<String, Collection<PermissionEntry>> pathEntryMap) {
            this.pathEntryMap = pathEntryMap;
        }

        @Override
        @NotNull
        public Collection<PermissionEntry> getEntries(@NotNull String path) {
            Collection<PermissionEntry> entries = this.pathEntryMap.get(path);
            return entries != null ? entries : Collections.emptyList();
        }

        @Override
        @NotNull
        public Collection<PermissionEntry> getEntries(@NotNull Tree accessControlledTree) {
            Collection<PermissionEntry> entries = this.pathEntryMap.get(accessControlledTree.getPath());
            return entries != null ? entries : Collections.emptyList();
        }
    }

    private static final class DefaultPermissionCache
    implements PermissionCache {
        private final PermissionStore store;
        private final PermissionEntryCache cache;
        private final Set<String> existingNames;

        DefaultPermissionCache(@NotNull PermissionStore store, @NotNull PermissionEntryCache cache, Set<String> existingNames) {
            this.store = store;
            this.cache = cache;
            this.existingNames = existingNames;
        }

        @Override
        @NotNull
        public Collection<PermissionEntry> getEntries(@NotNull String path) {
            TreeSet<PermissionEntry> ret = new TreeSet<PermissionEntry>();
            for (String name : this.existingNames) {
                this.cache.load(this.store, ret, name, path);
            }
            return ret;
        }

        @Override
        @NotNull
        public Collection<PermissionEntry> getEntries(@NotNull Tree accessControlledTree) {
            return accessControlledTree.hasChild("rep:policy") ? this.getEntries(accessControlledTree.getPath()) : Collections.emptyList();
        }
    }
}

