/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.spi.namespace.NamespaceConstants;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyNamespaceRegistry
implements NamespaceRegistry,
NamespaceConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyNamespaceRegistry.class);
    private static volatile boolean CONSISTENCY_CHECKED;
    protected final Tree namespaces;
    protected final Tree nsdata;

    public ReadOnlyNamespaceRegistry(Root root) {
        this.namespaces = root.getTree("/jcr:system/rep:namespaces");
        this.nsdata = this.namespaces.getChild("rep:nsdata");
        if (!CONSISTENCY_CHECKED) {
            this.checkConsistency();
        }
    }

    private Iterable<String> getNSData(String name) {
        PropertyState property = this.nsdata.getProperty(name);
        if (property != null && property.getType() == Type.STRINGS) {
            return (Iterable)property.getValue(Type.STRINGS);
        }
        return Collections.emptyList();
    }

    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNamespace(String prefix) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @NotNull
    public String[] getPrefixes() {
        ArrayList prefixes = new ArrayList();
        this.getNSData("rep:prefixes").forEach(prefixes::add);
        return prefixes.toArray(new String[prefixes.size()]);
    }

    @NotNull
    public String[] getURIs() {
        ArrayList uris = new ArrayList();
        this.getNSData("rep:uris").forEach(uris::add);
        return uris.toArray(new String[uris.size()]);
    }

    @NotNull
    public String getURI(String prefix) throws NamespaceException {
        if (prefix.isEmpty()) {
            return prefix;
        }
        PropertyState property = this.namespaces.getProperty(prefix);
        if (property != null && property.getType() == Type.STRING) {
            return (String)property.getValue(Type.STRING);
        }
        throw new NamespaceException("No namespace registered for prefix " + prefix);
    }

    @NotNull
    public String getPrefix(String uri) throws NamespaceException {
        if (uri.isEmpty()) {
            return uri;
        }
        PropertyState property = this.nsdata.getProperty(Namespaces.encodeUri(uri));
        if (property != null && property.getType() == Type.STRING) {
            return (String)property.getValue(Type.STRING);
        }
        throw new NamespaceException("No namespace prefix registered for URI " + uri);
    }

    protected void checkConsistency() {
        String jcrPrimaryType = "jcr:primaryType";
        List<String> prefixes = Arrays.asList(this.getPrefixes());
        List encodedUris = Arrays.stream(this.getURIs()).map(Namespaces::encodeUri).collect(Collectors.toList());
        if (prefixes.size() != encodedUris.size()) {
            LOG.error("The namespace registry is inconsistent: found {} registered namespace prefixes and {} registered namespace URIs. The numbers have to be equal.", (Object)prefixes.size(), (Object)encodedUris.size());
        }
        int mappedPrefixCount = 0;
        for (PropertyState propertyState : this.namespaces.getProperties()) {
            String prefix = propertyState.getName();
            if (prefix.equals("jcr:primaryType")) continue;
            ++mappedPrefixCount;
            if (!prefixes.contains(prefix)) {
                LOG.error("The namespace registry is inconsistent: namespace prefix {} is mapped to a namespace URI, but not contained in the list of registered namespace prefixes.", (Object)prefix);
            }
            try {
                this.getURI(prefix);
            }
            catch (NamespaceException e) {
                LOG.error("The namespace registry is inconsistent: namespace prefix {} is not mapped to a namespace URI.", (Object)prefix);
            }
        }
        if (mappedPrefixCount + 1 != prefixes.size()) {
            LOG.error("The namespace registry is inconsistent: found {} mapped namespace prefixes and {} registered namespace prefixes. The numbers have to be equal.", (Object)mappedPrefixCount, (Object)prefixes.size());
        }
        int mappedUriCount = 0;
        block13: for (PropertyState propertyState : this.nsdata.getProperties()) {
            String encodedUri;
            switch (encodedUri = propertyState.getName()) {
                case "rep:prefixes": 
                case "rep:uris": 
                case "jcr:primaryType": {
                    continue block13;
                }
            }
            ++mappedUriCount;
            if (!encodedUris.contains(encodedUri)) {
                LOG.error("The namespace registry is inconsistent: encoded namespace URI {} is mapped to a namespace prefix, but not contained in the list of registered namespace URIs.", (Object)encodedUri);
            }
            try {
                this.getPrefix(Text.unescapeIllegalJcrChars((String)encodedUri));
            }
            catch (NamespaceException e) {
                LOG.error("The namespace registry is inconsistent: namespace URI {} is not mapped to a namespace prefix.", (Object)encodedUri);
            }
        }
        if (mappedUriCount + 1 != encodedUris.size()) {
            LOG.error("The namespace registry is inconsistent: found {} mapped namespace URIs and {} registered namespace URIs. The numbers have to be equal.", (Object)mappedUriCount, (Object)encodedUris.size());
        }
        CONSISTENCY_CHECKED = true;
    }
}

