/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.version;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionHistoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VersionHistoryUtil.class);

    public static String getRelativeVersionHistoryPath(String versionableUuid) {
        return String.join((CharSequence)"/", IterableUtils.chainedIterable(Collections.singleton(""), VersionHistoryUtil.getRelativeVersionHistoryPathSegments(versionableUuid), Collections.singleton(versionableUuid)));
    }

    static NodeState getVersionHistoryNodeState(NodeState versionStorage, String versionableUuid) {
        NodeState historyParent = versionStorage;
        for (String segment : VersionHistoryUtil.getRelativeVersionHistoryPathSegments(versionableUuid)) {
            historyParent = historyParent.getChildNode(segment);
        }
        return historyParent.getChildNode(versionableUuid);
    }

    public static NodeBuilder getVersionHistoryBuilder(NodeBuilder versionStorage, String versionableUuid) {
        NodeBuilder history = versionStorage;
        for (String segment : VersionHistoryUtil.getRelativeVersionHistoryPathSegments(versionableUuid)) {
            history = history.getChildNode(segment);
        }
        return history.getChildNode(versionableUuid);
    }

    private static List<String> getRelativeVersionHistoryPathSegments(String versionableUuid) {
        ArrayList<String> segments = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            segments.add(versionableUuid.substring(i * 2, i * 2 + 2));
        }
        return segments;
    }

    public static NodeState getVersionStorage(NodeState root) {
        return root.getChildNode("jcr:system").getChildNode("jcr:versionStorage");
    }

    public static NodeBuilder getVersionStorage(NodeBuilder root) {
        return root.getChildNode("jcr:system").getChildNode("jcr:versionStorage");
    }

    public static NodeBuilder createVersionStorage(NodeBuilder root) {
        NodeBuilder vs = root.child("jcr:system").child("jcr:versionStorage");
        if (!vs.hasProperty("jcr:primaryType")) {
            vs.setProperty("jcr:primaryType", (Object)"rep:versionStorage", Type.NAME);
        }
        return vs;
    }

    public static List<String> getVersionableNodes(NodeState root, NodeState versionStorage, TypePredicate isVersionable, Calendar olderThan) {
        ArrayList<String> paths = new ArrayList<String>();
        VersionHistoryUtil.getVersionableNodes(root, versionStorage, isVersionable, olderThan, "/", paths);
        return paths;
    }

    private static void getVersionableNodes(NodeState node, NodeState versionStorage, TypePredicate isVersionable, Calendar olderThan, String path, List<String> paths) {
        if (isVersionable.test(node)) {
            if (olderThan == null) {
                paths.add(path);
            } else {
                NodeState versionHistory = VersionHistoryUtil.getVersionHistoryNodeState(versionStorage, node.getString("jcr:uuid"));
                Calendar lastModified = VersionHistoryUtil.getVersionHistoryLastModified(versionHistory);
                if (lastModified.before(olderThan)) {
                    paths.add(path);
                }
            }
        }
        for (ChildNodeEntry c : node.getChildNodeEntries()) {
            VersionHistoryUtil.getVersionableNodes(c.getNodeState(), versionStorage, isVersionable, olderThan, PathUtils.concat((String)path, (String)c.getName()), paths);
        }
    }

    public static Calendar getVersionHistoryLastModified(NodeState versionHistory) {
        Calendar youngest = Calendar.getInstance();
        youngest.setTimeInMillis(0L);
        for (ChildNodeEntry entry : versionHistory.getChildNodeEntries()) {
            Calendar created;
            NodeState version = entry.getNodeState();
            if (!version.hasProperty("jcr:created") || !(created = ISO8601.parse((String)((String)version.getProperty("jcr:created").getValue(Type.DATE)))).after(youngest)) continue;
            youngest = created;
        }
        return youngest;
    }

    public static void removeVersionProperties(NodeBuilder versionableBuilder, TypePredicate isReferenceable) {
        assert (versionableBuilder.exists());
        VersionHistoryUtil.removeMixin(versionableBuilder, "mix:versionable");
        if (!isReferenceable.test(versionableBuilder.getNodeState())) {
            VersionHistoryUtil.addMixin(versionableBuilder, "mix:referenceable");
        }
        versionableBuilder.removeProperty("jcr:versionHistory");
        versionableBuilder.removeProperty("jcr:predecessors");
        versionableBuilder.removeProperty("jcr:baseVersion");
        versionableBuilder.removeProperty("jcr:isCheckedOut");
    }

    static void addMixin(NodeBuilder builder, String name) {
        if (builder.hasProperty("jcr:mixinTypes")) {
            Set mixins = SetUtils.toSet((Iterable)((Iterable)builder.getProperty("jcr:mixinTypes").getValue(Type.NAMES)));
            if (mixins.add(name)) {
                builder.setProperty(MultiGenericPropertyState.nameProperty((String)"jcr:mixinTypes", (Iterable)mixins));
            }
        } else {
            builder.setProperty(MultiGenericPropertyState.nameProperty((String)"jcr:mixinTypes", Set.of(name)));
        }
    }

    private static void removeMixin(NodeBuilder builder, String name) {
        Set mixins;
        if (builder.hasProperty("jcr:mixinTypes") && (mixins = SetUtils.toSet((Iterable)((Iterable)builder.getProperty("jcr:mixinTypes").getValue(Type.NAMES)))).remove(name)) {
            if (mixins.isEmpty()) {
                builder.removeProperty("jcr:mixinTypes");
            } else {
                builder.setProperty(MultiGenericPropertyState.nameProperty((String)"jcr:mixinTypes", (Iterable)mixins));
            }
        }
    }

    public static NodeBuilder removeVersions(NodeState root, List<String> toRemove) {
        NodeBuilder rootBuilder = root.builder();
        TypePredicate isReferenceable = new TypePredicate(root, "mix:referenceable");
        NodeBuilder versionStorage = VersionHistoryUtil.getVersionStorage(rootBuilder);
        for (String p : toRemove) {
            LOG.info("Removing version history for {}", (Object)p);
            NodeBuilder b = VersionHistoryUtil.getBuilder(rootBuilder, p);
            String uuid = b.getString("jcr:uuid");
            VersionHistoryUtil.removeVersionProperties(b, isReferenceable);
            VersionHistoryUtil.getVersionHistoryBuilder(versionStorage, uuid).remove();
        }
        return rootBuilder;
    }

    private static NodeBuilder getBuilder(NodeBuilder root, String path) {
        NodeBuilder builder = root;
        for (String e : PathUtils.elements((String)path)) {
            builder = builder.child(e);
        }
        return builder;
    }
}

