/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import javax.security.auth.Subject;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.core.ContentSessionImpl;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContext;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemRoot
extends MutableRoot {
    private static final LoginContext LOGIN_CONTEXT = new LoginContext(){

        public Subject getSubject() {
            return SystemSubject.INSTANCE;
        }

        public void login() {
        }

        public void logout() {
        }
    };

    public static SystemRoot create(@NotNull NodeStore store, @NotNull CommitHook hook, @NotNull String workspaceName, @NotNull SecurityProvider securityProvider, @NotNull QueryIndexProvider indexProvider) {
        return SystemRoot.create(store, hook, workspaceName, securityProvider, null, indexProvider);
    }

    public static SystemRoot create(@NotNull NodeStore store, @NotNull CommitHook hook, @NotNull String workspaceName, @NotNull SecurityProvider securityProvider, @Nullable QueryEngineSettings queryEngineSettings, @NotNull QueryIndexProvider indexProvider) {
        if (queryEngineSettings == null) {
            queryEngineSettings = new QueryEngineSettings();
        }
        return new SystemRoot(store, hook, workspaceName, securityProvider, queryEngineSettings, indexProvider);
    }

    private SystemRoot(final @NotNull NodeStore store, final @NotNull CommitHook hook, final @NotNull String workspaceName, final @NotNull SecurityProvider securityProvider, final @NotNull QueryEngineSettings queryEngineSettings, final @NotNull QueryIndexProvider indexProvider) {
        this(store, hook, workspaceName, securityProvider, queryEngineSettings, indexProvider, new ContentSessionImpl(LOGIN_CONTEXT, securityProvider, workspaceName, store, hook, queryEngineSettings, indexProvider, null){

            @Override
            @NotNull
            public Root getLatestRoot() {
                return new SystemRoot(store, hook, workspaceName, securityProvider, queryEngineSettings, indexProvider, this);
            }
        });
    }

    private SystemRoot(@NotNull NodeStore store, @NotNull CommitHook hook, @NotNull String workspaceName, @NotNull SecurityProvider securityProvider, @Nullable QueryEngineSettings queryEngineSettings, @NotNull QueryIndexProvider indexProvider, @NotNull ContentSessionImpl session) {
        super(store, hook, workspaceName, SystemSubject.INSTANCE, securityProvider, queryEngineSettings, indexProvider, null, session);
    }
}

