/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.error;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import org.silverpeas.core.admin.component.exception.ComponentFileFilterException;
import org.silverpeas.core.admin.space.quota.process.check.exception.DataStorageQuotaException;
import org.silverpeas.core.exception.WithNested;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public class SilverpeasTransverseErrorUtil {
    public static <E extends Exception> void stopTransverseErrorIfAny(E exception) throws E {
        DataStorageQuotaException dataStorageQuotaException = SilverpeasTransverseErrorUtil.retrieveDataStorageQuotaException(exception);
        if (dataStorageQuotaException != null) {
            return;
        }
        ComponentFileFilterException componentFileFilterException = SilverpeasTransverseErrorUtil.retrieveComponentFileFilterException(exception);
        if (componentFileFilterException != null) {
            return;
        }
        throw exception;
    }

    public static <E extends Exception> void throwTransverseErrorIfAny(E exception, String language) throws DataStorageQuotaException, ComponentFileFilterException {
        DataStorageQuotaException dataStorageQuotaException = SilverpeasTransverseErrorUtil.retrieveDataStorageQuotaException(exception);
        if (dataStorageQuotaException != null) {
            dataStorageQuotaException.setLanguage(language);
            throw dataStorageQuotaException;
        }
        ComponentFileFilterException componentFileFilterException = SilverpeasTransverseErrorUtil.retrieveComponentFileFilterException(exception);
        if (componentFileFilterException != null) {
            componentFileFilterException.setLanguage(language);
            throw componentFileFilterException;
        }
    }

    public static <E extends Exception> String performExceptionMessage(E exception, String language) {
        String message = "";
        DataStorageQuotaException dsqe = SilverpeasTransverseErrorUtil.retrieveDataStorageQuotaException(exception);
        if (dsqe != null) {
            dsqe.setLanguage(language);
            SilverpeasTemplate template = SilverpeasTemplates.createSilverpeasTemplateOnCore((String)"admin/space/quota");
            template.setAttribute("maxCountFormated", (Object)UnitUtil.formatMemSize((long)dsqe.getQuota().getMaxCount()));
            template.setAttribute("spaceName", (Object)dsqe.getSpace().getName());
            template.setAttribute("isPersonalSpace", (Object)dsqe.getSpace().isPersonalSpace());
            template.setAttribute("fromComponentName", (Object)dsqe.getFromComponent());
            message = template.applyFileTemplate("dataStorageQuotaExceptionMessage_" + language);
            return message;
        }
        ComponentFileFilterException cffe = SilverpeasTransverseErrorUtil.retrieveComponentFileFilterException(exception);
        if (cffe != null) {
            cffe.setLanguage(language);
            SilverpeasTemplate template = SilverpeasTemplates.createSilverpeasTemplateOnCore((String)"admin/component/error");
            template.setAttribute("fileFilters", (Object)cffe.getComponentFileFilterParameter().getFileFilters());
            template.setAttribute("isGloballySet", (Object)cffe.getComponentFileFilterParameter().isFileFilterGloballySet());
            template.setAttribute("isAuthorized", (Object)cffe.getComponentFileFilterParameter().isAuthorization());
            template.setAttribute("forbiddenFileName", (Object)cffe.getForbiddenFileName());
            template.setAttribute("fromComponentName", (Object)cffe.getComponentFileFilterParameter().getComponent());
            message = template.applyFileTemplate("forbiddenFileMessage_" + language);
            return message;
        }
        return message;
    }

    private static <E extends Exception> DataStorageQuotaException retrieveDataStorageQuotaException(E exception) {
        return SilverpeasTransverseErrorUtil.retrieveException(exception, DataStorageQuotaException.class);
    }

    private static <E extends Exception> ComponentFileFilterException retrieveComponentFileFilterException(E exception) {
        return SilverpeasTransverseErrorUtil.retrieveException(exception, ComponentFileFilterException.class);
    }

    private static <E extends Exception, T extends Exception> E retrieveException(T exception, Class<E> exceptionClass) {
        Object throwable = exception;
        if (throwable != null) {
            while (throwable != null) {
                if (exceptionClass.isInstance(throwable)) {
                    return (E)throwable;
                }
                if (throwable instanceof WithNested) {
                    throwable = ((WithNested)throwable).getNested();
                    continue;
                }
                if (throwable instanceof RemoteException) {
                    throwable = ((RemoteException)throwable).detail;
                    continue;
                }
                if (throwable instanceof EJBException) {
                    throwable = ((EJBException)throwable).getCausedByException();
                    continue;
                }
                if (throwable instanceof SilverpeasRuntimeException && throwable.getCause() != null && !throwable.getCause().equals(throwable)) {
                    throwable = throwable.getCause();
                    continue;
                }
                throwable = null;
            }
        }
        return null;
    }
}

