/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

public enum OsEnum {
    WINDOWS_XP("Windows XP", true),
    WINDOWS_9X("win9x", true),
    WINDOWS_VISTA("Windows Vista", true),
    WINDOWS_SEVEN("Windows 7", true),
    LINUX("Linux", false),
    MAC_OSX("Mac OS X", false),
    OS_400("os/400", false),
    Z_OS("z/os", false),
    OPENVMS("openvms", false),
    NETWARE("netware", false);

    private final boolean windows;
    private final String name;

    private OsEnum(String name, boolean windows) {
        this.windows = windows;
        this.name = name;
    }

    public static OsEnum getOS(String value) {
        if (OsEnum.WINDOWS_VISTA.name.equalsIgnoreCase(value)) {
            return WINDOWS_VISTA;
        }
        if (OsEnum.WINDOWS_SEVEN.name.equalsIgnoreCase(value)) {
            return WINDOWS_SEVEN;
        }
        if (OsEnum.WINDOWS_9X.name.equalsIgnoreCase(value)) {
            return WINDOWS_9X;
        }
        if (OsEnum.WINDOWS_XP.name.equalsIgnoreCase(value) || value.startsWith("Windows ")) {
            return WINDOWS_XP;
        }
        if (OsEnum.LINUX.name.equalsIgnoreCase(value)) {
            return LINUX;
        }
        if (OsEnum.MAC_OSX.name.equalsIgnoreCase(value)) {
            return MAC_OSX;
        }
        if (OsEnum.OS_400.name.equalsIgnoreCase(value)) {
            return OS_400;
        }
        if (OsEnum.Z_OS.name.equalsIgnoreCase(value)) {
            return Z_OS;
        }
        if (OsEnum.NETWARE.name.equalsIgnoreCase(value)) {
            return NETWARE;
        }
        return WINDOWS_XP;
    }

    public static OsEnum getOS() {
        return OsEnum.getOS(System.getProperty("os.name"));
    }

    public boolean isWindows() {
        return this.windows;
    }
}

