/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.service;

import java.text.MessageFormat;
import java.util.Optional;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.AbstractSubscriptionSubscriber;
import org.silverpeas.core.subscription.service.SubscribeRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class GroupSubscriptionSubscriber
extends AbstractSubscriptionSubscriber {
    public static GroupSubscriptionSubscriber from(String groupId) {
        return new GroupSubscriptionSubscriber(groupId);
    }

    protected GroupSubscriptionSubscriber(String id) {
        super(id, SubscriberType.GROUP);
    }

    @Override
    public void checkValid() throws SubscribeRuntimeException {
        if (StringUtil.isNotDefined((String)this.getId())) {
            throw new SubscribeRuntimeException("group identifier is not specified");
        }
        Group user = Optional.ofNullable(Group.getById((String)this.getId())).orElseThrow(() -> new SubscribeRuntimeException(MessageFormat.format("group with identifier {0} not found", this.getId())));
        user.getAllUsers().forEach(u -> {
            if (u.isAnonymous() || u.isAccessGuest()) {
                throw new SubscribeRuntimeException("group contains an anonymous or a guest user");
            }
        });
    }
}

