/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.service;

import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.constant.SubscriptionMethod;

public abstract class AbstractSubscription<R extends SubscriptionResource>
implements Subscription {
    private final R resource;
    private final SubscriptionSubscriber subscriber;
    private SubscriptionMethod subscriptionMethod;
    private final String creatorId;
    private Date creationDate;

    protected AbstractSubscription(SubscriptionSubscriber subscriber, R resource, String creatorId) {
        this(subscriber, resource, SubscriptionMethod.UNKNOWN, creatorId, null);
    }

    protected AbstractSubscription(SubscriptionSubscriber subscriber, R resource, SubscriptionMethod subscriptionMethod, String creatorId, Date creationDate) {
        this.subscriber = subscriber;
        this.resource = resource;
        this.subscriptionMethod = subscriptionMethod == null || !subscriptionMethod.isValid() ? (SubscriberType.GROUP.equals((Object)subscriber.getType()) || !subscriber.getId().equals(creatorId) ? SubscriptionMethod.FORCED : (SubscriberType.USER.equals((Object)subscriber.getType()) ? SubscriptionMethod.SELF_CREATION : SubscriptionMethod.UNKNOWN)) : subscriptionMethod;
        this.creatorId = creatorId;
        this.creationDate = creationDate;
    }

    protected void setSubscriptionMethod(SubscriptionMethod subscriptionMethod) {
        this.subscriptionMethod = subscriptionMethod;
    }

    protected void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public SubscriptionSubscriber getSubscriber() {
        return this.subscriber;
    }

    public R getResource() {
        return this.resource;
    }

    @Override
    public SubscriptionMethod getSubscriptionMethod() {
        return this.subscriptionMethod;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSubscription that = (AbstractSubscription)o;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.subscriber, (Object)that.subscriber);
        builder.append(this.resource, that.resource);
        builder.append((Object)this.subscriptionMethod, (Object)that.subscriptionMethod);
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.subscriber);
        builder.append(this.resource);
        builder.append((Object)this.subscriptionMethod);
        return builder.toHashCode();
    }
}

