/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.model;

import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.silverpeas.core.persistence.datasource.model.CompositeEntityIdentifier;
import org.silverpeas.core.socialnetwork.model.SocialNetworkID;

@Embeddable
public class ExternalAccountIdentifier
implements CompositeEntityIdentifier {
    private static final long serialVersionUID = -9044047461214852788L;
    @Enumerated(value=EnumType.STRING)
    private SocialNetworkID networkId = null;
    private String profileId = null;

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public SocialNetworkID getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(SocialNetworkID networkId) {
        this.networkId = networkId;
    }

    public ExternalAccountIdentifier(SocialNetworkID networkId, String profileId) {
        this.networkId = networkId;
        this.profileId = profileId;
    }

    public ExternalAccountIdentifier() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.networkId == null ? 0 : this.networkId.hashCode());
        result = 31 * result + (this.profileId == null ? 0 : this.profileId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalAccountIdentifier other = (ExternalAccountIdentifier)obj;
        if (this.networkId != other.networkId) {
            return false;
        }
        return !(this.profileId == null ? other.profileId != null : !this.profileId.equals(other.profileId));
    }

    public String asString() {
        return this.networkId.name() + ":" + this.profileId;
    }

    public ExternalAccountIdentifier fromString(String ... values) {
        this.networkId = SocialNetworkID.from(values[0]);
        this.profileId = values[1];
        return this;
    }
}

