/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.connectors;

import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.socialnetwork.connectors.AbstractSocialNetworkConnector;
import org.silverpeas.core.socialnetwork.service.AccessToken;
import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.api.impl.LinkedInTemplate;
import org.springframework.social.linkedin.connect.LinkedInConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;

@org.silverpeas.core.socialnetwork.qualifiers.LinkedIn
@Service
@Singleton
public class LinkedInConnector
extends AbstractSocialNetworkConnector {
    private LinkedInConnectionFactory connectionFactory = null;
    private String consumerKey = null;
    private String secretKey = null;

    @Override
    @PostConstruct
    void init() {
        super.init();
        this.consumerKey = this.getSettings().getString("linkedIn.consumerKey");
        this.secretKey = this.getSettings().getString("linkedIn.secretKey");
        this.connectionFactory = new LinkedInConnectionFactory(this.consumerKey, this.secretKey);
    }

    @Override
    public String getUserProfileId(AccessToken authorizationToken) {
        AccessGrant accessGrant = authorizationToken.getAccessGrant();
        return ((LinkedIn)this.getConnectionFactory().createConnection(accessGrant).getApi()).profileOperations().getUserProfile().getId();
    }

    @Override
    public void updateStatus(AccessToken authorizationToken, String status) {
        LinkedInTemplate linkedIn = new LinkedInTemplate(authorizationToken.getAccessGrant().getAccessToken());
        linkedIn.networkUpdateOperations().createNetworkUpdate(status);
    }

    @Override
    public void setJavascriptAttributes(HttpServletRequest request) {
        request.setAttribute("LI_loadSDK", (Object)this.getSDKLoadingScript());
    }

    protected LinkedInConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    private String getSDKLoadingScript() {
        StringBuilder code = new StringBuilder();
        code.append("<script type=\"text/javascript\">\n");
        code.append("function onLoadLinkedIn() {\n");
        code.append("   if (initLI) { initLI() };\n");
        code.append(" };\n");
        code.append("</script>\n");
        code.append("<script type=\"text/javascript\" src=\"http://platform.linkedin.com/in.js\">\n");
        code.append("  api_key: ").append(this.consumerKey).append("\n");
        code.append("  onLoad: onLoadLinkedIn\n");
        code.append("  authorize: true\n");
        code.append("</script>\n");
        return code.toString();
    }
}

